/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.codecompletion;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.action.AbstractScoutHandler;
import org.eclipse.scout.sdk.ui.executor.AbstractWizardExecutor;
import org.eclipse.scout.sdk.ui.executor.selection.ScoutStructuredSelection;
import org.eclipse.scout.sdk.ui.extensions.executor.IExecutor;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.codecompletion.AbstractSdkProposal;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.DeleteEdit;

public abstract class AbstractSdkWizardProposal
extends AbstractSdkProposal {
    private final IType m_declaringType;
    private final IType m_siblingSubTypeFilter;
    private final int m_startOffset;

    protected AbstractSdkWizardProposal(IType declaringType, IType siblingSubTypeFilter, int startOffset) {
        this.m_declaringType = declaringType;
        this.m_siblingSubTypeFilter = siblingSubTypeFilter;
        this.m_startOffset = startOffset;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    protected abstract IExecutor createExecutor();

    protected IJavaElement findSibling(int sourceRangeOffset) {
        IJavaElement sibling = null;
        try {
            ITypeFilter filter = null;
            if (this.m_siblingSubTypeFilter != null) {
                filter = TypeFilters.getSubtypeFilter((IType)this.m_siblingSubTypeFilter);
            }
            sibling = this.findSibling(this.getDeclaringType(), sourceRangeOffset, filter);
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logWarning("could not find sibling in type '" + this.getDeclaringType().getFullyQualifiedName() + "'.", e);
        }
        return sibling;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        SiblingProposal proposal = null;
        IJavaElement sibling = this.findSibling(offset);
        if (TypeUtility.exists((IJavaElement)sibling)) {
            proposal = new SiblingProposal(sibling);
        }
        String name = null;
        P_RemovePrefixOperation removePrefixOp = null;
        if (this.m_startOffset >= 0) {
            ICompilationUnit icu = this.getDeclaringType().getCompilationUnit();
            IDocument document = viewer.getDocument();
            String source = document.get();
            if (source != null && source.length() >= offset && offset >= this.m_startOffset) {
                name = NamingUtility.ensureStartWithUpperCase((String)source.substring(this.m_startOffset, offset));
                removePrefixOp = new P_RemovePrefixOperation(icu, document, viewer.getTextWidget().getDisplay(), this.m_startOffset, offset);
            }
        }
        ScoutStructuredSelection selection = new ScoutStructuredSelection(new Object[]{this.getDeclaringType()});
        selection.setSibling(proposal);
        selection.setTypeName(name);
        IExecutor executor = this.createExecutor();
        if (removePrefixOp != null && executor instanceof AbstractWizardExecutor) {
            AbstractWizardExecutor wizEx = (AbstractWizardExecutor)executor;
            wizEx.addAdditionalPerformFinishOperation(removePrefixOp, -10.0);
        }
        Shell shell = ScoutSdkUi.getShell();
        ExecutionEvent event = AbstractScoutHandler.createEvent(shell, (IStructuredSelection)selection);
        executor.run(shell, (IStructuredSelection)selection, event);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return true;
    }

    private static final class P_RemovePrefixOperation
    implements IOperation {
        private final IDocument m_document;
        private final int m_start;
        private final int m_end;
        private final ICompilationUnit m_icu;
        private final Display m_display;

        private P_RemovePrefixOperation(ICompilationUnit icu, IDocument doc, Display display, int start, int end) {
            this.m_document = doc;
            this.m_display = display;
            this.m_start = start;
            this.m_end = end;
            this.m_icu = icu;
        }

        public String getOperationName() {
            return "Remove Prefix";
        }

        public void validate() {
        }

        public void run(final IProgressMonitor monitor, final IWorkingCopyManager workingCopyManager) throws CoreException {
            final DeleteEdit removePrefix = new DeleteEdit(this.m_start, this.m_end - this.m_start);
            Holder exHolder = new Holder(Exception.class, null);
            this.m_display.syncExec(new Runnable((IHolder)exHolder){
                private final /* synthetic */ IHolder val$exHolder;
                {
                    this.val$exHolder = iHolder;
                }

                @Override
                public void run() {
                    try {
                        workingCopyManager.register(P_RemovePrefixOperation.this.m_icu, monitor);
                        removePrefix.apply(P_RemovePrefixOperation.this.m_document);
                    }
                    catch (Exception e) {
                        this.val$exHolder.setValue((Object)e);
                    }
                }
            });
            Exception e = (Exception)exHolder.getValue();
            if (e != null) {
                throw new CoreException((IStatus)new ScoutStatus("Unable to delete prefix.", (Throwable)e));
            }
            this.m_icu.getBuffer().setContents(this.m_document.get());
            workingCopyManager.reconcile(this.m_icu, monitor);
        }
    }
}

