/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.service;

import org.eclipse.scout.commons.holders.IntegerHolder;
import org.eclipse.scout.sdk.service.IMessageBoxService;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SwtMessageBoxService
implements IMessageBoxService {
    public IMessageBoxService.YesNo showYesNoQuestion(String title, String message, IMessageBoxService.YesNo defaultAnswer) {
        int button = this.showMessageBox(title, message, 196);
        switch (button) {
            case 64: {
                return IMessageBoxService.YesNo.YES;
            }
            case 128: {
                return IMessageBoxService.YesNo.NO;
            }
        }
        return defaultAnswer;
    }

    public void showWarning(String title, String message) {
        this.showMessageBox(title, message, 40);
    }

    protected int showMessageBox(final String title, final String message, final int style) {
        final IntegerHolder result = new IntegerHolder(Integer.valueOf(0));
        final Display display = this.getDisplay();
        if (display != null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = display.getActiveShell();
                    if (shell == null) {
                        return;
                    }
                    MessageBox box = new MessageBox(shell, style);
                    box.setText(title);
                    box.setMessage(message);
                    result.setValue((Object)box.open());
                }
            });
        }
        return (Integer)result.getValue();
    }

    protected Display getDisplay() {
        Display d = Display.getDefault();
        if (d == null) {
            d = PlatformUI.getWorkbench().getDisplay();
        }
        return d;
    }
}

