/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client;

import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.create.OutlineNewAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.OutlineNodePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.jdt.IJavaResourceChangedListener;
import org.eclipse.scout.sdk.util.jdt.JdtEvent;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ICachedTypeHierarchy;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchyChangedListener;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;

public class DesktopOutlineTablePage
extends AbstractPage {
    private IType m_desktopType;
    private P_MethodListener m_methodListener;
    private ICachedTypeHierarchy m_outlineTypeHierarchy;

    public DesktopOutlineTablePage(IPage parentPage, IType desktopType) {
        super.setParent(parentPage);
        this.setName(Texts.get((String)"OutlineTablePage"));
        this.m_desktopType = desktopType;
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("outlines.png"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.DesktopOutlineTablePage";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public IType getDesktopType() {
        return this.m_desktopType;
    }

    @Override
    public void unloadPage() {
        if (this.m_methodListener != null) {
            ScoutSdkCore.getJavaResourceChangedEmitter().removeMethodChangedListener(this.getDesktopType(), (IJavaResourceChangedListener)this.m_methodListener);
            this.m_methodListener = null;
        }
        if (this.m_outlineTypeHierarchy != null) {
            this.m_outlineTypeHierarchy.removeHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
            this.m_outlineTypeHierarchy = null;
        }
        super.unloadPage();
    }

    @Override
    protected void loadChildrenImpl() {
        IType iOutline = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.IOutline");
        if (this.m_outlineTypeHierarchy == null) {
            this.m_outlineTypeHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iOutline);
            this.m_outlineTypeHierarchy.addHierarchyListener((ITypeHierarchyChangedListener)this.getPageDirtyListener());
        }
        if (this.m_methodListener == null) {
            this.m_methodListener = new P_MethodListener();
            ScoutSdkCore.getJavaResourceChangedEmitter().addMethodChangedListener(this.getDesktopType(), (IJavaResourceChangedListener)this.m_methodListener);
        }
        try {
            IMethod outlinesMethod = TypeUtility.getMethod((IType)this.getDesktopType(), (String)"getConfiguredOutlines");
            if (outlinesMethod != null) {
                List outlineCandidates = ScoutTypeUtility.getTypeOccurenceInMethod((IMethod)outlinesMethod);
                for (IType candidate : outlineCandidates) {
                    if (!this.m_outlineTypeHierarchy.isSubtype(iOutline, candidate)) continue;
                    new OutlineNodePage(this, candidate);
                }
            }
        }
        catch (Exception e) {
            ScoutSdkUi.logError("error during loading children of '" + this.getClass().getName() + "'.", e);
        }
    }

    @Override
    public Set<Class<? extends IScoutHandler>> getSupportedMenuActions() {
        return this.newSet(OutlineNewAction.class);
    }

    private class P_MethodListener
    implements IJavaResourceChangedListener {
        private P_MethodListener() {
        }

        public void handleEvent(JdtEvent event) {
            if (event.getElement().getElementName().equals("getConfiguredOutlines")) {
                DesktopOutlineTablePage.this.markStructureDirty();
            }
        }
    }
}

