/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.wizard.export;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.export.ExportEarOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.export.ExportScoutProjectEntry;
import org.eclipse.scout.sdk.ui.internal.wizard.export.ExportScoutProjectWizardPage;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.export.IExportScoutProjectWizard;
import org.eclipse.scout.sdk.ui.wizard.export.IExportScoutProjectWizardPage;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.resources.IResourceFilter;
import org.eclipse.scout.sdk.util.resources.ResourceFilters;
import org.eclipse.scout.sdk.util.resources.ResourceUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.ui.IWorkbench;

public class ExportScoutProjectWizard
extends AbstractWorkspaceWizard
implements IExportScoutProjectWizard {
    private static final Pattern ALIAS_REGEX = Pattern.compile(".*products.*/([^-]*)-.*.product");
    private ExportScoutProjectWizardPage m_page1;
    private IScoutBundle m_project;
    private String m_projectAlias;

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Texts.get((String)"ExportScoutProject"));
        this.m_project = UiUtility.getScoutBundleFromSelection(selection);
        this.m_projectAlias = this.findProjectAlias();
        this.m_page1 = new ExportScoutProjectWizardPage(this.m_project);
        this.addPage((IWizardPage)this.m_page1);
    }

    @Override
    public IExportScoutProjectWizardPage getExportWizardPage() {
        return this.m_page1;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        ExportScoutProjectEntry[] selectedEntries = this.m_page1.getSelectedEntries();
        ArrayList<File> artifacts = new ArrayList<File>();
        ExportScoutProjectEntry[] exportScoutProjectEntryArray = selectedEntries;
        int n = selectedEntries.length;
        int n2 = 0;
        while (n2 < n) {
            ExportScoutProjectEntry entry = exportScoutProjectEntryArray[n2];
            File module = entry.getHandler().createModule(this, monitor, workingCopyManager);
            if (module != null && module.exists()) {
                artifacts.add(module);
            }
            ++n2;
        }
        if (artifacts.size() > 0) {
            if (this.m_page1.isExportEar()) {
                ExportEarOperation op = new ExportEarOperation();
                op.addModule(artifacts.toArray(new File[artifacts.size()]));
                op.setEarFileName(new File(this.m_page1.getTargetDirectory(), this.m_page1.getEarName()).getAbsolutePath());
                op.validate();
                op.run(monitor, workingCopyManager);
            } else {
                for (File artifact : artifacts) {
                    try {
                        ResourceUtility.moveFile((File)artifact, (File)this.m_page1.getTargetDirectory());
                    }
                    catch (IOException e) {
                        throw new CoreException((IStatus)new ScoutStatus((Throwable)e));
                    }
                }
            }
            for (File artifact : artifacts) {
                IOUtility.deleteDirectory((File)artifact.getParentFile());
            }
        }
        return true;
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }

    @Override
    public IScoutBundle getProject() {
        return this.m_project;
    }

    @Override
    public String getProjectAlias() {
        return this.m_projectAlias;
    }

    private String findProjectAlias() {
        try {
            HashMap<String, Integer> aliasList = new HashMap<String, Integer>();
            List prodFiles = ResourceUtility.getAllResources((IResourceFilter)ResourceFilters.getProductFileByContentFilter((boolean)false, (String[])new String[]{this.getProject().getSymbolicName()}));
            for (IResource f : prodFiles) {
                String alias = this.getAliasFromProductFile((IFile)f);
                if (alias == null) continue;
                Integer i = (Integer)aliasList.get(alias);
                if (i == null) {
                    i = 0;
                }
                i = i + 1;
                aliasList.put(alias, i);
            }
            String ret = null;
            Integer last = null;
            for (Map.Entry e : aliasList.entrySet()) {
                if (last != null && last >= (Integer)e.getValue()) continue;
                ret = (String)e.getKey();
                last = (Integer)e.getValue();
            }
            return ret;
        }
        catch (CoreException e) {
            ScoutSdkUi.logWarning(e);
            return null;
        }
    }

    private String getAliasFromProductFile(IFile prodFile) {
        if (prodFile == null || !prodFile.exists()) {
            return null;
        }
        String path = prodFile.getFullPath().toString();
        Matcher m = ALIAS_REGEX.matcher(path);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }
}

