/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.view.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.sdk.ui.view.properties.IPropertyPageSection;

public abstract class AbstractPropertyPageSection
implements IPropertyPageSection {
    private final String m_name;
    private final String m_desc;
    private final int m_logicalHeight;
    private final List<Object> m_properties;
    private boolean m_expanded;

    public AbstractPropertyPageSection(String name, String description, int logicalHeight) {
        this.m_name = name;
        this.m_desc = description;
        this.m_logicalHeight = logicalHeight;
        this.m_expanded = true;
        this.m_properties = new ArrayList<Object>();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getDescription() {
        return this.m_desc;
    }

    @Override
    public int getLogicalHeight() {
        return this.m_logicalHeight;
    }

    @Override
    public List<Object> getProperties() {
        return new ArrayList<Object>(this.m_properties);
    }

    @Override
    public int getPropertyCount() {
        return this.m_properties.size();
    }

    @Override
    public void addProperty(Object p) {
        this.m_properties.add(p);
    }

    @Override
    public boolean isExpanded() {
        return this.m_expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.m_expanded = expanded;
    }
}

