/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.form.SearchFormNewOperation;
import org.eclipse.scout.sdk.ui.fields.bundletree.DndEvent;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeDndListener;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNode;
import org.eclipse.scout.sdk.ui.fields.bundletree.ITreeNodeFilter;
import org.eclipse.scout.sdk.ui.fields.bundletree.NodeFilters;
import org.eclipse.scout.sdk.ui.fields.bundletree.TreeUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.BundleTreeWizardPage;
import org.eclipse.scout.sdk.ui.wizard.IStatusProvider;
import org.eclipse.scout.sdk.ui.wizard.form.SearchFormNewWizardPage;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.ui.IWorkbench;

public class SearchFormNewWizard
extends AbstractWorkspaceWizard {
    public static final String TYPE_SEARCH_FORM = "searchForm";
    public static final String TYPE_SEARCH_FORM_DATA = "searchFormData";
    public static final String TYPE_HANDLER_SEARCH = "searchHandler";
    private SearchFormNewWizardPage m_page1;
    private BundleTreeWizardPage m_page2;
    private SearchFormNewOperation m_operation;
    private ITreeNode m_locationPageRoot;

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        IMethod titleMethod;
        this.setWindowTitle(Texts.get((String)"NewSearchForm"));
        IScoutBundle clientBundle = UiUtility.getScoutBundleFromSelection(selection, ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}));
        String pck = UiUtility.getPackageSuffix(selection);
        IType tablePageType = UiUtility.getTypeFromSelection(selection, TypeFilters.getSubtypeFilter((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable"));
        INlsEntry nlsEntry = null;
        if (TypeUtility.exists((IJavaElement)tablePageType) && TypeUtility.exists((IJavaElement)(titleMethod = TypeUtility.getMethod((IType)tablePageType, (String)"getConfiguredTitle")))) {
            try {
                nlsEntry = ScoutUtility.getReturnNlsEntry((IMethod)titleMethod);
            }
            catch (CoreException e) {
                ScoutSdkUi.logWarning("could not parse nls entry for method '" + titleMethod.getElementName() + "'.", e);
            }
        }
        P_StatusRevalidator statusProvider = new P_StatusRevalidator();
        this.m_page1 = new SearchFormNewWizardPage(clientBundle);
        if (StringUtility.hasText((CharSequence)pck)) {
            this.m_page1.setTargetPackage(pck);
        }
        this.m_page1.addStatusProvider(statusProvider);
        this.m_page1.setTablePageType(tablePageType);
        this.m_page1.setNlsName(nlsEntry);
        if (nlsEntry != null) {
            this.m_page1.setTypeName(String.valueOf(nlsEntry.getKey()) + "SearchForm");
        }
        this.addPage((IWizardPage)this.m_page1);
        if (clientBundle != null) {
            this.m_locationPageRoot = this.createTree(clientBundle);
            this.m_page2 = new BundleTreeWizardPage(Texts.get((String)"SearchFormClassLocations"), Texts.get((String)"OrganiseLocations"), this.m_locationPageRoot, new P_InitialCheckedFilter());
            this.m_page2.addStatusProvider(statusProvider);
            this.m_page2.addDndListener(new P_TreeDndListener());
            this.addPage((IWizardPage)this.m_page2);
            this.m_page1.addPropertyChangeListener(new P_LocationPropertyListener());
        }
    }

    private ITreeNode createTree(IScoutBundle clientBundle) {
        IScoutBundle sharedBundle = clientBundle.getParentBundle(ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"})}), false);
        IScoutBundleFilter bundleFilter = ScoutBundleFilters.getMultiFilterAnd((IScoutBundleFilter[])new IScoutBundleFilter[]{ScoutBundleFilters.getWorkspaceBundlesFilter(), ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT", "SHARED"})});
        ITreeNode rootNode = TreeUtility.createBundleTree(clientBundle, bundleFilter);
        ITreeNode clientNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(clientBundle));
        ITreeNode formNode = TreeUtility.createNode(clientNode, TYPE_SEARCH_FORM, Texts.get((String)"SearchForm"), ScoutSdkUi.getImageDescriptor("class_obj.gif"));
        TreeUtility.createNode(formNode, TYPE_HANDLER_SEARCH, Texts.get((String)"SearchHandler"), ScoutSdkUi.getImageDescriptor("class_obj.gif"));
        if (sharedBundle != null) {
            ITreeNode sharedNode = TreeUtility.findNode(rootNode, NodeFilters.getByData(sharedBundle));
            TreeUtility.createNode(sharedNode, TYPE_SEARCH_FORM_DATA, Texts.get((String)"SearchFormData"), ScoutSdkUi.getImageDescriptor("class_obj.gif"));
        }
        return rootNode;
    }

    @Override
    protected boolean beforeFinish() throws CoreException {
        IScoutBundle searchFormBundle = this.m_page2.getLocationBundle(TYPE_SEARCH_FORM, true, true);
        this.m_operation = new SearchFormNewOperation(this.m_page1.getTypeName(), searchFormBundle.getPackageName(this.m_page1.getTargetPackage("client.searchform")), ScoutUtility.getJavaProject((IScoutBundle)searchFormBundle));
        this.m_operation.setNlsEntry(this.m_page1.getNlsName());
        IType superTypeProp = this.m_page1.getSuperType();
        if (superTypeProp != null) {
            this.m_operation.setSuperTypeSignature(SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName()));
        }
        this.m_operation.setTablePage(this.m_page1.getTablePageType());
        this.m_operation.setCreateSearchHandler(this.m_page2.getTreeNode(TYPE_HANDLER_SEARCH, true, true) != null);
        IScoutBundle searchFormDataBundle = this.m_page2.getLocationBundle(TYPE_SEARCH_FORM_DATA, true, true);
        this.m_operation.setSearchFormDataLocationBundle(searchFormDataBundle);
        this.m_operation.setSearchFormDataPackageName(searchFormDataBundle.getPackageName(this.m_page1.getTargetPackage("shared.services")));
        return true;
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) {
        try {
            this.m_operation.run(monitor, workingCopyManager);
            return true;
        }
        catch (Exception e) {
            ScoutSdkUi.logError("exception during perfoming finish of wizard.", e);
            return false;
        }
    }

    private static class P_InitialCheckedFilter
    implements ITreeNodeFilter {
        private P_InitialCheckedFilter() {
        }

        @Override
        public boolean accept(ITreeNode node) {
            return TreeUtility.isOneOf(node.getType(), SearchFormNewWizard.TYPE_HANDLER_SEARCH, SearchFormNewWizard.TYPE_SEARCH_FORM, SearchFormNewWizard.TYPE_SEARCH_FORM_DATA);
        }
    }

    private class P_LocationPropertyListener
    implements PropertyChangeListener {
        private P_LocationPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("typeName")) {
                String typeName = SearchFormNewWizard.this.m_page1.getTypeName();
                if (!StringUtility.isNullOrEmpty((CharSequence)typeName)) {
                    String prefix = typeName.replaceAll("SearchForm$", "");
                    TreeUtility.findNode(SearchFormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(SearchFormNewWizard.TYPE_SEARCH_FORM)).setText(String.valueOf(prefix) + "SearchForm");
                    TreeUtility.findNode(SearchFormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(SearchFormNewWizard.TYPE_SEARCH_FORM_DATA)).setText(String.valueOf(prefix) + "SearchFormData");
                    SearchFormNewWizard.this.m_page2.refreshTree();
                }
                SearchFormNewWizard.this.m_page2.pingStateChanging();
            }
        }
    }

    private class P_StatusRevalidator
    implements IStatusProvider {
        private P_StatusRevalidator() {
        }

        @Override
        public void validate(Object source, MultiStatus multiStatus) {
            multiStatus.add(this.getStatusSearchForm(source));
            multiStatus.add(this.getStatusTypeNames(source));
        }

        protected IStatus getStatusTypeNames(Object source) {
            ITreeNode formDataNode;
            IScoutBundle formDataBundle;
            ITreeNode searchFormNode;
            if (SearchFormNewWizard.this.m_page2 == null) {
                return Status.OK_STATUS;
            }
            IScoutBundle searchFormBundle = SearchFormNewWizard.this.m_page2.getLocationBundle(SearchFormNewWizard.TYPE_SEARCH_FORM, true, true);
            if (searchFormBundle != null && (searchFormNode = SearchFormNewWizard.this.m_page2.getTreeNode(SearchFormNewWizard.TYPE_SEARCH_FORM, true, true)) != null) {
                try {
                    String fqn = String.valueOf(searchFormBundle.getPackageName(SearchFormNewWizard.this.m_page1.getTargetPackage("client.searchform"))) + "." + searchFormNode.getText();
                    if (searchFormBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(source instanceof SearchFormNewWizardPage ? 4 : 2, "org.eclipse.scout.sdk.ui", "'" + searchFormNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            if ((formDataBundle = SearchFormNewWizard.this.m_page2.getLocationBundle(SearchFormNewWizard.TYPE_SEARCH_FORM_DATA, true, true)) != null && (formDataNode = SearchFormNewWizard.this.m_page2.getTreeNode(SearchFormNewWizard.TYPE_SEARCH_FORM_DATA, true, true)) != null) {
                try {
                    String fqn = String.valueOf(formDataBundle.getPackageName(SearchFormNewWizard.this.m_page1.getTargetPackage("shared.services"))) + "." + formDataNode.getText();
                    if (formDataBundle.getJavaProject().findType(fqn) != null) {
                        return new Status(source instanceof SearchFormNewWizardPage ? 2 : 4, "org.eclipse.scout.sdk.ui", "'" + formDataNode.getText() + "' " + Texts.get((String)"AlreadyExists") + ".");
                    }
                }
                catch (JavaModelException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"AnErrorOccured"));
                }
            }
            return Status.OK_STATUS;
        }

        protected IStatus getStatusSearchForm(Object source) {
            IScoutBundle formDataBundle;
            IScoutBundle formBundle;
            if (SearchFormNewWizard.this.m_page2 != null && (formBundle = SearchFormNewWizard.this.m_page2.getLocationBundle(SearchFormNewWizard.TYPE_SEARCH_FORM, true, true)) != null && (formDataBundle = SearchFormNewWizard.this.m_page2.getLocationBundle(SearchFormNewWizard.TYPE_SEARCH_FORM_DATA, true, true)) != null && !ScoutTypeUtility.isOnClasspath((IScoutBundle)formDataBundle, (IScoutBundle)formBundle)) {
                return new Status(source instanceof SearchFormNewWizardPage ? 2 : 4, "org.eclipse.scout.sdk.ui", Texts.get((String)"XIsNotAClasspathOfY", (String[])new String[]{SearchFormNewWizard.this.m_page2.getTextOfNode(SearchFormNewWizard.TYPE_SEARCH_FORM_DATA), SearchFormNewWizard.this.m_page2.getTextOfNode(SearchFormNewWizard.TYPE_SEARCH_FORM)}));
            }
            return Status.OK_STATUS;
        }
    }

    private class P_TreeDndListener
    implements ITreeDndListener {
        private P_TreeDndListener() {
        }

        @Override
        public boolean isDragableNode(ITreeNode node) {
            return SearchFormNewWizard.TYPE_SEARCH_FORM.equals(node.getType());
        }

        @Override
        public void validateTarget(DndEvent dndEvent) {
            if (dndEvent.targetParent == null) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.targetParent.getData() instanceof IScoutBundle && ((IScoutBundle)dndEvent.targetParent.getData()).isBinary()) {
                dndEvent.doit = false;
                return;
            }
            if (dndEvent.operation == 1) {
                this.validateDropCopy(dndEvent);
            } else if (dndEvent.operation == 2) {
                this.validateDropMove(dndEvent);
            }
        }

        @Override
        public void dndPerformed(DndEvent dndEvent) {
            ITreeNode formDataNode;
            if (dndEvent.node.getType() == SearchFormNewWizard.TYPE_SEARCH_FORM && (formDataNode = TreeUtility.findNode(SearchFormNewWizard.this.m_locationPageRoot, NodeFilters.getByType(SearchFormNewWizard.TYPE_SEARCH_FORM_DATA))) != null) {
                ITreeNode oldFomDataParent = formDataNode.getParent();
                IScoutBundle formBundle = (IScoutBundle)dndEvent.node.getParent().getData();
                Set sharedBundles = formBundle.getParentBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"SHARED"}), false);
                for (IScoutBundle formDataBundle : sharedBundles) {
                    ITreeNode sharedNode = TreeUtility.findNode(SearchFormNewWizard.this.m_locationPageRoot, NodeFilters.getByData(formDataBundle));
                    if (sharedNode == null) continue;
                    if (oldFomDataParent.equals(sharedNode)) break;
                    oldFomDataParent.removeChild(formDataNode);
                    formDataNode.setParent(sharedNode);
                    sharedNode.addChild(formDataNode);
                    break;
                }
            }
            SearchFormNewWizard.this.m_page1.pingStateChanging();
        }

        private void validateDropCopy(DndEvent dndEvent) {
            dndEvent.doit = false;
        }

        private void validateDropMove(DndEvent dndEvent) {
            dndEvent.doit = SearchFormNewWizard.TYPE_SEARCH_FORM.equals(dndEvent.node.getType()) ? "CLIENT".equals(dndEvent.targetParent.getType()) : false;
        }
    }
}

