/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.fields;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.annotations.ScoutSdkIgnore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.executor.selection.ScoutStructuredSelection;
import org.eclipse.scout.sdk.ui.extensions.AbstractInnerTypeWizard;
import org.eclipse.scout.sdk.ui.extensions.IFormFieldExtension;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.fields.table.ISeparator;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.FormFieldExtensionPoint;
import org.eclipse.scout.sdk.ui.wizard.AbstractScoutWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWizard;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.fields.FormFieldNewWizard;
import org.eclipse.scout.sdk.util.jdt.JdtUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class FormFieldSelectionWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType m_declaringType;
    private AbstractScoutWizardPage m_nextPage;
    private Object m_currentSelection;
    private Set<IType> m_modelTypeShortList;
    private String m_typeName;
    private IJavaElement m_sibling;
    private FilteredTable m_table;

    public FormFieldSelectionWizardPage(IType declaringType) {
        super(FormFieldSelectionWizardPage.class.getName());
        this.m_declaringType = declaringType;
        this.setTitle(Texts.get((String)"FormField"));
        this.setDescription(Texts.get((String)"FormFieldDesc"));
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_modelTypeShortList = new HashSet<IType>();
        IType iFormField = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.fields.IFormField");
        Set abstractFormFields = TypeUtility.getAbstractTypesOnClasspath((IType)iFormField, (IJavaProject)this.m_declaringType.getJavaProject(), (ITypeFilter)TypeFilters.getPrimaryTypeFilter());
        ArrayList<1> elements = new ArrayList<1>(abstractFormFields.size() + 1);
        elements.add(new ISeparator(){});
        ITypeHierarchy abstractFormFieldHierarchy = TypeUtility.getLocalTypeHierarchy((Collection)abstractFormFields);
        for (IType formField : abstractFormFields) {
            if (TypeUtility.exists((IJavaElement)JdtUtility.getAnnotation((IAnnotatable)formField, (String)ScoutSdkIgnore.class.getName()))) continue;
            IFormFieldExtension formFieldExtension = FormFieldExtensionPoint.findExtension(formField, 1, abstractFormFieldHierarchy);
            if (formFieldExtension != null && formFieldExtension.isInShortList()) {
                this.m_modelTypeShortList.add(formField);
            }
            elements.add(formField);
        }
        this.m_table = new FilteredTable(parent, 68100);
        this.m_table.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (FormFieldSelectionWizardPage.this.m_currentSelection != null) {
                    FormFieldSelectionWizardPage.this.m_table.getViewer().update(FormFieldSelectionWizardPage.this.m_currentSelection, new String[]{"label"});
                }
                FormFieldSelectionWizardPage.this.m_currentSelection = null;
                if (!event.getSelection().isEmpty()) {
                    FormFieldSelectionWizardPage.this.m_currentSelection = ((StructuredSelection)event.getSelection()).getFirstElement();
                }
                if (FormFieldSelectionWizardPage.this.m_currentSelection != null) {
                    FormFieldSelectionWizardPage.this.m_table.getViewer().update(FormFieldSelectionWizardPage.this.m_currentSelection, new String[]{"label"});
                }
                FormFieldSelectionWizardPage.this.handleSelection(FormFieldSelectionWizardPage.this.m_currentSelection);
            }
        });
        this.m_table.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selectedItem = null;
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    selectedItem = selection.getFirstElement();
                }
                FormFieldSelectionWizardPage.this.handleSelection(selectedItem);
                IWizardPage page = FormFieldSelectionWizardPage.this.getNextPage();
                if (page == null) {
                    return;
                }
                IWizardContainer container = FormFieldSelectionWizardPage.this.getWizard().getContainer();
                if (container != null) {
                    container.showPage(page);
                }
            }
        });
        P_ContentProvider provider = new P_ContentProvider(elements.toArray());
        this.m_table.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_table.getViewer().setContentProvider((IContentProvider)provider);
        this.m_table.getViewer().setSorter((ViewerSorter)new P_TableSorter());
        this.m_table.getViewer().setInput((Object)provider);
        parent.setLayout((Layout)new GridLayout(1, true));
        GridData tableData = new GridData(1808);
        tableData.heightHint = 150;
        this.m_table.setLayoutData(tableData);
    }

    private void handleSelection(Object selectedItem) {
        IType formField;
        AbstractWizard wizard = null;
        if (selectedItem instanceof IType && (wizard = FormFieldExtensionPoint.createNewWizard(formField = (IType)selectedItem)) != null) {
            ScoutStructuredSelection sel = new ScoutStructuredSelection(new Object[]{this.m_declaringType});
            sel.setSuperType(formField);
            sel.setTypeName(this.getTypeName());
            IJavaElement sibling = this.getSibling();
            if (TypeUtility.exists((IJavaElement)sibling)) {
                sel.setSibling(new SiblingProposal(sibling));
            }
            ((AbstractInnerTypeWizard)wizard).init(PlatformUI.getWorkbench(), (IStructuredSelection)sel);
            Map<Double, IOperation> performFinishOperations = this.getWizard().getPerformFinishOperations();
            for (Map.Entry<Double, IOperation> entry : performFinishOperations.entrySet()) {
                ((AbstractWorkspaceWizard)wizard).addAdditionalPerformFinishOperation(entry.getValue(), entry.getKey());
            }
        }
        this.m_nextPage = wizard != null ? (AbstractScoutWizardPage)wizard.getStartingPage() : null;
        this.revalidate();
    }

    public FormFieldNewWizard getWizard() {
        return (FormFieldNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusFieldList());
    }

    private IStatus getStatusFieldList() {
        if (this.m_nextPage == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoFieldSelected"));
        }
        return Status.OK_STATUS;
    }

    public IWizardPage getNextPage() {
        return this.m_nextPage;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }

    public IJavaElement getSibling() {
        return this.m_sibling;
    }

    public void setSibling(IJavaElement sibling) {
        this.m_sibling = sibling;
    }

    private class P_ContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        private Object[] m_elements;

        public P_ContentProvider(Object[] elements) {
            this.m_elements = elements;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_elements;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof ISeparator) {
                    return ScoutSdkUi.getImage("type_separator.gif");
                }
                return ScoutSdkUi.getImage("formField.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                StringBuilder label = new StringBuilder();
                if (element instanceof ISeparator) {
                    return "------------------ more fields ------------------";
                }
                StructuredSelection selection = (StructuredSelection)FormFieldSelectionWizardPage.this.m_table.getViewer().getSelection();
                IType t = (IType)element;
                String typeName = t.getElementName();
                if (typeName.toLowerCase().startsWith("abstract")) {
                    typeName = typeName.substring("abstract".length());
                }
                label.append(typeName);
                if (selection.toList().contains(element)) {
                    label.append(" - ").append(t.getFullyQualifiedName());
                }
                return label.toString();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return "label".equals(property);
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class P_TableSorter
    extends ViewerSorter {
        private P_TableSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            CompositeObject comp2;
            CompositeObject comp1;
            if (e1 instanceof ISeparator) {
                comp1 = new CompositeObject(new Object[]{2});
            } else {
                IType modelType = (IType)e1;
                comp1 = FormFieldSelectionWizardPage.this.m_modelTypeShortList.contains(modelType) ? new CompositeObject(new Object[]{1, modelType.getElementName(), modelType.getFullyQualifiedName()}) : new CompositeObject(new Object[]{3, modelType.getElementName(), modelType.getFullyQualifiedName()});
            }
            if (e2 instanceof ISeparator) {
                comp2 = new CompositeObject(new Object[]{2});
            } else {
                IType modelType = (IType)e2;
                comp2 = FormFieldSelectionWizardPage.this.m_modelTypeShortList.contains(modelType) ? new CompositeObject(new Object[]{1, modelType.getElementName(), modelType.getFullyQualifiedName()}) : new CompositeObject(new Object[]{3, modelType.getElementName(), modelType.getFullyQualifiedName()});
            }
            return comp1.compareTo(comp2);
        }
    }
}

