/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.menu;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.operation.MenuNewOperation;
import org.eclipse.scout.sdk.ui.extensions.AbstractInnerTypeWizard;
import org.eclipse.scout.sdk.ui.fields.proposal.SiblingProposal;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.menu.MenuNewWizardPage;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.ui.IWorkbench;

public class DesktopMenuNewWizard
extends AbstractInnerTypeWizard {
    private MenuNewWizardPage m_page1;
    private MenuNewOperation m_operation;

    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(Texts.get((String)"NewDesktopMenu"));
        this.m_page1 = new MenuNewWizardPage(this.getDeclaringType());
        if (this.getSiblingProposal() != null) {
            this.m_page1.setSibling(this.getSiblingProposal());
        }
        if (this.getTypeName() != null) {
            this.m_page1.setTypeName(this.getTypeName());
        }
        if (this.getSuperType() != null) {
            this.m_page1.setSuperType(this.getSuperType());
        }
        this.addPage((IWizardPage)this.m_page1);
    }

    @Override
    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        this.m_operation = new MenuNewOperation(this.m_page1.getTypeName(), this.getDeclaringType(), true);
        this.m_operation.setNlsEntry(this.m_page1.getNlsName());
        IType superTypeProp = this.m_page1.getSuperType();
        if (superTypeProp != null) {
            String signature = SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName());
            this.m_operation.setSuperTypeSignature(signature);
        }
        if (this.m_page1.getSibling() == SiblingProposal.SIBLING_END || this.m_page1.getSibling() == null) {
            IStructuredType structuredType = ScoutTypeUtility.createStructuredDesktop((IType)this.getDeclaringType());
            this.m_operation.setSibling(structuredType.getSibling(IStructuredType.CATEGORIES.TYPE_MENU));
        } else {
            this.m_operation.setSibling(this.m_page1.getSibling().getElement());
        }
        this.m_operation.setFormToOpen(this.m_page1.getFormToOpen());
        this.m_operation.setFormHandler(this.m_page1.getHandler());
        this.m_operation.run(monitor, workingCopyManager);
        return true;
    }

    @Override
    protected void postFinishDisplayThread() {
        ScoutSdkUi.showJavaElementInEditor((IJavaElement)this.m_operation.getCreatedMenu(), false);
    }
}

