/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.executor;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ui.executor.AbstractExecutor;
import org.eclipse.scout.sdk.ui.util.UiUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceConsumerNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.pages.WebServiceProviderNodePage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.BuildPropertiesWizard;
import org.eclipse.swt.widgets.Shell;

public class BuildPropertiesEditExecutor
extends AbstractExecutor {
    private IScoutBundle m_bundle;

    public boolean canRun(IStructuredSelection selection) {
        this.m_bundle = UiUtility.getScoutBundleFromSelection((IStructuredSelection)selection);
        return this.isEditable(this.m_bundle);
    }

    public Object run(Shell shell, IStructuredSelection selection, ExecutionEvent event) {
        BuildJaxWsBean buildJaxWsBean;
        Object selected = selection.getFirstElement();
        if (selected instanceof WebServiceConsumerNodePage) {
            buildJaxWsBean = ((WebServiceConsumerNodePage)selected).getBuildJaxWsBean();
        } else if (selected instanceof WebServiceProviderNodePage) {
            buildJaxWsBean = ((WebServiceProviderNodePage)selected).getBuildJaxWsBean();
        } else {
            return null;
        }
        BuildPropertiesWizard wizard = new BuildPropertiesWizard(this.m_bundle, buildJaxWsBean);
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        wizardDialog.setHelpAvailable(false);
        wizardDialog.setPageSize(100, 500);
        wizardDialog.open();
        return null;
    }
}

