/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.JaxWsServletRegistrationWizard;

public class JaxWsServletRegistrationCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private SunJaxWsBean m_sunJaxWsBean;

    public JaxWsServletRegistrationCommand(IScoutBundle bundle) {
        super("Missing or invalid JAX-WS Servlet registration");
        this.m_bundle = bundle;
        this.setSolutionDescription("Use this task to fix the JAX-WS servlet registration");
    }

    public JaxWsServletRegistrationCommand(IScoutBundle bundle, SunJaxWsBean sunJaxWsBean) {
        super("Missing or invalid URL pattern");
        this.m_bundle = bundle;
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.setSolutionDescription("Use this task to fix the URL pattern and/or change the JAX-WS servlet registration");
    }

    @Override
    public boolean prepareForUi() throws CoreException {
        JaxWsServletRegistrationWizard wizard = this.m_sunJaxWsBean != null ? new JaxWsServletRegistrationWizard(this.m_bundle, this.m_sunJaxWsBean) : new JaxWsServletRegistrationWizard(this.m_bundle);
        ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
        wizardDialog.setPageSize(650, 200);
        return wizardDialog.open() == 0;
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
    }
}

