/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class SourceFolderNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_SOURCE_FOLDER = "sourceFolder";
    private BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);
    private IScoutBundle m_bundle;
    private StyledTextField m_textField;

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public SourceFolderNewWizardPage() {
        super(SourceFolderNewWizardPage.class.getName());
        this.setTitle(Texts.get("CreateNewSourceFolder"));
        this.setDescription(Texts.get("ByClickingFinishSourceFolderIsCreated"));
    }

    protected void createContent(Composite parent) {
        this.m_textField = new StyledTextField(parent);
        this.m_textField.setReadOnlyPrefix(String.valueOf(this.m_bundle.getJavaProject().getPath().toString()) + "/");
        this.m_textField.setLabelText(Texts.get("SourceFolder"));
        this.m_textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SourceFolderNewWizardPage.this.setSourceFolderInternal(SourceFolderNewWizardPage.this.m_textField.getText());
                SourceFolderNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        this.m_textField.setLayoutData((Object)formData);
    }

    protected void validatePage(MultiStatus multiStatus) {
        if (StringUtility.isNullOrEmpty((CharSequence)this.getSourceFolder())) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("EnterSourceFolder")));
            return;
        }
        IWorkspace workspace = this.m_bundle.getProject().getWorkspace();
        IStatus status = workspace.validatePath(this.getSourceFolder(), 2);
        if (status.matches(4)) {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("InvalidSourceFolder")));
            return;
        }
        Path candidatePath = new Path(this.getSourceFolder());
        for (IPath path : this.getExistingSourcePaths()) {
            if (!candidatePath.equals((Object)path)) continue;
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ws.jaxws", Texts.get("SourceFolderAlreadyExsists")));
            return;
        }
    }

    private Set<IPath> getExistingSourcePaths() {
        HashSet<IPath> sourceFolders = new HashSet<IPath>();
        try {
            IClasspathEntry[] iClasspathEntryArray = this.m_bundle.getJavaProject().getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 3) {
                    sourceFolders.add(classpathEntry.getPath());
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JaxWsSdk.logError("Error occured while fetching source folders.", e);
        }
        return sourceFolders;
    }

    public void setSourceFolder(String sourceFolder) {
        try {
            this.setStateChanging(true);
            this.setSourceFolderInternal(sourceFolder);
            if (this.isControlCreated()) {
                this.m_textField.setText(sourceFolder);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSourceFolderInternal(String sourceFolder) {
        this.m_propertySupport.setPropertyString(PROP_SOURCE_FOLDER, sourceFolder);
    }

    public String getSourceFolder() {
        return this.m_propertySupport.getPropertyString(PROP_SOURCE_FOLDER);
    }

    public Path getSourceFolderPath() {
        return new Path(this.m_propertySupport.getPropertyString(PROP_SOURCE_FOLDER));
    }
}

