/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigIniUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.VerboseUtility;
import org.eclipse.scout.commons.beans.FastBeanInfo;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.HolderUtility;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.service.INullService;
import org.eclipse.scout.service.internal.AbstractHolderArgumentVisitor;

public final class ServiceUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ServiceUtility.class);
    public static final INullService NULL_SERVICE;

    static {
        INullService n = null;
        try {
            ClassLoader identityLoader = new ClassLoader(INullService.class.getClassLoader()){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    if (name.startsWith("java.lang.")) {
                        return super.loadClass(name);
                    }
                    return INullService.class;
                }
            };
            n = (INullService)Proxy.newProxyInstance(identityLoader, new Class[]{INullService.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        NULL_SERVICE = n;
    }

    private ServiceUtility() {
    }

    public static void injectConfigProperties(Object service) {
        if (service == null) {
            return;
        }
        FastBeanInfo beanInfo = BeanUtility.getFastBeanInfo(service.getClass(), null);
        Map map = ConfigIniUtility.getProperties(service.getClass());
        for (Map.Entry e : map.entrySet()) {
            String name = (String)e.getKey();
            String text = (String)e.getValue();
            try {
                FastPropertyDescriptor propDesc = beanInfo.getPropertyDescriptor(name);
                Method setterMethod = propDesc.getWriteMethod();
                if (setterMethod != null) {
                    Object value = TypeCastUtility.castValue((Object)text, (Class)propDesc.getPropertyType());
                    setterMethod.invoke(service, value);
                    continue;
                }
                LOG.warn("no setter for " + name + "=" + text + " on " + service.getClass());
            }
            catch (Exception ex) {
                LOG.error("setting " + name + "=" + text + " on " + service.getClass(), (Throwable)ex);
            }
        }
    }

    public static Method getServiceOperation(Class<?> serviceClass, String operation, Class<?>[] paramTypes) throws ProcessingException {
        try {
            if (serviceClass == null) {
                throw new ProcessingException("service class is null");
            }
            return serviceClass.getMethod(operation, paramTypes);
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable t) {
            Throwable test;
            if (t instanceof InvocationTargetException && (test = ((InvocationTargetException)t).getTargetException()) != null) {
                t = test;
            }
            if (t instanceof ProcessingException) {
                throw (ProcessingException)t;
            }
            throw new ProcessingException(String.valueOf(serviceClass.getName()) + "#" + operation, t);
        }
    }

    public static Object invoke(Method serviceOperation, Object service, Object[] callerArgs) throws ProcessingException {
        try {
            if (serviceOperation == null) {
                throw new ProcessingException("serviceOperation is null");
            }
            if (service == null) {
                throw new ProcessingException("service is null");
            }
            if (callerArgs == null) {
                callerArgs = new Object[]{};
            }
            Object data = serviceOperation.invoke(service, callerArgs);
            return data;
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Throwable t) {
            Throwable test;
            if (t instanceof InvocationTargetException && (test = ((InvocationTargetException)t).getTargetException()) != null) {
                t = test;
            }
            if (t instanceof ProcessingException) {
                throw (ProcessingException)t;
            }
            throw new ProcessingException("service: " + service.getClass() + ", operation: " + serviceOperation.getName() + ", args: " + VerboseUtility.dumpObjects((Object[])callerArgs), t);
        }
    }

    public static Object[] filterHolderArguments(Object[] callerArgs) {
        Object[] serializableArgs = new Object[callerArgs.length];
        new AbstractHolderArgumentVisitor(){

            public void visitHolder(IHolder input, IHolder output) {
                if (!HolderUtility.containEqualValues((IHolder)output, (IHolder)input)) {
                    output.setValue(input.getValue());
                }
            }

            @Override
            public void visitOther(Object[] input, Object[] output, int index) {
                output[index] = input[index];
            }
        }.startVisiting(callerArgs, serializableArgs, 1, true);
        return serializableArgs;
    }

    public static Object[] extractHolderArguments(Object[] callerArgs) {
        Object[] holderArgs = new Object[callerArgs.length];
        new AbstractHolderArgumentVisitor(){

            public void visitHolder(IHolder input, IHolder output) {
            }

            @Override
            public void visitOther(Object[] input, Object[] output, int index) {
            }
        }.startVisiting(callerArgs, holderArgs, 1, true);
        return holderArgs;
    }

    public static void updateHolderArguments(Object[] callerArgs, Object[] updatedArgs, final boolean clearNonOutArgs) {
        if (updatedArgs != null) {
            new AbstractHolderArgumentVisitor(){

                public void visitHolder(IHolder input, IHolder output) {
                    if (!HolderUtility.containEqualValues((IHolder)output, (IHolder)input)) {
                        output.setValue(input.getValue());
                    }
                }

                @Override
                public void visitOther(Object[] input, Object[] output, int index) {
                    if (clearNonOutArgs) {
                        output[index] = null;
                    }
                }
            }.startVisiting(updatedArgs, callerArgs, 1, false);
        }
    }

    public static Class[] getInterfacesHierarchy(Class type, Class filterClass) {
        HashSet<Class> resultSet = new HashSet<Class>();
        ArrayList workList = new ArrayList();
        ArrayList lookAheadList = new ArrayList();
        if (type.isInterface()) {
            lookAheadList.add(type);
        } else {
            Class test = type;
            while (test != null) {
                lookAheadList.addAll(Arrays.asList(test.getInterfaces()));
                test = test.getSuperclass();
            }
        }
        while (lookAheadList.size() > 0) {
            workList = lookAheadList;
            lookAheadList = new ArrayList();
            for (Class c : workList) {
                if (resultSet.contains(c)) continue;
                resultSet.add(c);
                Class<?>[] classArray = c.getInterfaces();
                if (classArray.length <= 0) continue;
                lookAheadList.addAll(Arrays.asList(classArray));
            }
        }
        TreeMap resultMap = new TreeMap();
        int index = 0;
        for (Class<?> clazz : resultSet) {
            if (!filterClass.isAssignableFrom(clazz)) continue;
            int depth = 0;
            Class<?> test = clazz;
            while (test != null) {
                ++depth;
                Class<?>[] xa = test.getInterfaces();
                test = null;
                if (xa == null) continue;
                Class<?>[] classArray = xa;
                int n = xa.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> x = classArray[n2];
                    if (filterClass.isAssignableFrom(x)) {
                        test = x;
                    }
                    ++n2;
                }
            }
            resultMap.put(new CompositeObject(new Object[]{depth, index++}), clazz);
        }
        return resultMap.values().toArray(new Class[resultMap.size()]);
    }
}

