/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.server.runner;

import java.util.List;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.rt.server.IServerJobFactory;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ITransactionRunnable;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.ServerJobFactory;
import org.eclipse.scout.rt.testing.commons.ScoutAssert;
import org.eclipse.scout.rt.testing.shared.Activator;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.services.common.exceptionhandler.WrappingProcessingRuntimeExceptionHandlerService;
import org.junit.runners.model.Statement;
import org.osgi.framework.Bundle;

public class ScoutServerJobWrapperStatement
extends Statement {
    private static final int EXCEPTIONHANDLER_SERVICE_RANKING = 1000;
    private final Statement m_statement;
    private final IServerJobFactory m_factory;

    public ScoutServerJobWrapperStatement(IServerJobFactory factory, Statement statement) {
        this.m_statement = statement;
        this.m_factory = factory;
    }

    @Deprecated
    public ScoutServerJobWrapperStatement(IServerSession serverSession, Subject subject, Statement statement) {
        this((IServerJobFactory)new ServerJobFactory(serverSession, subject), statement);
    }

    public void evaluate() throws Throwable {
        if (ServerJob.getCurrentSession() != null) {
            this.doEvaluateWrappingExceptions();
        } else {
            ServerJob job = this.m_factory.create("JUnit Server Job Runner", new ITransactionRunnable(){

                public IStatus run(IProgressMonitor monitor) throws ProcessingException {
                    ScoutServerJobWrapperStatement.this.doEvaluateWrappingExceptions();
                    return Status.OK_STATUS;
                }
            });
            job.setSystem(true);
            job.runNow((IProgressMonitor)new NullProgressMonitor());
            ScoutAssert.jobSuccessfullyCompleted((JobEx)job);
        }
    }

    protected void doEvaluateWrappingExceptions() throws ProcessingException {
        List serviceReg = null;
        try {
            WrappingProcessingRuntimeExceptionHandlerService handler = new WrappingProcessingRuntimeExceptionHandlerService();
            serviceReg = TestingUtility.registerServices((Bundle)Activator.getDefault().getBundle(), (int)1000, (Object[])new Object[]{handler});
            this.doEvaluate();
        }
        catch (Throwable throwable) {
            if (serviceReg != null) {
                TestingUtility.unregisterServices(serviceReg);
            }
            throw throwable;
        }
        if (serviceReg != null) {
            TestingUtility.unregisterServices((List)serviceReg);
        }
    }

    protected void doEvaluate() throws ProcessingException {
        try {
            this.m_statement.evaluate();
        }
        catch (Throwable e) {
            throw new ProcessingException(e.getMessage(), e);
        }
    }
}

