/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.ScoutFieldStatus;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.basic.comp.CLabelEx;
import org.eclipse.scout.rt.ui.rap.ext.ILabelComposite;
import org.eclipse.scout.rt.ui.rap.extension.UiDecorationExtensionPoint;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class StatusLabelEx
extends Composite
implements ILabelComposite {
    private static final long serialVersionUID = 1L;
    private static final String STAR_MARKER = "*";
    private static final String WHITE_SPACE = " ";
    private static final boolean GRAB_HORIZONTAL_LABEL = true;
    private static final boolean GRAB_HORIZONTAL_STATUS = false;
    private boolean m_visible = true;
    private IProcessingStatus m_status;
    private boolean m_mandatory;
    private boolean m_enabled;
    private Control m_label;
    private Label m_statusLabel;
    private final Image m_infoImg = this.getUiEnvironment().getIcon("status_info");
    private final Image m_warningImg = this.getUiEnvironment().getIcon("status_warning");
    private final Image m_errorImg = this.getUiEnvironment().getIcon("status_error");
    private String m_preMarker = "";
    private String m_postMarker = "";
    private Font m_nonMandatoryFont;
    protected Font m_mandatoryFont;
    private Color m_nonMandatoryForegroundColor;
    protected Color m_mandatoryForegroundColor;
    private String m_nonMandatoryText = "";

    public StatusLabelEx(Composite parent, int style) {
        super(parent, 524288);
        this.createContent(this, style);
        this.createLayout();
        this.m_nonMandatoryFont = this.m_label.getFont();
        this.m_nonMandatoryForegroundColor = this.m_label.getForeground();
        this.m_enabled = super.getEnabled();
    }

    protected void createLayout() {
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(0, 0).margins(0, 0).applyTo((Composite)this);
    }

    protected void createContent(Composite parent, int style) {
        this.m_label = new CLabelEx(parent, style | this.getUiEnvironment().getFormToolkit().getFormToolkit().getOrientation());
        this.getUiEnvironment().getFormToolkit().getFormToolkit().adapt(this.m_label, false, false);
        this.m_statusLabel = new Label(parent, 0);
        this.getUiEnvironment().getFormToolkit().getFormToolkit().adapt((Control)this.m_statusLabel, false, false);
        GridDataFactory.swtDefaults().align(4, 4).grab(true, true).applyTo(this.m_label);
        GridDataFactory.swtDefaults().align(131072, 0x1000000).grab(false, false).indent(0, 3).applyTo((Control)this.m_statusLabel);
    }

    protected IRwtEnvironment getUiEnvironment() {
        return (IRwtEnvironment)this.getDisplay().getData(IRwtEnvironment.class.getName());
    }

    protected void initMandatorySettings() {
        int starPos;
        String labelTextColor;
        FontSpec labelFontSpec;
        if (this.m_mandatoryFont == null && (labelFontSpec = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryLabelFont()) != null) {
            this.m_mandatoryFont = this.getUiEnvironment().getFont(labelFontSpec, this.getNonMandatoryFont());
        }
        if (this.m_mandatoryForegroundColor == null && (labelTextColor = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryLabelTextColor()) != null) {
            this.m_mandatoryForegroundColor = this.getUiEnvironment().getColor(labelTextColor);
        }
        if (!StringUtility.hasText((CharSequence)this.m_postMarker) && !StringUtility.hasText((CharSequence)this.m_preMarker) && (starPos = UiDecorationExtensionPoint.getLookAndFeel().getMandatoryStarMarkerPosition()) != 0) {
            switch (starPos) {
                case 2: {
                    this.m_postMarker = "* ";
                    break;
                }
                case 1: {
                    this.m_preMarker = "* ";
                }
            }
        }
    }

    @Override
    public void setLayoutWidthHint(int w) {
        Object o = this.getLayoutData();
        if (o instanceof LogicalGridData) {
            LogicalGridData data = (LogicalGridData)o;
            data.widthHint = w;
        }
    }

    @Override
    public boolean setMandatory(boolean mandatory) {
        if (this.isMandatory() == mandatory) {
            return false;
        }
        this.m_mandatory = mandatory;
        if (mandatory) {
            this.initMandatorySettings();
        }
        boolean updateLayout = false;
        if (this.getMandatoryFont() != null) {
            this.updateLabelFont();
            updateLayout = true;
        }
        if (this.getMandatoryForegroundColor() != null) {
            this.updateLabelForeground();
            updateLayout = true;
        }
        if (this.getPreMarker() != null) {
            this.updateText();
            updateLayout = true;
        }
        if (this.getPostMarker() != null) {
            this.updateMandatoryStatus();
            updateLayout = true;
        }
        return updateLayout;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.m_enabled == enabled) {
            return;
        }
        this.m_enabled = enabled;
        if (enabled) {
            this.setForeground(null);
        } else {
            this.setForeground(this.getUiEnvironment().getColor(UiDecorationExtensionPoint.getLookAndFeel().getColorForegroundDisabled()));
        }
    }

    @Override
    public boolean getEnabled() {
        return true;
    }

    protected void updateMandatoryStatus() {
        if (this.m_status != null) {
            return;
        }
        if (this.isMandatory()) {
            this.m_statusLabel.setText(this.m_postMarker);
            this.m_statusLabel.setVisible(true);
            ((GridData)this.getStatusLabel().getLayoutData()).exclude = false;
        } else {
            this.m_statusLabel.setVisible(false);
            ((GridData)this.getStatusLabel().getLayoutData()).exclude = true;
        }
        this.layout(true, true);
    }

    protected void updateLabelForeground() {
        if (this.isEnabled() && this.isMandatory()) {
            this.m_label.setForeground(this.getMandatoryForegroundColor());
        } else {
            this.m_label.setForeground(this.getNonMandatoryForegroundColor());
        }
    }

    protected void updateLabelFont() {
        if (this.isMandatory()) {
            this.m_label.setFont(this.getMandatoryFont());
        } else {
            this.m_label.setFont(this.getNonMandatoryFont());
        }
    }

    protected void updateText() {
        if (this.isMandatory()) {
            this.setLabelText(String.valueOf(this.m_preMarker) + this.getNonMandatoryText());
        } else {
            this.setLabelText(this.getNonMandatoryText());
        }
    }

    protected void setLabelText(String text) {
        if (this.m_label instanceof CLabel) {
            ((CLabel)this.m_label).setText(text);
        }
    }

    protected String getLabelText() {
        if (this.m_label instanceof CLabel) {
            return ((CLabel)this.m_label).getText();
        }
        return null;
    }

    @Override
    public void setStatus(IProcessingStatus status) {
        this.m_status = status;
        if (this.m_status == null) {
            this.getStatusLabel().setToolTipText("");
            this.getStatusLabel().setImage(null);
            this.getStatusLabel().setVisible(false);
            if (this.getStatusLabel().getLayoutData() instanceof GridData) {
                ((GridData)this.getStatusLabel().getLayoutData()).exclude = true;
            }
            if (this.isMandatory()) {
                this.updateMandatoryStatus();
            }
        } else {
            String iconId;
            String string = iconId = this.m_status instanceof ScoutFieldStatus ? ((ScoutFieldStatus)this.m_status).getIconId() : null;
            if (iconId != null) {
                this.getStatusLabel().setImage(this.getUiEnvironment().getIcon(iconId));
            } else {
                switch (this.m_status.getSeverity()) {
                    case 4: 
                    case 16: {
                        this.getStatusLabel().setImage(this.m_errorImg);
                        break;
                    }
                    case 2: {
                        this.getStatusLabel().setImage(this.m_warningImg);
                        break;
                    }
                    default: {
                        this.getStatusLabel().setImage(this.m_infoImg);
                    }
                }
            }
            StringBuffer buf = new StringBuffer();
            if (this.m_status.getTitle() != null) {
                buf.append(this.m_status.getTitle());
            }
            if (this.m_status.getMessage() != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(this.m_status.getMessage());
            }
            this.getStatusLabel().setToolTipText(buf.toString());
            this.getStatusLabel().setVisible(true);
            if (this.getStatusLabel().getLayoutData() instanceof GridData) {
                ((GridData)this.getStatusLabel().getLayoutData()).exclude = false;
            }
        }
        this.layout(true, true);
    }

    @Override
    public void setVisible(boolean visible) {
        this.m_visible = visible;
        super.setVisible(visible);
    }

    @Override
    public void setStatusVisible(boolean visible) {
        boolean statusVisible = visible;
        Label statusLabel = this.getStatusLabel();
        if (statusLabel != null) {
            GridDataFactory.createFrom((GridData)((GridData)statusLabel.getLayoutData())).exclude(!statusVisible);
            statusLabel.setVisible(statusVisible);
        }
        boolean labelVisible = this.m_visible && StringUtility.hasText((CharSequence)this.m_nonMandatoryText);
        Control label = this.getLabel();
        if (label != null) {
            GridDataFactory.createFrom((GridData)((GridData)label.getLayoutData())).exclude(!labelVisible);
            label.setVisible(labelVisible);
        }
        this.layout(true, true);
        if (statusVisible) {
            super.setVisible(true);
        } else {
            super.setVisible(labelVisible);
        }
    }

    @Override
    public void setGrabHorizontalEnabled(boolean enabled) {
        ((GridData)this.m_label.getLayoutData()).grabExcessHorizontalSpace = enabled;
        ((GridData)this.m_statusLabel.getLayoutData()).grabExcessHorizontalSpace = enabled ? false : false;
    }

    @Override
    public String getText() {
        return this.getLabelText();
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.m_nonMandatoryText = text;
        this.updateText();
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.m_label.setBackground(color);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.m_nonMandatoryForegroundColor = color;
        this.updateLabelForeground();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.m_nonMandatoryFont = font;
        this.updateLabelFont();
    }

    @Override
    public Font getFont() {
        return this.m_label.getFont();
    }

    public Font getNonMandatoryFont() {
        return this.m_nonMandatoryFont;
    }

    public void setNonMandatoryFont(Font nonMandatoryFont) {
        this.m_nonMandatoryFont = nonMandatoryFont;
    }

    public Font getMandatoryFont() {
        return this.m_mandatoryFont;
    }

    public void setMandatoryFont(Font mandatoryFont) {
        this.m_mandatoryFont = mandatoryFont;
    }

    public Color getNonMandatoryForegroundColor() {
        return this.m_nonMandatoryForegroundColor;
    }

    public void setNonMandatoryForegroundColor(Color nonMandatoryForegroundColor) {
        this.m_nonMandatoryForegroundColor = nonMandatoryForegroundColor;
    }

    public Color getMandatoryForegroundColor() {
        return this.m_mandatoryForegroundColor;
    }

    public void setMandatoryForegroundColor(Color mandatoryForegroundColor) {
        this.m_mandatoryForegroundColor = mandatoryForegroundColor;
    }

    public String getPreMarker() {
        return this.m_preMarker;
    }

    public String getPostMarker() {
        return this.m_postMarker;
    }

    public Label getStatusLabel() {
        return this.m_statusLabel;
    }

    protected void setStatusLabel(Label statusLabel) {
        this.m_statusLabel = statusLabel;
    }

    public boolean isMandatory() {
        return this.m_mandatory;
    }

    public String getNonMandatoryText() {
        return this.m_nonMandatoryText;
    }

    protected void setLabel(Control label) {
        this.m_label = label;
    }

    public Control getLabel() {
        return this.m_label;
    }
}

