/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.toolbar;

import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.rap.RwtMenuUtility;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.IRwtScoutMainMenuButton;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public class RwtScoutMainMenuButton
extends RwtScoutComposite<IDesktop>
implements IRwtScoutMainMenuButton {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutMainMenuButton.class);
    private Button m_menuButton;
    private static final String VARIANT_TOOLBAR_MENU_BUTTON = "menuButton";

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.createMenu(container);
        FillLayout containerLayout = new FillLayout();
        container.setLayout((Layout)containerLayout);
        this.setUiContainer(container);
    }

    protected Control createMenu(Composite parent) {
        this.m_menuButton = this.getUiEnvironment().getFormToolkit().createButton(parent, "", 8);
        this.m_menuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                Rectangle buttonBounds = RwtScoutMainMenuButton.this.m_menuButton.getBounds();
                Point buttonLocation = RwtScoutMainMenuButton.this.m_menuButton.toDisplay(buttonBounds.x, buttonBounds.y);
                if (RwtScoutMainMenuButton.this.getScoutObject() != null) {
                    Runnable t = new Runnable(){

                        @Override
                        public void run() {
                            ((IDesktop)RwtScoutMainMenuButton.this.getScoutObject()).prepareAllMenus();
                        }
                    };
                    JobEx job = RwtScoutMainMenuButton.this.getUiEnvironment().invokeScoutLater(t, 5000L);
                    try {
                        job.join(5000L);
                    }
                    catch (InterruptedException ex) {
                        LOG.warn("Exception occured while preparing all menus.", (Throwable)ex);
                    }
                }
                Menu menu = RwtScoutMainMenuButton.this.m_menuButton.getMenu();
                menu.setLocation(new Point(buttonLocation.x, buttonLocation.y + buttonBounds.height));
                menu.setVisible(true);
            }
        });
        this.m_menuButton.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_TOOLBAR_MENU_BUTTON);
        Menu contextMenu = new Menu((Decorations)this.m_menuButton.getShell(), 8);
        RwtMenuUtility.fillMenu(contextMenu, ((IDesktop)this.getScoutObject()).getMenus(), ActionUtility.createVisibleFilter(), this.getUiEnvironment());
        this.m_menuButton.setMenu(contextMenu);
        return this.m_menuButton;
    }
}

