/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.htmlunit;

import com.gargoylesoftware.htmlunit.ScriptException;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.openqa.selenium.Mouse;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.htmlunit.HtmlUnitKeyboard;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.internal.Coordinates;

public class HtmlUnitMouse
implements Mouse {
    private final HtmlUnitDriver parent;
    private final HtmlUnitKeyboard keyboard;
    private HtmlElement currentActiveElement = null;

    public HtmlUnitMouse(HtmlUnitDriver parent, HtmlUnitKeyboard keyboard) {
        this.parent = parent;
        this.keyboard = keyboard;
    }

    private HtmlElement getElementForOperation(Coordinates potentialCoordinates) {
        if (potentialCoordinates != null) {
            return (HtmlElement)potentialCoordinates.getAuxiliary();
        }
        if (this.currentActiveElement == null) {
            throw new InvalidCoordinatesException("About to perform an interaction that relies on the active element, but there isn't one.");
        }
        return this.currentActiveElement;
    }

    @Override
    public void click(Coordinates elementCoordinates) {
        HtmlElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        try {
            if (this.parent.isJavascriptEnabled()) {
                if (!(element instanceof HtmlInput)) {
                    element.focus();
                }
                element.mouseOver();
                element.mouseMove();
            }
            element.click(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            throw new WebDriverException(e);
        }
        catch (ScriptException e) {
            System.out.println(e.getMessage());
        }
    }

    private void moveOutIfNeeded(HtmlElement element) {
        try {
            if (this.currentActiveElement != element) {
                if (this.currentActiveElement != null) {
                    this.currentActiveElement.mouseOver(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    this.currentActiveElement.mouseOut(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
                    this.currentActiveElement.blur();
                }
                if (element != null) {
                    this.mouseMove(element);
                }
            }
        }
        catch (ScriptException ignored) {
            System.out.println(ignored.getMessage());
        }
    }

    private void updateActiveElement(HtmlElement element) {
        if (element != null) {
            this.currentActiveElement = element;
        }
    }

    public void click(Coordinates where, long xOffset, long yOffset) {
        this.click(where);
    }

    @Override
    public void doubleClick(Coordinates elementCoordinates) {
        HtmlElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        try {
            element.dblClick(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
            this.updateActiveElement(element);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void contextClick(Coordinates elementCoordinates) {
        HtmlElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        element.rightClick(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed());
        this.updateActiveElement(element);
    }

    @Override
    public void mouseDown(Coordinates elementCoordinates) {
        HtmlElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        element.mouseDown(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    @Override
    public void mouseUp(Coordinates elementCoordinates) {
        HtmlElement element = this.getElementForOperation(elementCoordinates);
        this.moveOutIfNeeded(element);
        element.mouseUp(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        this.updateActiveElement(element);
    }

    @Override
    public void mouseMove(Coordinates elementCoordinates) {
        Preconditions.checkNotNull((Object)elementCoordinates);
        HtmlElement element = (HtmlElement)elementCoordinates.getAuxiliary();
        this.moveOutIfNeeded(element);
        this.updateActiveElement(element);
    }

    private void mouseMove(HtmlElement element) {
        element.mouseMove(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
        element.mouseOver(this.keyboard.isShiftPressed(), this.keyboard.isCtrlPressed(), this.keyboard.isAltPressed(), 0);
    }

    @Override
    public void mouseMove(Coordinates where, long xOffset, long yOffset) {
        throw new UnsupportedOperationException("Moving to arbitrary X,Y coordinates not supported.");
    }
}

