/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.mobile.form.fields.tablefield;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.client.mobile.ui.action.ActionButtonBarUtility;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.TableAdapter;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.IContentAssistFieldProposalForm;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.ITableField;
import org.eclipse.scout.rt.ui.rap.LogicalGridData;
import org.eclipse.scout.rt.ui.rap.form.fields.LogicalGridDataBuilder;
import org.eclipse.scout.rt.ui.rap.mobile.action.AbstractRwtScoutActionBar;
import org.eclipse.swt.widgets.Composite;

public class RwtScoutTableActionBar
extends AbstractRwtScoutActionBar<ITableField<? extends ITable>> {
    private static final String VARIANT_SMART_FIELD_ACTION_BAR = "smartFieldActionBar";
    private P_TableRowSelectionListener m_rowSelectionListener;
    private ITable m_table;

    public RwtScoutTableActionBar() {
        this.setMenuOpeningDirection(128);
    }

    @Override
    protected void initLayout(Composite container) {
        super.initLayout(container);
        int tableStatusGridH = 1;
        LogicalGridData tableGridData = LogicalGridDataBuilder.createField((GridData)((ITableField)this.getScoutObject()).getGridData());
        LogicalGridData gd = new LogicalGridData();
        gd.gridx = tableGridData.gridx;
        gd.gridy = tableGridData.gridy + tableGridData.gridh + tableStatusGridH;
        gd.gridw = tableGridData.gridw;
        gd.topInset = 0;
        gd.gridh = 1;
        if (this.getHeightHint() != null) {
            gd.heightHint = this.getHeightHint();
        } else {
            gd.useUiHeight = true;
        }
        gd.weightx = tableGridData.weightx;
        gd.weighty = 0.0;
        gd.fillHorizontal = true;
        container.setLayoutData((Object)gd);
    }

    @Override
    protected String getActionBarContainerVariant() {
        if (((ITableField)this.getScoutObject()).getForm() instanceof IContentAssistFieldProposalForm) {
            return VARIANT_SMART_FIELD_ACTION_BAR;
        }
        return super.getActionBarContainerVariant();
    }

    @Override
    protected void collectMenusForLeftButtonBar(List<IMenu> menuList) {
        List rowMenus;
        ITable table = ((ITableField)this.getScoutObject()).getTable();
        if (table == null) {
            return;
        }
        IActionFilter filter = ActionUtility.createMenuFilterMenuTypes((Set)CollectionUtility.hashSet((Object)TableMenuType.EmptySpace), (boolean)true);
        List emptySpaceMenus = ActionUtility.getActions((List)table.getMenus(), (IActionFilter)filter);
        if (emptySpaceMenus != null) {
            menuList.addAll(emptySpaceMenus);
        }
        if (table.getSelectedRowCount() > 0 && (rowMenus = ActionUtility.getActions((List)table.getMenus(), (IActionFilter)ActionUtility.createMenuFilterMenuTypes((Set)table.getContextMenu().getCurrentMenuTypes(), (boolean)true))) != null) {
            ArrayList editableRowMenus = new ArrayList(rowMenus);
            ActionButtonBarUtility.distributeRowActions(menuList, (List)emptySpaceMenus, editableRowMenus);
            menuList.addAll(editableRowMenus);
        }
    }

    @Override
    protected void collectMenusForRightButtonBar(List<IMenu> menuList) {
    }

    protected void attachScout() {
        super.attachScout();
        this.m_table = ((ITableField)this.getScoutObject()).getTable();
        this.addRowSelectionListener(this.m_table);
    }

    protected void detachScout() {
        super.detachScout();
        this.removeRowSelectionListener(this.m_table);
        this.m_table = null;
    }

    private void addRowSelectionListener(ITable table) {
        if (this.m_rowSelectionListener != null || table == null) {
            return;
        }
        this.m_rowSelectionListener = new P_TableRowSelectionListener();
        table.addTableListener((TableListener)this.m_rowSelectionListener);
    }

    private void removeRowSelectionListener(ITable table) {
        if (this.m_rowSelectionListener == null || table == null) {
            return;
        }
        table.removeTableListener((TableListener)this.m_rowSelectionListener);
        this.m_rowSelectionListener = null;
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if (name.equals("table")) {
            this.removeRowSelectionListener(this.m_table);
            this.m_table = (ITable)newValue;
            this.addRowSelectionListener(this.m_table);
        }
    }

    private class P_TableRowSelectionListener
    extends TableAdapter {
        private P_TableRowSelectionListener() {
        }

        public void tableChanged(TableEvent e) {
            if (e.getType() == 103) {
                this.rowSelected();
            }
        }

        private void rowSelected() {
            RwtScoutTableActionBar.this.rebuildContentFromScout();
        }
    }
}

