/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.eclipse.scout.commons.serialization.AbstractObjectSerializer;
import org.eclipse.scout.commons.serialization.IObjectReplacer;

public class BasicObjectSerializer
extends AbstractObjectSerializer {
    public BasicObjectSerializer(IObjectReplacer objectReplacer) {
        super(objectReplacer);
    }

    @Override
    protected ObjectInputStream createObjectInputStream(InputStream in, IObjectReplacer objectReplacer) throws IOException {
        if (objectReplacer == null) {
            return new ObjectInputStream(in);
        }
        return new ResolvingObjectInputStream(in, objectReplacer);
    }

    public static class ResolvingObjectInputStream
    extends ObjectInputStream {
        private final IObjectReplacer m_objectReplacer;

        public ResolvingObjectInputStream(InputStream in, IObjectReplacer objectReplacer) throws IOException {
            super(in);
            this.m_objectReplacer = objectReplacer;
            this.enableResolveObject(true);
        }

        @Override
        protected Object resolveObject(Object obj) throws IOException {
            return this.m_objectReplacer.resolveObject(obj);
        }
    }
}

