/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.transformation;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.mobile.ui.basic.table.form.TableRowForm;
import org.eclipse.scout.rt.client.mobile.ui.desktop.MobileDesktopUtility;
import org.eclipse.scout.rt.client.mobile.ui.form.fields.tabbox.TabForm;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;

public class ToolFormHandler {
    private P_DesktopListener m_desktopListener;
    private P_OutlineListener m_outlineListener;
    private IOutline m_activeOutline;
    private IDesktop m_desktop;
    private boolean m_closeToolFormsAfterTablePageLoaded;

    public ToolFormHandler(IDesktop desktop) {
        this.m_desktop = desktop;
        this.m_desktopListener = new P_DesktopListener();
        this.m_desktop.addDesktopListener((DesktopListener)this.m_desktopListener);
        this.m_closeToolFormsAfterTablePageLoaded = true;
    }

    private void destroy() {
        if (this.m_desktopListener != null) {
            this.getDesktop().removeDesktopListener((DesktopListener)this.m_desktopListener);
            this.m_desktopListener = null;
        }
    }

    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    protected boolean execCloseToolFormsOnFormOpen(IForm form) {
        if (20 == form.getDisplayHint() && !MobileDesktopUtility.isToolForm(form)) {
            return !(form instanceof TableRowForm) && !(form instanceof TabForm);
        }
        return false;
    }

    public boolean isCloseToolFormsAfterTablePageLoaded() {
        return this.m_closeToolFormsAfterTablePageLoaded;
    }

    public void setCloseToolFormsAfterTablePageLoaded(boolean closeToolFormsAfterTablePageLoaded) {
        this.m_closeToolFormsAfterTablePageLoaded = closeToolFormsAfterTablePageLoaded;
    }

    public void notifyTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        if (this.isCloseToolFormsAfterTablePageLoaded()) {
            MobileDesktopUtility.closeAllToolForms();
        }
    }

    private class P_DesktopListener
    implements DesktopListener {
        private P_DesktopListener() {
        }

        public void desktopChanged(DesktopEvent e) {
            switch (e.getType()) {
                case 600: {
                    this.handleFormAdded(e);
                    break;
                }
                case 100: {
                    ToolFormHandler.this.destroy();
                    break;
                }
                case 200: {
                    this.handleOutlineChanged(e);
                }
            }
        }

        private void handleOutlineChanged(DesktopEvent e) {
            IOutline outline = e.getOutline();
            if (ToolFormHandler.this.m_activeOutline != null) {
                ToolFormHandler.this.m_activeOutline.removeTreeListener((TreeListener)ToolFormHandler.this.m_outlineListener);
            }
            if (outline != null) {
                if (ToolFormHandler.this.m_outlineListener == null) {
                    ToolFormHandler.this.m_outlineListener = new P_OutlineListener();
                }
                outline.addTreeListener((TreeListener)ToolFormHandler.this.m_outlineListener);
            }
            ToolFormHandler.this.m_activeOutline = outline;
        }

        private void handleFormAdded(DesktopEvent e) {
            IForm form = e.getForm();
            if (ToolFormHandler.this.execCloseToolFormsOnFormOpen(form)) {
                MobileDesktopUtility.closeAllToolForms();
            }
        }
    }

    private class P_OutlineListener
    extends TreeAdapter {
        private P_OutlineListener() {
        }

        public void treeChanged(TreeEvent e) {
            switch (e.getType()) {
                case 40: {
                    this.handleNodesSelected(e);
                }
            }
        }

        private void handleNodesSelected(TreeEvent event) {
            MobileDesktopUtility.closeAllToolForms();
        }
    }
}

