/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clientnotification.internal;

import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationFilter;
import org.eclipse.scout.rt.server.services.common.clientnotification.IClientNotificationQueueElement;
import org.eclipse.scout.rt.shared.services.common.clientnotification.IClientNotification;

public class ClientNotificationQueueElement
implements IClientNotificationQueueElement {
    private static final long serialVersionUID = 6996861336319521L;
    protected final IClientNotification m_notification;
    protected final IClientNotificationFilter m_filter;
    protected final long m_valid_until;

    public ClientNotificationQueueElement(IClientNotification notification, IClientNotificationFilter filter) {
        this.m_notification = notification;
        this.m_filter = filter;
        this.m_valid_until = System.currentTimeMillis() + notification.getTimeout();
    }

    @Override
    public IClientNotification getNotification() {
        return this.m_notification;
    }

    @Override
    public IClientNotificationFilter getFilter() {
        return this.m_filter;
    }

    @Override
    public boolean isActive() {
        return !this.isExpired() && this.m_filter.isActive();
    }

    private boolean isExpired() {
        return System.currentTimeMillis() >= this.m_valid_until;
    }

    @Override
    public boolean isReplacableBy(IClientNotificationQueueElement newElem) {
        return this.m_notification == newElem.getNotification() || newElem.getNotification().getClass() == this.m_notification.getClass() && newElem.getFilter().equals(this.m_filter) && newElem.getNotification().coalesce(this.m_notification);
    }

    public String toString() {
        return "ClientNotificationQueueElement [m_notification=" + this.m_notification + ", m_filter=" + this.m_filter + ", m_valid_until=" + this.m_valid_until + "]";
    }
}

