/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.imap;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.server.services.common.imap.IImapAdapter;

public class ImapAdapter
implements IImapAdapter {
    public static final String TRASH_FOLDER_NAME = "Trash";
    public static final int DEFAULT_IMAP_PORT = 143;
    private boolean m_useSSL;
    private String[] m_sslProtocols;
    private String m_host;
    private int m_port = 143;
    private String m_username;
    private String m_password;
    private String m_defaultFolderName;
    private Store m_store;
    private Map<String, Folder> m_cachedFolders = new HashMap<String, Folder>();

    public ImapAdapter() {
    }

    public ImapAdapter(String host, int port, String username, String password) {
        this();
        this.m_host = host;
        this.m_port = port;
        this.m_username = username;
        this.m_password = password;
    }

    protected void finalize() throws Throwable {
        this.closeConnection();
        super.finalize();
    }

    @Override
    public Message[] getUnseenMessages() throws ProcessingException {
        return this.getUnseenMessages(this.getDefaultFolderName());
    }

    @Override
    public Message[] getUnseenMessages(String folderName) throws ProcessingException {
        this.connect();
        ArrayList<Message> messages = new ArrayList<Message>();
        Folder folder = null;
        try {
            folder = this.findFolder(folderName);
            if (folder != null) {
                Message[] m = folder.getMessages();
                int i = 0;
                while (i < Array.getLength(m)) {
                    Message item = m[i];
                    if (!item.isSet(Flags.Flag.SEEN)) {
                        messages.add(item);
                    }
                    ++i;
                }
            }
        }
        catch (MessagingException e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
        return messages.toArray(new Message[messages.size()]);
    }

    @Override
    public Message[] getAllMessages() throws ProcessingException {
        return this.getAllMessages(this.getDefaultFolderName());
    }

    @Override
    public Message[] getAllMessages(String folderName) throws ProcessingException {
        this.connect();
        Message[] messages = new Message[]{};
        Folder folder = null;
        try {
            folder = this.findFolder(folderName);
            if (folder != null) {
                messages = folder.getMessages();
            }
        }
        catch (MessagingException e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
        return messages;
    }

    @Override
    public void moveToTrash(Message[] messages) throws ProcessingException {
        this.moveMessages(TRASH_FOLDER_NAME, messages);
    }

    @Override
    public void moveMessages(String destFolderName, Message[] messages) throws ProcessingException {
        this.copyMessages(destFolderName, messages, true);
    }

    @Override
    public void copyMessages(String destFolderName, Message[] messages) throws ProcessingException {
        this.copyMessages(destFolderName, messages, false);
    }

    protected void copyMessages(String destFolderName, Message[] messages, boolean deleteSourceMessages) throws ProcessingException {
        this.connect();
        Folder destFolder = null;
        try {
            destFolder = this.findFolder(destFolderName);
            if (destFolder != null) {
                destFolder.appendMessages(messages);
                if (deleteSourceMessages) {
                    this.deleteMessagesPermanently(messages);
                }
            }
        }
        catch (MessagingException e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void deleteMessagesPermanently(Message[] messages) throws ProcessingException {
        this.connect();
        HashSet<Folder> folders = new HashSet<Folder>();
        try {
            Message[] messageArray = messages;
            int n = messages.length;
            int n2 = 0;
            while (n2 < n) {
                Message msg = messageArray[n2];
                folders.add(msg.getFolder());
                msg.setFlag(Flags.Flag.DELETED, true);
                ++n2;
            }
            for (Folder f : folders) {
                if (!f.isOpen()) continue;
                f.expunge();
            }
        }
        catch (MessagingException e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void createFolder(String folderName) throws ProcessingException {
        this.findFolder(folderName, true);
    }

    @Override
    public void removeFolder(String folderName) throws ProcessingException {
        this.connect();
        try {
            Folder folder = this.findFolder(folderName);
            if (folder != null && folder.exists()) {
                if (folder.isOpen()) {
                    folder.close(true);
                }
                folder.delete(true);
            }
        }
        catch (MessagingException e) {
            throw new ProcessingException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void connect() throws ProcessingException {
        if (!this.isConnected()) {
            this.m_cachedFolders.clear();
            Properties props = new Properties();
            props.put("mail.transport.protocol", "imap");
            if (this.getHost() != null) {
                props.put("mail.imap.host", this.getHost());
            }
            if (this.getPort() > 0) {
                props.put("mail.imap.port", "" + this.getPort());
            }
            if (this.getUsername() != null) {
                props.put("mail.imap.user", this.getUsername());
            }
            if (this.isUseSSL()) {
                props.setProperty("mail.imap.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                props.setProperty("mail.imap.socketFactory.fallback", "false");
                props.setProperty("mail.imap.socketFactory.port", "" + this.getPort());
                if (CollectionUtility.hasElements((Object[])this.getSSLProtocols())) {
                    props.setProperty("mail.imap.ssl.protocols", StringUtility.join((String)" ", (String[])this.getSSLProtocols()));
                }
            }
            this.interceptProperties(props);
            Session session = Session.getInstance((Properties)props, null);
            try {
                this.m_store = session.getStore("imap");
                if (!this.m_store.isConnected()) {
                    if (this.getUsername() != null && this.getHost() != null) {
                        this.m_store.connect(this.getHost(), this.getUsername(), this.getPassword());
                    } else {
                        this.m_store.connect();
                    }
                }
            }
            catch (AuthenticationFailedException e) {
                throw new ProcessingException("IMAP-Authentication failed on " + (this.m_host == null ? "?" : this.m_host) + ":" + this.m_port + ":" + this.m_username);
            }
            catch (Exception e) {
                throw new ProcessingException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void interceptProperties(Properties props) {
    }

    protected Folder findFolder(String name) throws ProcessingException {
        return this.findFolder(name, false);
    }

    protected Folder findFolder(String name, boolean createNonExisting) throws ProcessingException {
        this.connect();
        Folder folder = this.m_cachedFolders.get(name);
        if (folder == null) {
            try {
                Folder f = this.m_store.getFolder(name);
                if (f.exists()) {
                    folder = f;
                } else if (createNonExisting) {
                    f.create(3);
                    folder = f;
                }
                if (folder != null) {
                    this.m_cachedFolders.put(name, folder);
                }
            }
            catch (MessagingException e) {
                throw new ProcessingException("could not find folder: " + name, (Throwable)e);
            }
        }
        try {
            if (folder != null && !folder.isOpen()) {
                folder.open(2);
            }
        }
        catch (MessagingException e) {
            throw new ProcessingException("could not open folder: " + name, (Throwable)e);
        }
        return folder;
    }

    @Override
    public void closeConnection() throws ProcessingException {
        if (this.isConnected()) {
            ArrayList<MessagingException> exceptions = new ArrayList<MessagingException>();
            for (Folder folder : this.m_cachedFolders.values()) {
                try {
                    try {
                        if (folder.isOpen()) {
                            folder.close(true);
                        }
                    }
                    catch (MessagingException e) {
                        exceptions.add(e);
                        try {
                            if (!folder.isOpen()) continue;
                            folder.close(false);
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (folder.isOpen()) {
                            folder.close(false);
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (!folder.isOpen()) continue;
                    folder.close(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                if (this.m_store.isConnected()) {
                    this.m_store.close();
                }
            }
            catch (MessagingException e) {
                exceptions.add(e);
            }
            this.m_cachedFolders.clear();
            if (!exceptions.isEmpty()) {
                throw new ProcessingException(((MessagingException)((Object)exceptions.get(0))).getMessage());
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.m_store != null && this.m_store.isConnected();
    }

    @Override
    public Store getStore() throws ProcessingException {
        this.connect();
        return this.m_store;
    }

    @Override
    public String getDefaultFolderName() {
        return this.m_defaultFolderName;
    }

    @Override
    public void setDefaultFolderName(String defaultFolderName) {
        this.m_defaultFolderName = defaultFolderName;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public void setHost(String host) {
        this.m_host = host;
    }

    @Override
    public int getPort() {
        return this.m_port;
    }

    @Override
    public void setPort(int port) {
        this.m_port = port;
    }

    @Override
    public String getUsername() {
        return this.m_username;
    }

    @Override
    public void setUsername(String username) {
        this.m_username = username;
    }

    @Override
    public String getPassword() {
        return this.m_password;
    }

    @Override
    public void setPassword(String password) {
        this.m_password = password;
    }

    @Override
    public boolean isUseSSL() {
        return this.m_useSSL;
    }

    @Override
    public void setUseSSL(boolean useSSL) {
        this.m_useSSL = useSSL;
    }

    @Override
    public String[] getSSLProtocols() {
        if (this.m_sslProtocols == null) {
            return null;
        }
        return Arrays.copyOf(this.m_sslProtocols, this.m_sslProtocols.length);
    }

    @Override
    public void setSSLProtocols(String[] sslProtocols) {
        this.m_sslProtocols = sslProtocols == null ? null : Arrays.copyOf(sslProtocols, sslProtocols.length);
    }
}

