/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate.checks;

import java.util.Collection;
import java.util.Map;
import org.eclipse.scout.rt.shared.validate.ValidationUtility;
import org.eclipse.scout.rt.shared.validate.checks.IValidateCheck;

public class MaxLengthGenericCheck
implements IValidateCheck {
    private int m_maxLengthString;
    private int m_maxLengthCharArray;
    private int m_maxLengthByteArray;
    private int m_maxLengthOtherArray;

    public MaxLengthGenericCheck(int maxLengthString, int maxLengthCharArray, int maxLengthByteArray, int maxLengthOtherArray) {
        this.m_maxLengthString = maxLengthString;
        this.m_maxLengthCharArray = maxLengthCharArray;
        this.m_maxLengthByteArray = maxLengthByteArray;
        this.m_maxLengthOtherArray = maxLengthOtherArray;
    }

    @Override
    public String getCheckId() {
        return "maxLength";
    }

    @Override
    public boolean accept(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            return true;
        }
        if (obj instanceof Collection || obj instanceof Map) {
            return true;
        }
        return obj instanceof String;
    }

    @Override
    public void check(Object s) throws Exception {
        if (s instanceof String) {
            ValidationUtility.checkMaxLength(s, this.m_maxLengthString);
        } else if (s.getClass() == char[].class) {
            ValidationUtility.checkMaxLength(s, this.m_maxLengthCharArray);
        } else if (s.getClass() == byte[].class) {
            ValidationUtility.checkMaxLength(s, this.m_maxLengthByteArray);
        } else {
            ValidationUtility.checkMaxLength(s, this.m_maxLengthOtherArray);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " string " + this.m_maxLengthString + ", char[] " + this.m_maxLengthCharArray + ", byte[] " + this.m_maxLengthByteArray + ", array " + this.m_maxLengthOtherArray;
    }
}

