/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.ext;

import org.eclipse.scout.rt.ui.rap.IRwtEnvironment;
import org.eclipse.scout.rt.ui.rap.keystroke.RwtKeyStroke;
import org.eclipse.scout.rt.ui.rap.util.RwtUtility;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;

public abstract class MenuAdapterEx
extends MenuAdapter {
    private static final long serialVersionUID = 1L;
    private final Control m_menuControl;
    private final Control m_keyStrokeWidget;
    private P_EscKeyStroke m_escKeyStroke;

    public MenuAdapterEx(Control menuControl, Control keyStrokeWidget) {
        this.m_menuControl = menuControl;
        this.m_keyStrokeWidget = keyStrokeWidget;
    }

    public Control getMenuControl() {
        return this.m_menuControl;
    }

    public Control getKeyStrokeWidget() {
        return this.m_keyStrokeWidget;
    }

    public void menuShown(MenuEvent e) {
        Menu menu = (Menu)e.getSource();
        final IRwtEnvironment uiEnvironment = RwtUtility.getUiEnvironment(e.display);
        this.m_escKeyStroke = new P_EscKeyStroke(menu);
        uiEnvironment.addKeyStroke(this.getKeyStrokeWidget(), this.m_escKeyStroke, true);
        menu.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                if (MenuAdapterEx.this.m_escKeyStroke != null) {
                    uiEnvironment.removeKeyStroke(MenuAdapterEx.this.getKeyStrokeWidget(), MenuAdapterEx.this.m_escKeyStroke);
                    MenuAdapterEx.this.m_escKeyStroke = null;
                }
            }
        });
    }

    public void menuHidden(MenuEvent e) {
        if (this.m_escKeyStroke != null) {
            IRwtEnvironment uiEnvironment = RwtUtility.getUiEnvironment(e.display);
            uiEnvironment.removeKeyStroke(this.getKeyStrokeWidget(), this.m_escKeyStroke);
            this.m_escKeyStroke = null;
        }
    }

    private class P_EscKeyStroke
    extends RwtKeyStroke {
        private Menu m_menu;

        public P_EscKeyStroke(Menu menu) {
            super(RwtUtility.scoutToRwtKey("escape"));
            this.m_menu = menu;
        }

        @Override
        public void handleUiAction(Event keyEvent) {
            IRwtEnvironment uiEnvironment = RwtUtility.getUiEnvironment(keyEvent.display);
            if (this.m_menu != null) {
                this.m_menu.dispose();
            }
            uiEnvironment.removeKeyStroke(MenuAdapterEx.this.getKeyStrokeWidget(), this);
            keyEvent.doit = false;
        }
    }
}

