/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar;

import java.util.HashMap;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.action.AbstractAction;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar.IRwtScoutFormButton;
import org.eclipse.scout.rt.ui.rap.window.desktop.nonmodalFormBar.RwtScoutFormButton;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutFormButtonBar
extends RwtScoutComposite<IDesktop> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(RwtScoutFormButtonBar.class);
    private static final String VARIANT_FORMBAR_CONTAINER = "formbarContainer";
    private static final String VARIANT_FORM_BUTTON_ACTIVE = "formButton-active";
    private static final String VARIANT_FORM_BUTTON = "formButton";
    private HashMap<IForm, IRwtScoutFormButton> m_formTabItems = new HashMap();
    private Composite m_buttonBar;

    public void addFormButton(IForm form) {
        try {
            P_FormButton formButton = new P_FormButton(form);
            formButton.initAction();
            form.addFormListener(new FormListener(){

                public void formChanged(final FormEvent e) throws ProcessingException {
                    RwtScoutFormButtonBar.this.getUiEnvironment().invokeUiLater(new Runnable(){

                        @Override
                        public void run() {
                            IRwtScoutFormButton uiButton = (IRwtScoutFormButton)RwtScoutFormButtonBar.this.m_formTabItems.get(e.getForm());
                            if (uiButton != null && !uiButton.isUiDisposed()) {
                                if (e.getType() == 6000) {
                                    uiButton.makeButtonActive();
                                } else if (e.getType() == 6010) {
                                    uiButton.makeButtonInactive();
                                }
                            }
                        }
                    });
                }
            });
            RwtScoutFormButton uiButton = new RwtScoutFormButton(true, false, VARIANT_FORM_BUTTON, VARIANT_FORM_BUTTON_ACTIVE);
            uiButton.createUiField(this.m_buttonBar, formButton, this.getUiEnvironment());
            this.m_formTabItems.put(form, uiButton);
        }
        catch (ProcessingException e) {
            LOG.error("Could not add FormButton", (Throwable)e);
        }
    }

    public void removeFormButton(IForm form) {
        IRwtScoutFormButton uiButton = this.m_formTabItems.remove(form);
        if (uiButton != null && uiButton.isCreated() && !uiButton.isUiDisposed()) {
            uiButton.dispose();
            this.m_buttonBar.layout(true, true);
        }
    }

    public int getFormButtonBarCount() {
        return this.m_formTabItems.size();
    }

    protected HashMap<IForm, IRwtScoutFormButton> getFormButtons() {
        return this.m_formTabItems;
    }

    @Override
    protected void initializeUi(Composite parent) {
        this.m_buttonBar = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        this.m_buttonBar.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_FORMBAR_CONTAINER);
        RowLayout layout = new RowLayout(256);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        this.m_buttonBar.setLayout((Layout)layout);
        this.setUiContainer(this.m_buttonBar);
    }

    private class P_FormButton
    extends AbstractAction {
        private IForm m_form;

        public P_FormButton(IForm form) {
            super(true);
            this.m_form = form;
        }

        protected void execInitAction() throws ProcessingException {
            this.setText(this.m_form.getTitle());
        }

        protected void execAction() throws ProcessingException {
            this.m_form.activate();
            this.m_form.toFront();
        }
    }
}

