/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.Comparator;
import java.util.List;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;

public class TableRowComparator
implements Comparator<ITableRow> {
    private final List<IColumn<?>> m_columns;

    public TableRowComparator(List<IColumn<?>> columns) {
        this.m_columns = columns;
    }

    @Override
    public int compare(ITableRow row1, ITableRow row2) {
        for (IColumn<?> col : this.m_columns) {
            int c = col.compareTableRows(row1, row2);
            if (!col.getHeaderCell().isSortAscending()) {
                c = -c;
            }
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((TableRowComparator)obj).m_columns == this.m_columns;
    }

    public int hashCode() {
        return 0;
    }
}

