/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.commons.BeanUtility;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.annotations.ColumnData;
import org.eclipse.scout.commons.annotations.Replace;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.beans.IPropertyFilter;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.data.form.FormDataUtility;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.IInternalExtensionRegistry;
import org.eclipse.scout.service.SERVICES;

public class TableRowDataMapper
implements ITableRowDataMapper {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableRowDataMapper.class);
    private final Map<IColumn, FastPropertyDescriptor> m_propertyDescriptorByColumn;
    private final ColumnSet m_columnSet;
    private final Set<IColumn<?>> m_ignoredColumns;

    public TableRowDataMapper(Class<? extends AbstractTableRowData> rowType, ColumnSet columnSet) throws ProcessingException {
        if (rowType == null) {
            throw new IllegalArgumentException("rowType must not be null");
        }
        if (columnSet == null) {
            throw new IllegalArgumentException("columnSet must not be null");
        }
        this.m_columnSet = columnSet;
        IPropertyFilter filter = this.createPropertyFilter();
        LinkedList<FastPropertyDescriptor> props = new LinkedList<FastPropertyDescriptor>();
        FastPropertyDescriptor[] fastPropertyDescriptorArray = BeanUtility.getFastPropertyDescriptors(rowType, AbstractTableRowData.class, (IPropertyFilter)filter);
        int n = fastPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            FastPropertyDescriptor desc = fastPropertyDescriptorArray[n2];
            props.add(desc);
            ++n2;
        }
        Set contributions = ((IInternalExtensionRegistry)SERVICES.getService(IInternalExtensionRegistry.class)).getContributionsFor(rowType);
        for (Class contribution : contributions) {
            FastPropertyDescriptor[] fastPropertyDescriptorArray2 = BeanUtility.getFastPropertyDescriptors((Class)contribution, Object.class, (IPropertyFilter)filter);
            int n3 = fastPropertyDescriptorArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                FastPropertyDescriptor desc = fastPropertyDescriptorArray2[n4];
                props.add(desc);
                ++n4;
            }
        }
        this.m_propertyDescriptorByColumn = new HashMap<IColumn, FastPropertyDescriptor>(props.size());
        for (FastPropertyDescriptor rowDataPropertyDesc : props) {
            IColumn column = this.findColumn(columnSet, rowDataPropertyDesc);
            if (column != null) {
                this.m_propertyDescriptorByColumn.put(column, rowDataPropertyDesc);
                continue;
            }
            LOG.warn("No column found for property [" + rowDataPropertyDesc.getBeanClass().getName() + "#" + rowDataPropertyDesc.getName() + "]");
        }
        HashSet<IColumn> ignoredColumns = null;
        for (IColumn iColumn : columnSet.getColumns()) {
            if (!this.isColumnIgnored(iColumn)) continue;
            if (ignoredColumns == null) {
                ignoredColumns = new HashSet<IColumn>();
            }
            ignoredColumns.add(iColumn);
        }
        this.m_ignoredColumns = ignoredColumns != null ? ignoredColumns : CollectionUtility.hashSet((Object[])new IColumn[0]);
    }

    protected IPropertyFilter createPropertyFilter() {
        return new TableRowDataPropertyFilter();
    }

    protected IColumn findColumn(ColumnSet columnset, FastPropertyDescriptor rowDataPropertyDesc) {
        String columnId = this.capitalize(rowDataPropertyDesc.getName());
        return columnset.getColumnById(columnId);
    }

    protected boolean isColumnIgnored(IColumn<?> column) {
        Class<?> c = column.getClass();
        ColumnData a = null;
        while (((a = c.getAnnotation(ColumnData.class)) == null || a.value() == ColumnData.SdkColumnCommand.IGNORE) && c.isAnnotationPresent(Replace.class)) {
            c = c.getSuperclass();
        }
        return a != null && a.value() == ColumnData.SdkColumnCommand.IGNORE;
    }

    private String capitalize(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    @Override
    public void importTableRowData(ITableRow row, AbstractTableRowData rowData) throws ProcessingException {
        for (IColumn<?> column : this.m_columnSet.getColumns()) {
            if (this.m_ignoredColumns.contains(column)) continue;
            Object value = null;
            FastPropertyDescriptor propertyDesc = this.m_propertyDescriptorByColumn.get(column);
            if (propertyDesc != null) {
                try {
                    Object dto = this.getDataContainer(column, rowData);
                    value = propertyDesc.getReadMethod().invoke(dto, new Object[0]);
                }
                catch (Throwable t) {
                    LOG.warn("Error reading row data property for column [" + column.getClass().getName() + "]", t);
                }
            } else {
                value = rowData.getCustomColumnValue(column.getColumnId());
            }
            column.setValue(row, value);
        }
        row.setStatus(rowData.getRowState());
    }

    @Override
    public void exportTableRowData(ITableRow row, AbstractTableRowData rowData) throws ProcessingException {
        for (IColumn<?> column : this.m_columnSet.getColumns()) {
            if (this.m_ignoredColumns.contains(column)) continue;
            Object value = column.getValue(row);
            FastPropertyDescriptor propertyDesc = this.m_propertyDescriptorByColumn.get(column);
            if (propertyDesc != null) {
                try {
                    Object dto = this.getDataContainer(column, rowData);
                    propertyDesc.getWriteMethod().invoke(dto, value);
                }
                catch (Throwable t) {
                    LOG.warn("Error writing row data property for column [" + column.getClass().getName() + "]", t);
                }
                continue;
            }
            rowData.setCustomColumnValue(column.getColumnId(), value);
        }
        rowData.setRowState(row.getStatus());
    }

    protected Object getDataContainer(IColumn column, AbstractTableRowData rowData) {
        Class<?> declaringClass;
        Class dtoClass = FormDataUtility.getDataAnnotationValue(column.getClass());
        if (dtoClass == null && (declaringClass = column.getClass().getDeclaringClass()) != null && IExtension.class.isAssignableFrom(declaringClass)) {
            dtoClass = FormDataUtility.getDataAnnotationValue(declaringClass);
        }
        if (dtoClass == null || rowData.getClass().equals(dtoClass)) {
            return rowData;
        }
        return rowData.getContribution(dtoClass);
    }

    @Override
    public boolean acceptExport(ITableRow row) throws ProcessingException {
        return true;
    }

    @Override
    public boolean acceptImport(AbstractTableRowData rowData) throws ProcessingException {
        return true;
    }

    @Deprecated
    public static class TableRowDataPropertyFilter
    extends org.eclipse.scout.rt.shared.data.form.fields.tablefield.TableRowDataPropertyFilter {
    }
}

