/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.IOrdered;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.annotations.OrderedCollection;
import org.eclipse.scout.commons.annotations.OrderedComparator;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.ProcessingStatus;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.extension.ui.action.tree.MoveActionNodesHandler;
import org.eclipse.scout.rt.client.extension.ui.desktop.DesktopChains;
import org.eclipse.scout.rt.client.services.common.bookmark.internal.BookmarkUtility;
import org.eclipse.scout.rt.client.ui.DataChangeListener;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.action.view.IViewButton;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.desktop.ContributionCommand;
import org.eclipse.scout.rt.client.ui.desktop.DesktopEvent;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopExtension;
import org.eclipse.scout.rt.client.ui.desktop.IDesktopUIFacade;
import org.eclipse.scout.rt.client.ui.desktop.IUrlTarget;
import org.eclipse.scout.rt.client.ui.desktop.UnsavedFormChangesForm;
import org.eclipse.scout.rt.client.ui.desktop.UrlTarget;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.outline.AbstractFormToolButton;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutlineTableForm;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.PrintDevice;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.messagebox.IMessageBox;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxEvent;
import org.eclipse.scout.rt.client.ui.messagebox.MessageBoxListener;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.extension.AbstractExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.ExtensionUtility;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.shell.IShellService;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractDesktop
extends AbstractPropertyObserver
implements IDesktop,
IContributionOwner,
IExtensibleObject {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractDesktop.class);
    private final IDesktopExtension m_localDesktopExtension;
    private List<IDesktopExtension> m_desktopExtensions;
    private final EventListenerList m_listenerList;
    private int m_dataChanging;
    private final List<Object[]> m_dataChangeEventBuffer;
    private final Map<Object, EventListenerList> m_dataChangeListenerList;
    private final IDesktopUIFacade m_uiFacade;
    private List<IOutline> m_availableOutlines;
    private IOutline m_outline;
    private boolean m_outlineChanging = false;
    private P_ActiveOutlineListener m_activeOutlineListener;
    private final P_ActivatedFormListener m_activatedFormListener;
    private final List<WeakReference<IForm>> m_lastActiveFormList;
    private ITable m_pageDetailTable;
    private IOutlineTableForm m_outlineTableForm;
    private boolean m_outlineTableFormVisible = true;
    private IForm m_pageDetailForm;
    private IForm m_pageSearchForm;
    private final List<IForm> m_viewStack;
    private final List<IForm> m_dialogStack;
    private final List<IMessageBox> m_messageBoxStack;
    private List<IMenu> m_menus;
    private List<IViewButton> m_viewButtons;
    private List<IToolButton> m_toolButtons;
    private boolean m_autoPrefixWildcardForTextSearch;
    private boolean m_desktopInited;
    private boolean m_trayVisible;
    private boolean m_isForcedClosing = false;
    private IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractDesktop, org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> m_objectExtensions;
    private Map<IOutline, Bookmark> m_bookmarkPerOutline = new HashMap<IOutline, Bookmark>();

    public AbstractDesktop() {
        this(true);
    }

    public AbstractDesktop(boolean callInitializer) {
        this.m_localDesktopExtension = new P_LocalDesktopExtension();
        this.m_listenerList = new EventListenerList();
        this.m_dataChangeListenerList = new HashMap<Object, EventListenerList>();
        this.m_dataChangeEventBuffer = new ArrayList<Object[]>();
        this.m_viewStack = new ArrayList<IForm>();
        this.m_dialogStack = new ArrayList<IForm>();
        this.m_messageBoxStack = new ArrayList<IMessageBox>();
        this.m_uiFacade = new P_UIFacade();
        this.m_activatedFormListener = new P_ActivatedFormListener();
        this.m_lastActiveFormList = new LinkedList<WeakReference<IForm>>();
        this.m_objectExtensions = new ObjectExtensions((Object)this);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected final void callInitializer() {
        this.interceptInitConfig();
    }

    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <T> List<T> getContributionsByClass(Class<T> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <T> T getContribution(Class<T> contribution) {
        return (T)this.m_contributionHolder.getContribution(contribution);
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=15.0)
    protected boolean getConfiguredTrayVisible() {
        return false;
    }

    @ConfigProperty(value="OUTLINES")
    @Order(value=20.0)
    protected List<Class<? extends IOutline>> getConfiguredOutlines() {
        return null;
    }

    private List<Class<? extends IAction>> getConfiguredActions() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        List fca = ConfigurationUtility.filterClasses((Class[])dca, IAction.class);
        return ConfigurationUtility.removeReplacedClasses((List)fca);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInit() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=12.0)
    protected void execOpened() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=14.0)
    protected void execBeforeClosing() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execClosing() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execGuiAttached() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=25.0)
    protected void execGuiDetached() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected void execOutlineChanged(IOutline oldOutline, IOutline newOutline) throws ProcessingException {
    }

    @Order(value=40.0)
    @ConfigOperation
    protected void execPageSearchFormChanged(IForm oldForm, IForm newForm) throws ProcessingException {
        if (oldForm != null) {
            this.removeForm(oldForm);
        }
        if (newForm != null) {
            GridData gd = newForm.getRootGroupBox().getGridData();
            if (gd.weightY <= 0.0) {
                gd.weightY = 0.0;
                newForm.getRootGroupBox().setGridDataInternal(gd);
            }
            this.addForm(newForm);
        }
    }

    @Order(value=50.0)
    @ConfigOperation
    protected void execPageDetailFormChanged(IForm oldForm, IForm newForm) throws ProcessingException {
        if (oldForm != null) {
            this.removeForm(oldForm);
        }
        if (newForm != null) {
            this.addForm(newForm);
        }
    }

    @Order(value=60.0)
    @ConfigOperation
    protected void execPageDetailTableChanged(ITable oldTable, ITable newTable) throws ProcessingException {
        if (this.m_outlineTableForm != null) {
            this.m_outlineTableForm.setCurrentTable(newTable);
        }
        this.setOutlineTableFormVisible(newTable != null);
    }

    @Order(value=62.0)
    @ConfigOperation
    protected void execTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        ISearchForm searchForm = tablePage.getSearchFormInternal();
        if (searchForm != null) {
            searchForm.setMinimized(((ITable)tablePage.getTable()).getRowCount() > 0);
        }
    }

    @Order(value=70.0)
    @ConfigOperation
    protected void execAddTrayMenus(List<IMenu> menus) throws ProcessingException {
    }

    public List<IDesktopExtension> getDesktopExtensions() {
        return CollectionUtility.arrayList(this.m_desktopExtensions);
    }

    protected IDesktopExtension getLocalDesktopExtension() {
        return this.m_localDesktopExtension;
    }

    protected org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop> createLocalExtension() {
        return new LocalDesktopExtension<AbstractDesktop>(this);
    }

    public final List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), new Runnable(){

            @Override
            public void run() {
                AbstractDesktop.this.initConfig();
            }
        });
    }

    protected void initConfig() {
        this.initDesktopExtensions();
        this.setTitle(this.getConfiguredTitle());
        this.setTrayVisible(this.getConfiguredTrayVisible());
        List<IDesktopExtension> extensions = this.getDesktopExtensions();
        this.m_contributionHolder = new ContributionComposite((Object)this);
        OrderedCollection outlines = new OrderedCollection();
        for (IDesktopExtension ext : extensions) {
            try {
                ext.contributeOutlines((OrderedCollection<IOutline>)outlines);
            }
            catch (Throwable t) {
                LOG.error("contrinuting outlines by " + ext, t);
            }
        }
        List contributedOutlines = this.m_contributionHolder.getContributionsByClass(IOutline.class);
        outlines.addAllOrdered((Collection)contributedOutlines);
        ExtensionUtility.moveModelObjects((Iterable)outlines);
        this.m_availableOutlines = outlines.getOrderedList();
        ArrayList<IAction> actionList = new ArrayList<IAction>();
        for (IDesktopExtension ext : extensions) {
            try {
                ext.contributeActions(actionList);
            }
            catch (Throwable t) {
                LOG.error("contrinuting actions by " + ext, t);
            }
        }
        List contributedActions = this.m_contributionHolder.getContributionsByClass(IAction.class);
        actionList.addAll(contributedActions);
        for (IMenu menu : new ActionFinder().findActions(actionList, IMenu.class, true)) {
            if (menu.getKeyStroke() == null) continue;
            try {
                KeyStroke ks = new KeyStroke(menu.getKeyStroke(), menu);
                ks.initAction();
                actionList.add(ks);
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
        }
        OrderedCollection menus = new OrderedCollection();
        menus.addAllOrdered(new ActionFinder().findActions(actionList, IMenu.class, false));
        new MoveActionNodesHandler(menus).moveModelObjects();
        this.m_menus = menus.getOrderedList();
        OrderedComparator orderedComparator = new OrderedComparator();
        List<IViewButton> viewButtonList = new ActionFinder().findActions(actionList, IViewButton.class, false);
        ExtensionUtility.moveModelObjects(viewButtonList);
        Collections.sort(viewButtonList, orderedComparator);
        this.m_viewButtons = viewButtonList;
        List<IToolButton> toolButtonList = new ActionFinder().findActions(actionList, IToolButton.class, false);
        ExtensionUtility.moveModelObjects(toolButtonList);
        Collections.sort(toolButtonList, orderedComparator);
        this.m_toolButtons = toolButtonList;
        List<IKeyStroke> ksList = new ActionFinder().findActions(actionList, IKeyStroke.class, true);
        for (IKeyStroke ks : ksList) {
            try {
                ks.initAction();
            }
            catch (ProcessingException e) {
                LOG.error("could not initialize key stroke '" + ks + "'.", (Throwable)e);
            }
        }
        this.addKeyStrokes(ksList.toArray(new IKeyStroke[ksList.size()]));
        for (IOutline o : this.m_availableOutlines) {
            try {
                o.initTree();
            }
            catch (Throwable t) {
                LOG.error(null, t);
            }
        }
    }

    protected final void interceptInit() throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopInitChain chain = new DesktopChains.DesktopInitChain(extensions);
        chain.execInit();
    }

    private void initDesktopExtensions() {
        this.m_desktopExtensions = new LinkedList<IDesktopExtension>();
        this.m_desktopExtensions.add(this.getLocalDesktopExtension());
        this.injectDesktopExtensions(this.m_desktopExtensions);
    }

    protected void injectDesktopExtensions(List<IDesktopExtension> desktopExtensions) {
    }

    @Override
    public void initDesktop() throws ProcessingException {
        if (!this.m_desktopInited) {
            this.m_desktopInited = true;
            this.prepareAllMenus();
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.initDelegate();
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Throwable t) {
                    LOG.error("extension " + ext);
                }
            }
            ActionUtility.initActions(this.getMenus());
            ActionUtility.initActions(this.getToolButtons());
            ActionUtility.initActions(this.getViewButtons());
        }
    }

    @Override
    public boolean isTrayVisible() {
        return this.m_trayVisible;
    }

    @Override
    public void setTrayVisible(boolean b) {
        this.m_trayVisible = b;
    }

    @Override
    public boolean isShowing(IForm form) {
        if (form == null) {
            return false;
        }
        if (form.getOuterForm() != null) {
            return form.getOuterForm().isShowing();
        }
        for (IForm f : this.m_viewStack) {
            if (f != form) continue;
            return true;
        }
        for (IForm f : this.m_dialogStack) {
            if (f != form) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends IForm> T findForm(Class<T> formType) {
        ArrayList<IForm> list = new ArrayList<IForm>();
        list.addAll(this.m_viewStack);
        list.addAll(this.m_dialogStack);
        for (IForm f : list) {
            if (!formType.isAssignableFrom(f.getClass())) continue;
            return (T)f;
        }
        return null;
    }

    @Override
    public <T extends IOutline> T findOutline(Class<T> outlineType) {
        for (IOutline o : this.getAvailableOutlines()) {
            if (!outlineType.isAssignableFrom(o.getClass())) continue;
            return (T)o;
        }
        return null;
    }

    @Override
    public <T extends IAction> T findAction(Class<T> actionType) {
        return new ActionFinder().findAction(this.getActions(), actionType);
    }

    @Override
    public <T extends IToolButton> T findToolButton(Class<T> toolButtonType) {
        return (T)((IToolButton)this.findAction(toolButtonType));
    }

    @Override
    public <T extends IViewButton> T findViewButton(Class<T> viewButtonType) {
        return (T)((IViewButton)this.findAction(viewButtonType));
    }

    @Override
    public IFormField getFocusOwner() {
        return this.fireFindFocusOwner();
    }

    @Override
    public IForm getActiveForm() {
        return this.fireFindActiveForm();
    }

    @Override
    public <T extends IForm> List<T> findForms(Class<T> formType) {
        ArrayList<IForm> resultList = new ArrayList<IForm>();
        if (formType != null) {
            ArrayList<IForm> list = new ArrayList<IForm>();
            list.addAll(this.m_viewStack);
            list.addAll(this.m_dialogStack);
            for (IForm f : list) {
                if (!formType.isAssignableFrom(f.getClass())) continue;
                resultList.add(f);
            }
        }
        return resultList;
    }

    @Override
    public <T extends IForm> T findLastActiveForm(Class<T> formType) {
        if (this.m_lastActiveFormList != null && formType != null) {
            for (WeakReference<IForm> formRef : this.m_lastActiveFormList) {
                if (formRef.get() == null || !formType.isAssignableFrom(((IForm)formRef.get()).getClass())) continue;
                return (T)((IForm)formRef.get());
            }
        }
        return null;
    }

    @Override
    public <T extends IMenu> T getMenu(Class<? extends T> searchType) {
        return (T)((IMenu)new ActionFinder().findAction(this.getMenus(), searchType));
    }

    @Override
    public List<IForm> getViewStack() {
        return CollectionUtility.arrayList(this.m_viewStack);
    }

    @Override
    public List<IForm> getDialogStack() {
        return CollectionUtility.arrayList(this.m_dialogStack);
    }

    @Override
    public List<IForm> getSimilarViewForms(IForm form) {
        ArrayList<IForm> forms = new ArrayList<IForm>(3);
        try {
            if (form != null && form.computeExclusiveKey() != null) {
                Object originalKey = form.computeExclusiveKey();
                for (IForm f : this.m_viewStack) {
                    Object candidateKey = f.computeExclusiveKey();
                    if (this.getPageDetailForm() == f || this.getPageSearchForm() == f || candidateKey == null || originalKey == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("form: " + candidateKey + " vs " + originalKey);
                    }
                    if (!f.getClass().getName().equals(form.getClass().getName()) || !originalKey.equals(candidateKey)) continue;
                    forms.add(f);
                }
            }
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        return forms;
    }

    @Override
    public void ensureViewStackVisible() {
        if (CollectionUtility.isEmpty(this.m_viewStack)) {
            return;
        }
        for (IForm form : this.m_viewStack) {
            this.ensureVisible(form);
        }
    }

    @Override
    public void ensureVisible(IForm form) {
        if (form != null && (this.m_viewStack.contains(form) || this.m_dialogStack.contains(form))) {
            this.fireFormEnsureVisible(form);
        }
    }

    @Override
    public void addForm(IForm form) {
        Holder formHolder = new Holder(IForm.class, (Object)form);
        for (IDesktopExtension ext : this.getDesktopExtensions()) {
            try {
                ContributionCommand cc = ext.customFormModificationDelegate((IHolder<IForm>)formHolder);
                if (cc != ContributionCommand.Stop) continue;
                break;
            }
            catch (ProcessingException e) {
                formHolder.setValue((Object)form);
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable t) {
                formHolder.setValue((Object)form);
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Formmodification error: " + form, t));
            }
        }
        form = (IForm)formHolder.getValue();
        if (form != null) {
            switch (form.getDisplayHint()) {
                case 0: 
                case 10: 
                case 12: {
                    if (this.m_viewStack.remove(form)) {
                        this.fireFormRemoved(form);
                    }
                    if (form.getDisplayHint() == 10) {
                        for (IForm f : new ArrayList<IForm>(this.m_dialogStack)) {
                            if (f.getDisplayHint() != 10) continue;
                            try {
                                f.doClose();
                            }
                            catch (Throwable t) {
                                LOG.error("Failed closing popup " + f, t);
                            }
                        }
                    }
                    if (this.m_dialogStack.contains(form)) break;
                    this.m_dialogStack.add(form);
                    this.fireFormAdded(form);
                    break;
                }
                case 20: {
                    if (this.m_dialogStack.remove(form)) {
                        this.fireFormRemoved(form);
                    }
                    if (this.m_viewStack.contains(form)) break;
                    this.m_viewStack.add(form);
                    this.fireFormAdded(form);
                }
            }
            this.m_lastActiveFormList.add(new WeakReference<IForm>(form));
            form.addFormListener(this.m_activatedFormListener);
        }
    }

    @Override
    public void removeForm(IForm form) {
        if (form != null) {
            if (this.m_lastActiveFormList != null) {
                Iterator<WeakReference<IForm>> it = this.m_lastActiveFormList.iterator();
                while (it.hasNext()) {
                    WeakReference<IForm> formRef = it.next();
                    if (formRef.get() != null && !form.equals(formRef.get())) continue;
                    it.remove();
                }
            }
            form.removeFormListener(this.m_activatedFormListener);
            boolean b1 = this.m_dialogStack.remove(form);
            boolean b2 = this.m_viewStack.remove(form);
            if (b1 || b2) {
                this.fireFormRemoved(form);
            }
        }
    }

    @Override
    public List<IMessageBox> getMessageBoxStack() {
        return CollectionUtility.arrayList(this.m_messageBoxStack);
    }

    @Override
    public void addMessageBox(final IMessageBox mb) {
        this.m_messageBoxStack.add(mb);
        mb.addMessageBoxListener(new MessageBoxListener(){

            @Override
            public void messageBoxChanged(MessageBoxEvent e) {
                switch (e.getType()) {
                    case 900: {
                        AbstractDesktop.this.removeMessageBoxInternal(mb);
                    }
                }
            }
        });
        this.fireMessageBoxAdded(mb);
    }

    private void removeMessageBoxInternal(IMessageBox mb) {
        this.m_messageBoxStack.remove(mb);
        this.fireMessageBoxRemoved(mb);
    }

    @Override
    public List<IOutline> getAvailableOutlines() {
        return CollectionUtility.arrayList(this.m_availableOutlines);
    }

    @Override
    public void setAvailableOutlines(List<? extends IOutline> availableOutlines) {
        this.setOutline((IOutline)null);
        this.m_availableOutlines = CollectionUtility.arrayList(availableOutlines);
    }

    @Override
    public IOutline getOutline() {
        return this.m_outline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutline(IOutline outline) {
        if (this.m_outline == (outline = this.resolveOutline(outline)) || this.m_outlineChanging) {
            return;
        }
        AbstractDesktop abstractDesktop = this;
        synchronized (abstractDesktop) {
            block25: {
                try {
                    Bookmark bm;
                    IPage oldActivePage;
                    this.m_outlineChanging = true;
                    if (this.m_outline != null && (oldActivePage = this.m_outline.getActivePage()) != null && (bm = ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, oldActivePage)) != null) {
                        this.m_bookmarkPerOutline.put(this.m_outline, bm);
                    }
                    IOutline oldOutline = this.m_outline;
                    if (this.m_activeOutlineListener != null && oldOutline != null) {
                        oldOutline.removeTreeListener(this.m_activeOutlineListener);
                        oldOutline.removePropertyChangeListener(this.m_activeOutlineListener);
                        this.m_activeOutlineListener = null;
                    }
                    this.m_outline = outline;
                    if (oldOutline != null) {
                        oldOutline.clearContextPage();
                    }
                    if (this.m_outline != null) {
                        this.m_activeOutlineListener = new P_ActiveOutlineListener();
                        this.m_outline.addTreeListener(this.m_activeOutlineListener);
                        this.m_outline.addPropertyChangeListener(this.m_activeOutlineListener);
                    }
                    if (this.m_outline == null) {
                        this.setPageDetailForm(null);
                        this.setPageDetailTable(null);
                        this.setPageSearchForm(null, true);
                    }
                    this.fireOutlineChanged(oldOutline, this.m_outline);
                    if (this.m_outline == null) break block25;
                    if (this.m_outline.getActivePage() != null) {
                        try {
                            this.m_outline.getActivePage().ensureChildrenLoaded();
                        }
                        catch (ProcessingException e) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                        }
                    }
                    this.m_outline.setNodeExpanded(this.m_outline.getRootNode(), true);
                    this.setPageDetailForm(this.m_outline.getDetailForm());
                    this.setPageDetailTable(this.m_outline.getDetailTable());
                    this.setPageSearchForm(this.m_outline.getSearchForm(), true);
                    this.m_outline.makeActivePageToContextPage();
                    IPage newActivePage = this.m_outline.getActivePage();
                    if (newActivePage == null) {
                        Bookmark bookmark = this.m_bookmarkPerOutline.get(this.m_outline);
                        if (bookmark != null && Boolean.TRUE.booleanValue()) {
                            try {
                                this.activateBookmark(bookmark, false);
                            }
                            catch (ProcessingException e) {
                                LOG.warn(String.format("Could not activate bookmark '%s' for restoring state of outline '%s'.", bookmark.getText(), this.m_outline), (Throwable)e);
                            }
                        } else {
                            if (this.m_outline.isRootNodeVisible()) {
                                this.m_outline.selectNode(this.m_outline.getRootNode(), false);
                            } else {
                                List<ITreeNode> children = this.m_outline.getRootNode().getChildNodes();
                                if (CollectionUtility.hasElements(children)) {
                                    for (ITreeNode node : children) {
                                        if (!node.isVisible() || !node.isEnabled()) continue;
                                        this.m_outline.selectNode(node, false);
                                        break;
                                    }
                                }
                            }
                            newActivePage = this.m_outline.getActivePage();
                        }
                    }
                    if (newActivePage != null) {
                        ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, newActivePage);
                    }
                }
                finally {
                    this.m_outlineChanging = false;
                }
            }
        }
    }

    private IOutline resolveOutline(IOutline outline) {
        for (IOutline o : this.getAvailableOutlines()) {
            if (o != outline) continue;
            return o;
        }
        return null;
    }

    @Override
    public void setOutline(Class<? extends IOutline> outlineType) {
        if (outlineType == null) {
            return;
        }
        for (IOutline o : this.getAvailableOutlines()) {
            if (!outlineType.isInstance(o)) continue;
            this.setOutline(o);
            return;
        }
    }

    @Override
    public Set<IKeyStroke> getKeyStrokes() {
        return CollectionUtility.hashSet((Collection)this.propertySupport.getPropertySet("keyStrokes"));
    }

    @Override
    public void setKeyStrokes(Collection<? extends IKeyStroke> ks) {
        this.propertySupport.setPropertySet("keyStrokes", (Set)CollectionUtility.hashSetWithoutNullElements(ks));
    }

    @Override
    public void addKeyStrokes(IKeyStroke ... keyStrokes) {
        if (keyStrokes != null && keyStrokes.length > 0) {
            HashMap<String, IKeyStroke> map = new HashMap<String, IKeyStroke>();
            for (IKeyStroke ks : this.getKeyStrokes()) {
                map.put(ks.getKeyStroke(), ks);
            }
            IKeyStroke[] iKeyStrokeArray = keyStrokes;
            int n = keyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyStroke ks;
                ks = iKeyStrokeArray[n2];
                map.put(ks.getKeyStroke(), ks);
                ++n2;
            }
            this.setKeyStrokes(map.values());
        }
    }

    @Override
    public void removeKeyStrokes(IKeyStroke ... keyStrokes) {
        if (keyStrokes != null && keyStrokes.length > 0) {
            HashMap<String, IKeyStroke> map = new HashMap<String, IKeyStroke>();
            for (IKeyStroke ks : this.getKeyStrokes()) {
                map.put(ks.getKeyStroke(), ks);
            }
            IKeyStroke[] iKeyStrokeArray = keyStrokes;
            int n = keyStrokes.length;
            int n2 = 0;
            while (n2 < n) {
                IKeyStroke ks;
                ks = iKeyStrokeArray[n2];
                map.remove(ks.getKeyStroke());
                ++n2;
            }
            this.setKeyStrokes(map.values());
        }
    }

    @Override
    public List<IMenu> getMenus() {
        return CollectionUtility.arrayList(this.m_menus);
    }

    @Override
    public void prepareAllMenus() {
        for (IMenu child : this.getMenus()) {
            this.prepareMenuRec(child);
        }
    }

    private void prepareMenuRec(IMenu menu) {
        menu.prepareAction();
        for (IMenu child : menu.getChildActions()) {
            this.prepareMenuRec(child);
        }
    }

    @Override
    public List<IAction> getActions() {
        ArrayList<IAction> result = new ArrayList<IAction>();
        result.addAll(this.getKeyStrokes());
        result.addAll(this.getMenus());
        result.addAll(this.getViewButtons());
        result.addAll(this.getToolButtons());
        return result;
    }

    @Override
    public <T extends IToolButton> T getToolButton(Class<? extends T> searchType) {
        return (T)((IToolButton)new ActionFinder().findAction(this.getMenus(), searchType));
    }

    @Override
    public List<IToolButton> getToolButtons() {
        return CollectionUtility.arrayList(this.m_toolButtons);
    }

    @Override
    public <T extends IViewButton> T getViewButton(Class<? extends T> searchType) {
        return (T)((IViewButton)new ActionFinder().findAction(this.getMenus(), searchType));
    }

    @Override
    public List<IViewButton> getViewButtons() {
        return CollectionUtility.arrayList(this.m_viewButtons);
    }

    @Override
    public IForm getPageDetailForm() {
        return this.m_pageDetailForm;
    }

    @Override
    public void setPageDetailForm(IForm f) {
        if (this.m_pageDetailForm != f) {
            IForm oldForm = this.m_pageDetailForm;
            this.m_pageDetailForm = f;
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.pageDetailFormChangedDelegate(oldForm, this.m_pageDetailForm);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Throwable t) {
                    LOG.error("extension " + ext, t);
                }
            }
        }
    }

    @Override
    public IForm getPageSearchForm() {
        return this.m_pageSearchForm;
    }

    @Override
    public void setPageSearchForm(IForm f) {
        this.setPageSearchForm(f, false);
    }

    public void setPageSearchForm(IForm f, boolean force) {
        if (force || this.m_pageSearchForm != f) {
            IForm oldForm = this.m_pageSearchForm;
            this.m_pageSearchForm = f;
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.pageSearchFormChangedDelegate(oldForm, this.m_pageSearchForm);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Throwable t) {
                    LOG.error("extension " + ext, t);
                }
            }
        }
    }

    @Override
    public IOutlineTableForm getOutlineTableForm() {
        return this.m_outlineTableForm;
    }

    @Override
    public void setOutlineTableForm(IOutlineTableForm f) {
        if (f != this.m_outlineTableForm) {
            if (this.m_outlineTableForm != null) {
                this.removeForm(this.m_outlineTableForm);
            }
            this.m_outlineTableForm = f;
            if (this.m_outlineTableForm != null) {
                this.m_outlineTableForm.setCurrentTable(this.getPageDetailTable());
                this.setOutlineTableFormVisible(this.getPageDetailTable() != null);
            }
            if (this.m_outlineTableForm != null && this.m_outlineTableFormVisible) {
                this.addForm(this.m_outlineTableForm);
            }
        }
    }

    @Override
    public boolean isOutlineTableFormVisible() {
        return this.m_outlineTableFormVisible;
    }

    @Override
    public void setOutlineTableFormVisible(boolean b) {
        if (this.m_outlineTableFormVisible != b) {
            this.m_outlineTableFormVisible = b;
            if (this.m_outlineTableForm != null) {
                if (this.m_outlineTableFormVisible) {
                    this.addForm(this.m_outlineTableForm);
                } else {
                    this.removeForm(this.m_outlineTableForm);
                }
            }
        }
    }

    @Override
    public ITable getPageDetailTable() {
        return this.m_pageDetailTable;
    }

    @Override
    public void setPageDetailTable(ITable t) {
        if (this.m_pageDetailTable != t) {
            ITable oldTable = this.m_pageDetailTable;
            this.m_pageDetailTable = t;
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.pageDetailTableChangedDelegate(oldTable, this.m_pageDetailTable);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Throwable x) {
                    LOG.error("extension " + ext, x);
                }
            }
        }
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public IProcessingStatus getStatus() {
        return (IProcessingStatus)this.propertySupport.getProperty("status");
    }

    @Override
    public void setStatus(IProcessingStatus status) {
        this.propertySupport.setProperty("status", (Object)status);
    }

    @Override
    public void setStatusText(String s) {
        if (s != null) {
            this.setStatus((IProcessingStatus)new ProcessingStatus(s, null, 0, 1));
        } else {
            this.setStatus(null);
        }
    }

    @Override
    public void printDesktop(PrintDevice device, Map<String, Object> parameters) {
        try {
            this.firePrint(device, parameters);
        }
        catch (ProcessingException e) {
            e.addContextMessage(String.valueOf(ScoutTexts.get((String)"FormPrint", (String[])new String[0])) + " " + this.getTitle());
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
    }

    @Override
    public void addFileChooser(IFileChooser fc) {
        this.fireFileChooserAdded(fc);
    }

    @Override
    public void openUrlInBrowser(String url) {
        this.openUrlInBrowser(url, null);
    }

    @Override
    public void openUrlInBrowser(String url, IUrlTarget target) {
        if (!UserAgentUtility.isWebClient()) {
            try {
                ((IShellService)SERVICES.getService(IShellService.class)).shellOpen(url);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        } else {
            if (target == null) {
                target = UrlTarget.AUTO;
            }
            this.fireOpenUrlInBrowser(url, target);
        }
    }

    @Override
    public boolean isAutoPrefixWildcardForTextSearch() {
        return this.m_autoPrefixWildcardForTextSearch;
    }

    @Override
    public void setAutoPrefixWildcardForTextSearch(boolean b) {
        this.m_autoPrefixWildcardForTextSearch = b;
    }

    @Override
    public boolean isOpened() {
        return this.propertySupport.getPropertyBool("opened");
    }

    private void setOpenedInternal(boolean b) {
        this.propertySupport.setPropertyBool("opened", b);
    }

    private void setGuiAvailableInternal(boolean guiAvailable) {
        this.propertySupport.setPropertyBool("guiAvailable", guiAvailable);
    }

    @Override
    public boolean isGuiAvailable() {
        return this.propertySupport.getPropertyBool("guiAvailable");
    }

    @Override
    public void addDesktopListener(DesktopListener l) {
        this.m_listenerList.add(DesktopListener.class, (EventListener)l);
    }

    @Override
    public void removeDesktopListener(DesktopListener l) {
        this.m_listenerList.remove(DesktopListener.class, (EventListener)l);
    }

    @Override
    public void addDataChangeListener(DataChangeListener listener, Object ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            EventListenerList list = this.m_dataChangeListenerList.get(null);
            if (list == null) {
                list = new EventListenerList();
                this.m_dataChangeListenerList.put(null, list);
            }
            list.add(DataChangeListener.class, (EventListener)listener);
        } else {
            Object[] objectArray = dataTypes;
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object dataType = objectArray[n2];
                if (dataType != null) {
                    EventListenerList list = this.m_dataChangeListenerList.get(dataType);
                    if (list == null) {
                        list = new EventListenerList();
                        this.m_dataChangeListenerList.put(dataType, list);
                    }
                    list.add(DataChangeListener.class, (EventListener)listener);
                }
                ++n2;
            }
        }
    }

    @Override
    public void removeDataChangeListener(DataChangeListener listener, Object ... dataTypes) {
        if (dataTypes == null || dataTypes.length == 0) {
            Iterator<EventListenerList> it = this.m_dataChangeListenerList.values().iterator();
            while (it.hasNext()) {
                EventListenerList list = it.next();
                list.remove(DataChangeListener.class, (EventListener)listener);
                if (list.getListenerCount(DataChangeListener.class) != 0) continue;
                it.remove();
            }
        } else {
            Object[] objectArray = dataTypes;
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventListenerList list;
                Object dataType = objectArray[n2];
                if (dataType != null && (list = this.m_dataChangeListenerList.get(dataType)) != null) {
                    list.remove(DataChangeListener.class, (EventListener)listener);
                    if (list.getListenerCount(DataChangeListener.class) == 0) {
                        this.m_dataChangeListenerList.remove(dataType);
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean isDataChanging() {
        return this.m_dataChanging > 0;
    }

    @Override
    public void setDataChanging(boolean b) {
        if (b) {
            ++this.m_dataChanging;
        } else if (this.m_dataChanging > 0) {
            --this.m_dataChanging;
            if (this.m_dataChanging == 0) {
                this.processDataChangeBuffer();
            }
        }
    }

    @Override
    public void dataChanged(Object ... dataTypes) {
        if (this.isDataChanging()) {
            if (dataTypes != null && dataTypes.length > 0) {
                this.m_dataChangeEventBuffer.add(dataTypes);
            }
        } else {
            this.fireDataChangedImpl(dataTypes);
        }
    }

    private void processDataChangeBuffer() {
        HashSet<Object> knownEvents = new HashSet<Object>();
        Iterator<Object[]> iterator = this.m_dataChangeEventBuffer.iterator();
        while (iterator.hasNext()) {
            Object[] dataTypes;
            Object[] objectArray = dataTypes = iterator.next();
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object dataType = objectArray[n2];
                knownEvents.add(dataType);
                ++n2;
            }
        }
        this.m_dataChangeEventBuffer.clear();
        this.fireDataChangedImpl(knownEvents.toArray(new Object[knownEvents.size()]));
    }

    private void fireDataChangedImpl(Object ... dataTypes) {
        if (dataTypes != null && dataTypes.length > 0) {
            HashMap<DataChangeListener, HashSet<Object>> map = new HashMap<DataChangeListener, HashSet<Object>>();
            Object[] objectArray = dataTypes;
            int n = dataTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventListenerList list;
                Object dataType = objectArray[n2];
                if (dataType != null && (list = this.m_dataChangeListenerList.get(dataType)) != null) {
                    DataChangeListener[] dataChangeListenerArray = (DataChangeListener[])list.getListeners(DataChangeListener.class);
                    int n3 = dataChangeListenerArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        DataChangeListener listener = dataChangeListenerArray[n4];
                        HashSet<Object> typeSet = (HashSet<Object>)map.get(listener);
                        if (typeSet == null) {
                            typeSet = new HashSet<Object>();
                            map.put(listener, typeSet);
                        }
                        typeSet.add(dataType);
                        ++n4;
                    }
                }
                ++n2;
            }
            for (Map.Entry e : map.entrySet()) {
                DataChangeListener listener = (DataChangeListener)e.getKey();
                Set typeSet = (Set)e.getValue();
                try {
                    listener.dataChanged(typeSet.toArray());
                }
                catch (Throwable t) {
                    LOG.error(null, t);
                }
            }
        }
    }

    @Override
    public void traverseFocusNext() {
        this.fireTransferFocusNext();
    }

    @Override
    public void traverseFocusPrevious() {
        this.fireTransferFocusPrevious();
    }

    private void fireTransferFocusNext() {
        this.fireDesktopEvent(new DesktopEvent(this, 1020));
    }

    private void fireTransferFocusPrevious() {
        this.fireDesktopEvent(new DesktopEvent(this, 1030));
    }

    private void fireDesktopClosed() {
        DesktopEvent e = new DesktopEvent(this, 100);
        this.fireDesktopEvent(e);
    }

    private void firePrint(PrintDevice device, Map<String, Object> parameters) throws ProcessingException {
        this.fireDesktopEvent(new DesktopEvent((IDesktop)this, 900, device, parameters));
    }

    private List<IMenu> fireTrayPopup() {
        DesktopEvent e = new DesktopEvent(this, 1010);
        this.addLocalPopupMenus(e);
        this.fireDesktopEvent(e);
        return e.getPopupMenus();
    }

    private void fireDesktopPrinted(File printedFile) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 901, printedFile);
        this.fireDesktopEvent(e);
    }

    private void fireOutlineChanged(IOutline oldOutline, IOutline newOutline) {
        if (oldOutline != newOutline) {
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.outlineChangedDelegate(oldOutline, newOutline);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException(oldOutline + " -> " + newOutline, t));
                }
            }
        }
        DesktopEvent e = new DesktopEvent((IDesktop)this, 200, newOutline);
        this.fireDesktopEvent(e);
    }

    private void fireFormAdded(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 600, form);
        this.fireDesktopEvent(e);
    }

    private void fireFormEnsureVisible(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 620, form);
        this.fireDesktopEvent(e);
    }

    private void fireFormRemoved(IForm form) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 610, form);
        this.fireDesktopEvent(e);
    }

    private void fireMessageBoxAdded(IMessageBox mb) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 700, mb);
        this.fireDesktopEvent(e);
    }

    private void fireMessageBoxRemoved(IMessageBox mb) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 710, mb);
        this.fireDesktopEvent(e);
    }

    private void fireFileChooserAdded(IFileChooser fc) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 910, fc);
        this.fireDesktopEvent(e);
    }

    private void fireOpenUrlInBrowser(String path, IUrlTarget target) {
        DesktopEvent e = new DesktopEvent((IDesktop)this, 920, path, target);
        this.fireDesktopEvent(e);
    }

    private IFormField fireFindFocusOwner() {
        DesktopEvent e = new DesktopEvent(this, 1000);
        this.fireDesktopEvent(e);
        return e.getFocusedField();
    }

    private IForm fireFindActiveForm() {
        DesktopEvent e = new DesktopEvent(this, 1040);
        this.fireDesktopEvent(e);
        return e.getActiveForm();
    }

    private void fireDesktopEvent(DesktopEvent e) {
        EventListener[] listeners = this.m_listenerList.getListeners(DesktopListener.class);
        if (listeners != null && listeners.length > 0) {
            EventListener[] eventListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                EventListener element = eventListenerArray[n2];
                try {
                    ((DesktopListener)element).desktopChanged(e);
                }
                catch (Throwable t) {
                    LOG.error(null, t);
                }
                ++n2;
            }
        }
    }

    private void addLocalPopupMenus(DesktopEvent event) {
        try {
            ArrayList<IMenu> list = new ArrayList<IMenu>();
            for (IDesktopExtension ext : this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.addTrayMenusDelegate(list);
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (Throwable t) {
                    LOG.error("extension " + ext, t);
                }
            }
            for (IMenu m : list) {
                if (m == null) continue;
                m.prepareAction();
            }
            for (IMenu m : list) {
                if (m == null || !m.isVisible()) continue;
                event.addPopupMenu(m);
            }
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
    }

    @Override
    @Deprecated
    public void activateBookmark(Bookmark bm, boolean forceReload) throws ProcessingException {
        BookmarkUtility.activateBookmark(this, bm);
    }

    @Override
    public void activateBookmark(Bookmark bm) throws ProcessingException {
        BookmarkUtility.activateBookmark(this, bm);
    }

    @Override
    public Bookmark createBookmark() throws ProcessingException {
        return BookmarkUtility.createBookmark(this);
    }

    @Override
    public Bookmark createBookmark(IPage page) throws ProcessingException {
        return BookmarkUtility.createBookmark(page);
    }

    @Override
    public void refreshPages(Class<?> ... pageTypes) {
        for (IOutline outline : this.getAvailableOutlines()) {
            outline.refreshPages(pageTypes);
        }
    }

    @Override
    public void refreshPages(List<Class<? extends IPage>> pages) {
        for (IOutline outline : this.getAvailableOutlines()) {
            outline.refreshPages(pages);
        }
    }

    @Override
    public void releaseUnusedPages() {
        for (IOutline outline : this.getAvailableOutlines()) {
            outline.releaseUnusedPages();
        }
    }

    @Override
    public void afterTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        for (IDesktopExtension ext : this.getDesktopExtensions()) {
            try {
                ContributionCommand cc = ext.tablePageLoadedDelegate(tablePage);
                if (cc != ContributionCommand.Stop) continue;
                break;
            }
            catch (Throwable t) {
                LOG.error("extension " + ext, t);
            }
        }
    }

    @Override
    public void closeInternal() throws ProcessingException {
        this.setOpenedInternal(false);
        this.detachGui();
        ArrayList<Object> openForms = new ArrayList<Object>();
        for (IForm iForm : this.getViewStack()) {
            this.removeForm(iForm);
            openForms.add(iForm);
        }
        for (IForm iForm : this.getDialogStack()) {
            this.removeForm(iForm);
            openForms.add(iForm);
        }
        for (IDesktopExtension iDesktopExtension : this.getDesktopExtensions()) {
            try {
                ContributionCommand cc = iDesktopExtension.desktopClosingDelegate();
                if (cc != ContributionCommand.Stop) continue;
                break;
            }
            catch (Throwable t) {
                LOG.error("extension " + iDesktopExtension, t);
            }
        }
        for (IToolButton iToolButton : this.getToolButtons()) {
            AbstractFormToolButton formToolButton;
            Object form;
            if (!(iToolButton instanceof AbstractFormToolButton) || (form = (formToolButton = (AbstractFormToolButton)iToolButton).getForm()) == null) continue;
            openForms.add(form);
            formToolButton.setForm(null);
        }
        for (IForm iForm : openForms) {
            if (iForm == null) continue;
            try {
                iForm.doClose();
            }
            catch (ProcessingException e) {
                LOG.error("Exception while closing form", (Throwable)e);
            }
        }
        for (IOutline iOutline : this.getAvailableOutlines()) {
            iOutline.removeAllChildNodes(iOutline.getRootNode());
            iOutline.disposeTree();
        }
        this.fireDesktopClosed();
    }

    private void attachGui() {
        if (this.isGuiAvailable()) {
            return;
        }
        this.setGuiAvailableInternal(true);
        for (IDesktopExtension ext : this.getDesktopExtensions()) {
            try {
                ContributionCommand cc = ext.guiAttachedDelegate();
                if (cc != ContributionCommand.Stop) continue;
                break;
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected by " + ext, t));
            }
        }
    }

    private void detachGui() {
        if (!this.isGuiAvailable()) {
            return;
        }
        this.setGuiAvailableInternal(false);
        for (IDesktopExtension ext : this.getDesktopExtensions()) {
            try {
                ContributionCommand cc = ext.guiDetachedDelegate();
                if (cc != ContributionCommand.Stop) continue;
                break;
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected by " + ext, t));
            }
        }
    }

    public boolean runMenu(Class<? extends IMenu> menuType) throws ProcessingException {
        for (IMenu m : this.getMenus()) {
            if (!this.runMenuRec(m, menuType)) continue;
            return true;
        }
        return false;
    }

    private boolean runMenuRec(IMenu m, Class<? extends IMenu> menuType) throws ProcessingException {
        if (m.getClass() == menuType) {
            m.prepareAction();
            if (m.isVisible() && m.isEnabled()) {
                m.doAction();
                return true;
            }
            return false;
        }
        for (IMenu c : m.getChildActions()) {
            if (!this.runMenuRec(c, menuType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDesktopUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private boolean isForcedClosing() {
        return this.m_isForcedClosing;
    }

    private void setForcedClosing(boolean forcedClosing) {
        this.m_isForcedClosing = forcedClosing;
    }

    @Override
    public void changeVisibilityAfterOfflineSwitch() {
    }

    @Override
    public boolean doBeforeClosingInternal() {
        return this.isForcedClosing() || this.continueClosingInDesktopExtensions() && this.continueClosingConsideringUnsavedForms();
    }

    protected boolean continueClosingConsideringUnsavedForms() {
        List<IForm> forms = this.getUnsavedForms();
        if (forms.size() > 0) {
            try {
                UnsavedFormChangesForm f = new UnsavedFormChangesForm(forms);
                f.startNew();
                f.waitFor();
                if (f.getCloseSystemType() == 1) {
                    return false;
                }
            }
            catch (ProcessingException e) {
                LOG.error("Error closing forms", (Throwable)e);
            }
        }
        return true;
    }

    private boolean continueClosingInDesktopExtensions() {
        boolean continueClosing = true;
        List<IDesktopExtension> extensions = this.getDesktopExtensions();
        if (extensions != null) {
            for (IDesktopExtension ext : extensions) {
                try {
                    ContributionCommand cc = ext.desktopBeforeClosingDelegate();
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (VetoException e) {
                    continueClosing = false;
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Desktop before closing error", t));
                }
            }
        }
        return continueClosing;
    }

    @Override
    public List<IForm> getUnsavedForms() {
        ArrayList<IForm> saveNeededForms = new ArrayList<IForm>();
        List openForms = CollectionUtility.combine((Collection[])new Collection[]{this.getViewStack(), this.getDialogStack()});
        int i = openForms.size() - 1;
        while (i >= 0) {
            IForm f = (IForm)openForms.get(i);
            if (f.isAskIfNeedSave() && f.isSaveNeeded()) {
                saveNeededForms.add(f);
            }
            --i;
        }
        return saveNeededForms;
    }

    protected final void interceptOpened() throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopOpenedChain chain = new DesktopChains.DesktopOpenedChain(extensions);
        chain.execOpened();
    }

    protected final void interceptAddTrayMenus(List<IMenu> menus) throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopAddTrayMenusChain chain = new DesktopChains.DesktopAddTrayMenusChain(extensions);
        chain.execAddTrayMenus(menus);
    }

    protected final void interceptBeforeClosing() throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopBeforeClosingChain chain = new DesktopChains.DesktopBeforeClosingChain(extensions);
        chain.execBeforeClosing();
    }

    protected final void interceptPageDetailFormChanged(IForm oldForm, IForm newForm) throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopPageDetailFormChangedChain chain = new DesktopChains.DesktopPageDetailFormChangedChain(extensions);
        chain.execPageDetailFormChanged(oldForm, newForm);
    }

    protected final void interceptTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopTablePageLoadedChain chain = new DesktopChains.DesktopTablePageLoadedChain(extensions);
        chain.execTablePageLoaded(tablePage);
    }

    protected final void interceptOutlineChanged(IOutline oldOutline, IOutline newOutline) throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopOutlineChangedChain chain = new DesktopChains.DesktopOutlineChangedChain(extensions);
        chain.execOutlineChanged(oldOutline, newOutline);
    }

    protected final void interceptClosing() throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopClosingChain chain = new DesktopChains.DesktopClosingChain(extensions);
        chain.execClosing();
    }

    protected final void interceptPageSearchFormChanged(IForm oldForm, IForm newForm) throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopPageSearchFormChangedChain chain = new DesktopChains.DesktopPageSearchFormChangedChain(extensions);
        chain.execPageSearchFormChanged(oldForm, newForm);
    }

    protected final void interceptPageDetailTableChanged(ITable oldTable, ITable newTable) throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopPageDetailTableChangedChain chain = new DesktopChains.DesktopPageDetailTableChangedChain(extensions);
        chain.execPageDetailTableChanged(oldTable, newTable);
    }

    protected final void interceptGuiAttached() throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopGuiAttachedChain chain = new DesktopChains.DesktopGuiAttachedChain(extensions);
        chain.execGuiAttached();
    }

    protected final void interceptGuiDetached() throws ProcessingException {
        List<? extends org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<? extends AbstractDesktop>> extensions = this.getAllExtensions();
        DesktopChains.DesktopGuiDetachedChain chain = new DesktopChains.DesktopGuiDetachedChain(extensions);
        chain.execGuiDetached();
    }

    protected static class LocalDesktopExtension<DESKTOP extends AbstractDesktop>
    extends AbstractExtension<DESKTOP>
    implements org.eclipse.scout.rt.client.extension.ui.desktop.IDesktopExtension<DESKTOP> {
        public LocalDesktopExtension(DESKTOP desktop) {
            super(desktop);
        }

        @Override
        public void execInit(DesktopChains.DesktopInitChain chain) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execInit();
        }

        @Override
        public void execOpened(DesktopChains.DesktopOpenedChain chain) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execOpened();
        }

        @Override
        public void execAddTrayMenus(DesktopChains.DesktopAddTrayMenusChain chain, List<IMenu> menus) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execAddTrayMenus(menus);
        }

        @Override
        public void execBeforeClosing(DesktopChains.DesktopBeforeClosingChain chain) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execBeforeClosing();
        }

        @Override
        public void execPageDetailFormChanged(DesktopChains.DesktopPageDetailFormChangedChain chain, IForm oldForm, IForm newForm) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execPageDetailFormChanged(oldForm, newForm);
        }

        @Override
        public void execTablePageLoaded(DesktopChains.DesktopTablePageLoadedChain chain, IPageWithTable<?> tablePage) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execTablePageLoaded(tablePage);
        }

        @Override
        public void execOutlineChanged(DesktopChains.DesktopOutlineChangedChain chain, IOutline oldOutline, IOutline newOutline) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execOutlineChanged(oldOutline, newOutline);
        }

        @Override
        public void execClosing(DesktopChains.DesktopClosingChain chain) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execClosing();
        }

        @Override
        public void execPageSearchFormChanged(DesktopChains.DesktopPageSearchFormChangedChain chain, IForm oldForm, IForm newForm) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execPageSearchFormChanged(oldForm, newForm);
        }

        @Override
        public void execPageDetailTableChanged(DesktopChains.DesktopPageDetailTableChangedChain chain, ITable oldTable, ITable newTable) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execPageDetailTableChanged(oldTable, newTable);
        }

        @Override
        public void execGuiAttached(DesktopChains.DesktopGuiAttachedChain chain) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execGuiAttached();
        }

        @Override
        public void execGuiDetached(DesktopChains.DesktopGuiDetachedChain chain) throws ProcessingException {
            ((AbstractDesktop)this.getOwner()).execGuiDetached();
        }
    }

    private class P_ActivatedFormListener
    implements FormListener {
        private P_ActivatedFormListener() {
        }

        @Override
        public void formChanged(FormEvent e) throws ProcessingException {
            if (e.getType() != 510) {
                return;
            }
            Iterator it = AbstractDesktop.this.m_lastActiveFormList.iterator();
            while (it.hasNext()) {
                WeakReference formRef = (WeakReference)it.next();
                if (formRef.get() != null && !((IForm)formRef.get()).equals(e.getForm())) continue;
                it.remove();
            }
            AbstractDesktop.this.m_lastActiveFormList.add(0, new WeakReference<IForm>(e.getForm()));
        }
    }

    private class P_ActiveOutlineListener
    extends TreeAdapter
    implements PropertyChangeListener {
        private P_ActiveOutlineListener() {
        }

        @Override
        public void treeChanged(TreeEvent e) {
            switch (e.getType()) {
                case 35: {
                    if (!(e.getDeselectedNode() instanceof IPage)) break;
                    IPage deselectedPage = (IPage)e.getDeselectedNode();
                    ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, deselectedPage);
                    break;
                }
                case 40: {
                    IPage page = AbstractDesktop.this.m_outline.getActivePage();
                    if (page != null) {
                        ((INavigationHistoryService)SERVICES.getService(INavigationHistoryService.class)).addStep(0, page);
                    }
                    try {
                        ClientSyncJob.getCurrentSession().getMemoryPolicy().afterOutlineSelectionChanged(AbstractDesktop.this);
                        break;
                    }
                    catch (Throwable t) {
                        LOG.warn("MemoryPolicy.afterOutlineSelectionChanged", t);
                    }
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("detailForm")) {
                AbstractDesktop.this.setPageDetailForm(((IOutline)e.getSource()).getDetailForm());
            } else if (e.getPropertyName().equals("detailTable")) {
                AbstractDesktop.this.setPageDetailTable(((IOutline)e.getSource()).getDetailTable());
            } else if (e.getPropertyName().equals("searchForm")) {
                AbstractDesktop.this.setPageSearchForm(((IOutline)e.getSource()).getSearchForm());
            }
        }
    }

    private class P_LocalDesktopExtension
    implements IDesktopExtension {
        private P_LocalDesktopExtension() {
        }

        @Override
        public IDesktop getCoreDesktop() {
            return AbstractDesktop.this;
        }

        @Override
        public void setCoreDesktop(IDesktop desktop) {
        }

        @Override
        public void contributeOutlines(OrderedCollection<IOutline> outlines) {
            List<Class<? extends IOutline>> configuredOutlines = AbstractDesktop.this.getConfiguredOutlines();
            if (configuredOutlines != null) {
                for (Class<? extends IOutline> element : configuredOutlines) {
                    try {
                        IOutline o = element.newInstance();
                        outlines.addOrdered((IOrdered)o);
                    }
                    catch (Throwable t) {
                        ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + element.getName() + "'.", t));
                    }
                }
            }
        }

        @Override
        public void contributeActions(Collection<IAction> actions) {
            for (Class actionClazz : AbstractDesktop.this.getConfiguredActions()) {
                try {
                    actions.add((IAction)ConfigurationUtility.newInnerInstance((Object)AbstractDesktop.this, (Class)actionClazz));
                }
                catch (Exception e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + actionClazz.getName() + "'.", (Throwable)e));
                }
            }
        }

        @Override
        public ContributionCommand initDelegate() throws ProcessingException {
            AbstractDesktop.this.interceptInit();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand desktopOpenedDelegate() throws ProcessingException {
            AbstractDesktop.this.interceptOpened();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand desktopBeforeClosingDelegate() throws ProcessingException {
            AbstractDesktop.this.interceptBeforeClosing();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand desktopClosingDelegate() throws ProcessingException {
            AbstractDesktop.this.interceptClosing();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand guiAttachedDelegate() throws ProcessingException {
            AbstractDesktop.this.interceptGuiAttached();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand guiDetachedDelegate() throws ProcessingException {
            AbstractDesktop.this.interceptGuiDetached();
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand outlineChangedDelegate(IOutline oldOutline, IOutline newOutline) throws ProcessingException {
            AbstractDesktop.this.interceptOutlineChanged(oldOutline, newOutline);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand customFormModificationDelegate(IHolder<IForm> formHolder) throws ProcessingException {
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageSearchFormChangedDelegate(IForm oldForm, IForm newForm) throws ProcessingException {
            AbstractDesktop.this.interceptPageSearchFormChanged(oldForm, newForm);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageDetailFormChangedDelegate(IForm oldForm, IForm newForm) throws ProcessingException {
            AbstractDesktop.this.interceptPageDetailFormChanged(oldForm, newForm);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand pageDetailTableChangedDelegate(ITable oldTable, ITable newTable) throws ProcessingException {
            AbstractDesktop.this.interceptPageDetailTableChanged(oldTable, newTable);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand tablePageLoadedDelegate(IPageWithTable<?> tablePage) throws ProcessingException {
            AbstractDesktop.this.interceptTablePageLoaded(tablePage);
            return ContributionCommand.Continue;
        }

        @Override
        public ContributionCommand addTrayMenusDelegate(List<IMenu> menus) throws ProcessingException {
            AbstractDesktop.this.interceptAddTrayMenus(menus);
            return ContributionCommand.Continue;
        }
    }

    private class P_UIFacade
    implements IDesktopUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void fireGuiAttached() {
            AbstractDesktop.this.attachGui();
        }

        @Override
        public void fireGuiDetached() {
            AbstractDesktop.this.detachGui();
        }

        @Override
        public void fireDesktopOpenedFromUI() {
            AbstractDesktop.this.setOpenedInternal(true);
            for (IDesktopExtension ext : AbstractDesktop.this.getDesktopExtensions()) {
                try {
                    ContributionCommand cc = ext.desktopOpenedDelegate();
                    if (cc != ContributionCommand.Stop) continue;
                    break;
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected by " + ext, t));
                }
            }
        }

        @Override
        public void fireDesktopClosingFromUI(boolean forcedClosing) {
            AbstractDesktop.this.setForcedClosing(forcedClosing);
            if (forcedClosing) {
                AbstractDesktop.this.setOpenedInternal(false);
            }
            ClientSyncJob.getCurrentSession().stopSession();
        }

        @Override
        public List<IMenu> fireTrayPopupFromUI() {
            return AbstractDesktop.this.fireTrayPopup();
        }

        @Override
        public void fireDesktopPrintedFromUI(File printedFile) {
            AbstractDesktop.this.fireDesktopPrinted(printedFile);
        }
    }
}

