/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields;

import org.eclipse.scout.commons.exception.IProcessingStatus;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IValidateContentDescriptor;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tabbox.ITabBox;

public class ValidateFormFieldDescriptor
implements IValidateContentDescriptor {
    private final IFormField m_field;
    private final IProcessingStatus m_errorStatus;

    public ValidateFormFieldDescriptor(IFormField field) {
        this.m_field = field;
        this.m_errorStatus = field.getErrorStatus();
    }

    @Override
    public String getDisplayText() {
        return this.m_field.getFullyQualifiedLabel(": ");
    }

    @Override
    public IProcessingStatus getErrorStatus() {
        return this.m_errorStatus;
    }

    @Override
    public void activateProblemLocation() {
        IGroupBox g = this.m_field.getParentGroupBox();
        while (g != null) {
            ITabBox t;
            if (g.getParentField() instanceof ITabBox && (t = (ITabBox)g.getParentField()).getSelectedTab() != g) {
                t.setSelectedTab(g);
            }
            g = g.getParentGroupBox();
        }
        this.m_field.requestFocus();
    }
}

