/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.TriState;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.FormData;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.IFormFieldExtension;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.ComposerValueBoxChains;
import org.eclipse.scout.rt.client.extension.ui.form.fields.composer.IComposerValueBoxExtension;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerValueBox;
import org.eclipse.scout.rt.client.ui.form.fields.composer.IComposerValueField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractTimeField;
import org.eclipse.scout.rt.client.ui.form.fields.doublefield.AbstractDoubleField;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.integerfield.AbstractIntegerField;
import org.eclipse.scout.rt.client.ui.form.fields.listbox.AbstractListBox;
import org.eclipse.scout.rt.client.ui.form.fields.longfield.AbstractLongField;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.AbstractSequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.sequencebox.ISequenceBox;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.client.ui.form.fields.treebox.AbstractTreeBox;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttribute;
import org.eclipse.scout.rt.shared.data.model.IDataModelAttributeOp;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;

@ClassId(value="2d8065cf-eeb3-4d64-8753-adb36cf852b8")
public abstract class AbstractComposerValueBox
extends AbstractGroupBox
implements IComposerValueBox {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractComposerValueBox.class);
    private Map<Integer, Map<Integer, IComposerValueField>> m_opTypeToFieldMap;
    private IDataModelAttribute m_attribute;
    private IComposerValueField m_selectedField;
    private PropertyChangeListener m_valueChangedListener;

    public AbstractComposerValueBox() {
        this(true);
    }

    public AbstractComposerValueBox(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredBorderVisible() {
        return false;
    }

    @Override
    protected int getConfiguredGridColumnCount() {
        return 1;
    }

    @Override
    protected int getConfiguredGridW() {
        return 1;
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execChangedValue() throws ProcessingException {
    }

    @Override
    protected void execAddSearchTerms(SearchFilter search) {
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_opTypeToFieldMap = new HashMap<Integer, Map<Integer, IComposerValueField>>();
        HashMap<Integer, IComposerValueField> betweenMap = new HashMap<Integer, IComposerValueField>();
        betweenMap.put(5, this.getFieldByClass(BetweenDateField.class));
        betweenMap.put(7, this.getFieldByClass(BetweenDateTimeField.class));
        betweenMap.put(10, this.getFieldByClass(BetweenDoubleField.class));
        betweenMap.put(17, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(8, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(9, this.getFieldByClass(BetweenLongField.class));
        betweenMap.put(14, this.getFieldByClass(BetweenDoubleField.class));
        betweenMap.put(13, this.getFieldByClass(BetweenDoubleField.class));
        betweenMap.put(11, this.getFieldByClass(BetweenIntegerField.class));
        betweenMap.put(12, this.getFieldByClass(BetweenLongField.class));
        betweenMap.put(6, this.getFieldByClass(BetweenTimeField.class));
        this.m_opTypeToFieldMap.put(45, betweenMap);
        this.m_opTypeToFieldMap.put(47, betweenMap);
        this.m_opTypeToFieldMap.put(48, betweenMap);
        HashMap<Integer, IComposerValueField> defaultMap = new HashMap<Integer, IComposerValueField>();
        defaultMap.put(5, this.getFieldByClass(DateField.class));
        defaultMap.put(7, this.getFieldByClass(DateTimeField.class));
        defaultMap.put(10, this.getFieldByClass(DoubleField.class));
        defaultMap.put(17, this.getFieldByClass(IntegerField.class));
        defaultMap.put(8, this.getFieldByClass(IntegerField.class));
        defaultMap.put(3, this.getFieldByClass(ListBoxField.class));
        defaultMap.put(4, this.getFieldByClass(TreeBoxField.class));
        defaultMap.put(1, this.getFieldByClass(ListBoxField.class));
        defaultMap.put(2, this.getFieldByClass(TreeBoxField.class));
        defaultMap.put(9, this.getFieldByClass(LongField.class));
        defaultMap.put(14, this.getFieldByClass(DoubleField.class));
        defaultMap.put(13, this.getFieldByClass(DoubleField.class));
        defaultMap.put(11, this.getFieldByClass(IntegerField.class));
        defaultMap.put(12, this.getFieldByClass(LongField.class));
        defaultMap.put(15, this.getFieldByClass(StringField.class));
        defaultMap.put(18, this.getFieldByClass(StringField.class));
        defaultMap.put(16, this.getFieldByClass(SmartField.class));
        defaultMap.put(6, this.getFieldByClass(TimeField.class));
        this.m_opTypeToFieldMap.put(0, defaultMap);
        this.m_valueChangedListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("value".equals(e.getPropertyName())) {
                    try {
                        AbstractComposerValueBox.this.interceptChangedValue();
                    }
                    catch (Throwable t) {
                        LOG.error("fire value change on " + e.getSource(), t);
                    }
                }
            }
        };
        for (IFormField f : this.getFields()) {
            List<IFormField> sequenceBoxChildFields;
            f.setLabelVisible(false);
            f.setLabel(ScoutTexts.get((String)"Value", (String[])new String[0]));
            f.setVisible(false);
            if (!(f instanceof ISequenceBox) || !CollectionUtility.hasElements(sequenceBoxChildFields = ((ISequenceBox)f).getFields())) continue;
            IFormField firstField = (IFormField)CollectionUtility.firstElement(sequenceBoxChildFields);
            firstField.setLabelVisible(false);
            if (sequenceBoxChildFields.size() <= 1) continue;
            IFormField secondField = (IFormField)CollectionUtility.getElement(sequenceBoxChildFields, (int)1);
            secondField.setLabel(ScoutTexts.get((String)"and", (String[])new String[0]));
        }
    }

    public IComposerValueField getSelectedField() {
        return this.m_selectedField;
    }

    public void setSelectionContext(IDataModelAttribute attribute, IDataModelAttributeOp op, List<?> values) {
        Map<Integer, IComposerValueField> typeToFieldMap;
        if (op == null) {
            return;
        }
        if (values == null && this.getSelectedField() != null) {
            values = this.getSelectedField().getValues();
        }
        this.m_attribute = attribute;
        int dataType = op.getType();
        if (dataType == -1) {
            dataType = attribute.getType();
        }
        if ((typeToFieldMap = this.m_opTypeToFieldMap.get(op.getOperator())) == null) {
            typeToFieldMap = this.m_opTypeToFieldMap.get(0);
        }
        IComposerValueField valueField = typeToFieldMap.get(dataType);
        if (this.m_selectedField != null) {
            this.m_selectedField.removeValueChangeListenerFromTarget(this.m_valueChangedListener);
            this.m_selectedField.clearSelectionContext();
        }
        this.m_selectedField = valueField;
        if (this.m_selectedField != null) {
            this.m_selectedField.addValueChangeListenerToTarget(this.m_valueChangedListener);
            this.m_selectedField.setSelectionContext(this.m_attribute, dataType, op, values);
        }
        for (IFormField f : this.getFields()) {
            if (f == this.m_selectedField) {
                f.setVisible(true);
                continue;
            }
            f.setVisible(false);
        }
    }

    public void clearSelectionContext() {
        if (this.m_selectedField != null) {
            this.m_selectedField.clearSelectionContext();
        }
        this.m_selectedField = null;
        for (IFormField f : this.getFields()) {
            f.setVisible(false);
        }
    }

    protected final void interceptChangedValue() throws ProcessingException {
        List<? extends IFormFieldExtension<? extends AbstractFormField>> extensions = this.getAllExtensions();
        ComposerValueBoxChains.ComposerValueBoxChangedValueChain chain = new ComposerValueBoxChains.ComposerValueBoxChangedValueChain(extensions);
        chain.execChangedValue();
    }

    @Override
    protected IComposerValueBoxExtension<? extends AbstractComposerValueBox> createLocalExtension() {
        return new LocalComposerValueBoxExtension<AbstractComposerValueBox>(this);
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenDateField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List<?> values) {
            try {
                this.getFieldByClass(DateFromField.class).setValue(null);
                this.getFieldByClass(DateToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Date) {
                        this.getFieldByClass(DateFromField.class).setValue((Date)values.get(0));
                    }
                    if (values.get(1) instanceof Date) {
                        this.getFieldByClass(DateToField.class).setValue((Date)values.get(1));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(DateFromField.class).setValue(null);
            this.getFieldByClass(DateToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(DateFromField.class).getValue();
            Object b = this.getFieldByClass(DateToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(DateFromField.class).getDisplayText();
            String b = this.getFieldByClass(DateToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        public class DateFromField
        extends AbstractDateField {
        }

        @Order(value=20.0)
        public class DateToField
        extends AbstractDateField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenDateTimeField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(DateTimeFromField.class).setValue(null);
                this.getFieldByClass(DateTimeToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Date) {
                        this.getFieldByClass(DateTimeFromField.class).setValue((Date)values.get(0));
                    }
                    if (values.get(1) instanceof Date) {
                        this.getFieldByClass(DateTimeToField.class).setValue((Date)values.get(1));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(DateTimeFromField.class).setValue(null);
            this.getFieldByClass(DateTimeToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(DateTimeFromField.class).getValue();
            Object b = this.getFieldByClass(DateTimeToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(DateTimeFromField.class).getDisplayText();
            String b = this.getFieldByClass(DateTimeToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        public class DateTimeFromField
        extends AbstractDateField {
            @Override
            protected boolean getConfiguredHasTime() {
                return true;
            }
        }

        @Order(value=20.0)
        public class DateTimeToField
        extends AbstractDateField {
            @Override
            protected boolean getConfiguredHasTime() {
                return true;
            }
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenDoubleField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(DoubleFromField.class).setValue(null);
                this.getFieldByClass(DoubleToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Double) {
                        this.getFieldByClass(DoubleFromField.class).setValue((Double)values.get(0));
                    }
                    if (values.get(1) instanceof Double) {
                        this.getFieldByClass(DoubleToField.class).setValue((Double)values.get(1));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(DoubleFromField.class).setValue(null);
            this.getFieldByClass(DoubleToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(DoubleFromField.class).getValue();
            Object b = this.getFieldByClass(DoubleToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(DoubleFromField.class).getDisplayText();
            String b = this.getFieldByClass(DoubleToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        public class DoubleFromField
        extends AbstractDoubleField {
        }

        @Order(value=20.0)
        public class DoubleToField
        extends AbstractDoubleField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenIntegerField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(IntegerFromField.class).setValue(null);
                this.getFieldByClass(IntegerToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Integer) {
                        this.getFieldByClass(IntegerFromField.class).setValue((Integer)values.get(0));
                    }
                    if (values.get(1) instanceof Integer) {
                        this.getFieldByClass(IntegerToField.class).setValue((Integer)values.get(1));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(IntegerFromField.class).setValue(null);
            this.getFieldByClass(IntegerToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(IntegerFromField.class).getValue();
            Object b = this.getFieldByClass(IntegerToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(IntegerFromField.class).getDisplayText();
            String b = this.getFieldByClass(IntegerToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        public class IntegerFromField
        extends AbstractIntegerField {
        }

        @Order(value=20.0)
        public class IntegerToField
        extends AbstractIntegerField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenLongField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(LongFromField.class).setValue(null);
                this.getFieldByClass(LongToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Long) {
                        this.getFieldByClass(LongFromField.class).setValue((Long)values.get(0));
                    }
                    if (values.get(1) instanceof Long) {
                        this.getFieldByClass(LongToField.class).setValue((Long)values.get(1));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(LongFromField.class).setValue(null);
            this.getFieldByClass(LongToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(LongFromField.class).getValue();
            Object b = this.getFieldByClass(LongToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(LongFromField.class).getDisplayText();
            String b = this.getFieldByClass(LongToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        public class LongFromField
        extends AbstractLongField {
        }

        @Order(value=20.0)
        public class LongToField
        extends AbstractLongField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class BetweenTimeField
    extends AbstractSequenceBox
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.addPropertyChangeListener(listener);
            }
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            for (IFormField f : this.getFields()) {
                f.removePropertyChangeListener(listener);
            }
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                this.getFieldByClass(TimeFromField.class).setValue(null);
                this.getFieldByClass(TimeToField.class).setValue(null);
                if (values != null && values.size() == 2) {
                    if (values.get(0) instanceof Double) {
                        this.getFieldByClass(TimeFromField.class).setTimeValue((Double)values.get(0));
                    } else if (values.get(0) instanceof Date) {
                        this.getFieldByClass(TimeFromField.class).setValue((Date)values.get(0));
                    }
                    if (values.get(1) instanceof Double) {
                        this.getFieldByClass(TimeToField.class).setTimeValue((Double)values.get(1));
                    } else if (values.get(1) instanceof Date) {
                        this.getFieldByClass(TimeToField.class).setValue((Date)values.get(1));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void clearSelectionContext() {
            this.getFieldByClass(TimeFromField.class).setValue(null);
            this.getFieldByClass(TimeToField.class).setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object a = this.getFieldByClass(TimeFromField.class).getValue();
            Object b = this.getFieldByClass(TimeToField.class).getValue();
            if (a == null && b == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object[])new Object[]{a, b});
        }

        @Override
        public List<String> getTexts() {
            String a = this.getFieldByClass(TimeFromField.class).getDisplayText();
            String b = this.getFieldByClass(TimeToField.class).getDisplayText();
            return CollectionUtility.arrayList((Object[])new String[]{a, b});
        }

        @Order(value=10.0)
        public class TimeFromField
        extends AbstractTimeField {
        }

        @Order(value=20.0)
        public class TimeToField
        extends AbstractTimeField {
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class DateField
    extends AbstractDateField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Date) {
                    this.setValue((Date)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() != null) {
                return Collections.singletonList(this.getValue());
            }
            return null;
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class DateTimeField
    extends AbstractDateField
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredHasTime() {
            return true;
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Date) {
                    this.setValue((Date)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class DoubleField
    extends AbstractDoubleField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            switch (dataType) {
                case 10: {
                    this.setGroupingUsed(true);
                    this.setPercent(false);
                    break;
                }
                case 14: {
                    this.setGroupingUsed(true);
                    this.setPercent(true);
                    break;
                }
                case 13: {
                    this.setGroupingUsed(false);
                    this.setPercent(false);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Double) {
                    this.setValue((Double)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class IntegerField
    extends AbstractIntegerField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            switch (dataType) {
                case 8: {
                    this.setGroupingUsed(true);
                    break;
                }
                case 11: {
                    this.setGroupingUsed(false);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Integer) {
                    this.setValue((Integer)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class ListBoxField
    extends AbstractListBox<Object>
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredAutoLoad() {
            return false;
        }

        @Override
        protected int getConfiguredGridH() {
            return 4;
        }

        @Override
        protected void execPrepareLookup(ILookupCall<Object> call) throws ProcessingException {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isFilterActiveRows() ? null : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List<?> values) {
            this.setFilterActiveRowsValue(TriState.TRUE);
            this.setFilterActiveRows(attribute.isActiveFilterEnabled());
            ILookupCall newCall = attribute.getLookupCall();
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(newCall);
                try {
                    this.loadListBoxData();
                }
                catch (Exception e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement(values);
                if (firstElement instanceof Collection) {
                    this.setValue(CollectionUtility.hashSet((Collection)((Collection)firstElement)));
                } else if (firstElement instanceof Object[]) {
                    this.setValue(CollectionUtility.hashSet((Object[])((Object[])firstElement)));
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getCheckedKeyCount() > 0) {
                return CollectionUtility.arrayList((Object)this.getValue());
            }
            return null;
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    protected static class LocalComposerValueBoxExtension<OWNER extends AbstractComposerValueBox>
    extends AbstractGroupBox.LocalGroupBoxExtension<OWNER>
    implements IComposerValueBoxExtension<OWNER> {
        public LocalComposerValueBoxExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execChangedValue(ComposerValueBoxChains.ComposerValueBoxChangedValueChain chain) throws ProcessingException {
            ((AbstractComposerValueBox)this.getOwner()).execChangedValue();
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class LongField
    extends AbstractLongField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            switch (dataType) {
                case 9: {
                    this.setGroupingUsed(true);
                    break;
                }
                case 12: {
                    this.setGroupingUsed(false);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof Long) {
                    this.setValue((Long)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class SmartField
    extends AbstractSmartField<Object>
    implements IComposerValueField {
        @Override
        protected String getConfiguredBrowseIconId() {
            return "empty";
        }

        @Override
        protected void execPrepareLookup(ILookupCall<Object> call) throws ProcessingException {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isActiveFilterEnabled() ? this.getActiveFilter() : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            this.setActiveFilterEnabled(attribute.isActiveFilterEnabled());
            ILookupCall newCall = attribute.getLookupCall();
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(newCall);
            }
            try {
                this.setValue(CollectionUtility.firstElement((List)values));
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class StringField
    extends AbstractStringField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                Object firstElement = CollectionUtility.firstElement((List)values);
                if (firstElement instanceof String) {
                    this.setValue((String)firstElement);
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class TimeField
    extends AbstractTimeField
    implements IComposerValueField {
        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List values) {
            try {
                if (values != null && values.size() == 1) {
                    Object firstElement = CollectionUtility.firstElement((List)values);
                    if (firstElement instanceof Double) {
                        this.setTimeValue((Double)firstElement);
                    } else if (firstElement instanceof Date) {
                        this.setValue((Date)firstElement);
                    } else {
                        this.setValue(null);
                    }
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            if (this.getValue() == null) {
                return null;
            }
            return Collections.singletonList(this.getValue());
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }

    @Order(value=10.0)
    @FormData(defaultSubtypeSdkCommand=FormData.DefaultSubtypeSdkCommand.IGNORE)
    public class TreeBoxField
    extends AbstractTreeBox<Object>
    implements IComposerValueField {
        @Override
        protected boolean getConfiguredAutoLoad() {
            return false;
        }

        @Override
        protected int getConfiguredGridH() {
            return 4;
        }

        @Override
        protected void execPrepareLookup(ILookupCall<Object> call, ITreeNode parent) throws ProcessingException {
            if (AbstractComposerValueBox.this.m_attribute != null) {
                call.setActive(this.isFilterActiveNodes() ? null : TriState.TRUE);
                AbstractComposerValueBox.this.m_attribute.prepareLookup(call);
            }
        }

        @Override
        public void addValueChangeListenerToTarget(PropertyChangeListener listener) {
            this.addPropertyChangeListener(listener);
        }

        @Override
        public void removeValueChangeListenerFromTarget(PropertyChangeListener listener) {
            this.removePropertyChangeListener(listener);
        }

        @Override
        public void setSelectionContext(IDataModelAttribute attribute, int dataType, IDataModelAttributeOp op, List<?> values0) {
            this.setFilterActiveNodesValue(TriState.TRUE);
            this.setFilterActiveNodes(attribute.isActiveFilterEnabled());
            ILookupCall newCall = attribute.getLookupCall();
            if (this.getLookupCall() != newCall) {
                this.setLookupCall(newCall);
                try {
                    this.loadRootNode();
                    this.getTree().setNodeExpanded(this.getTree().getRootNode(), true);
                }
                catch (Exception e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
            try {
                Object firstElement = CollectionUtility.firstElement(values0);
                if (firstElement instanceof Collection) {
                    this.setValue(CollectionUtility.hashSet((Collection)((Collection)firstElement)));
                } else if (firstElement instanceof Object[]) {
                    this.setValue(CollectionUtility.hashSet((Object[])((Object[])firstElement)));
                } else {
                    this.setValue(null);
                }
            }
            catch (Exception e) {
                this.setValue(null);
            }
        }

        @Override
        public void clearSelectionContext() {
            this.setValue(null);
        }

        @Override
        public List<Object> getValues() {
            Object value = this.getValue();
            if (value == null) {
                return null;
            }
            return CollectionUtility.arrayList((Object)value);
        }

        @Override
        public List<String> getTexts() {
            return CollectionUtility.arrayList((Object)this.getDisplayText());
        }
    }
}

