/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.lookup.BatchLookupResultCache;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;

public class BatchLookupNormalizer {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BatchLookupNormalizer.class);
    private int m_originalLength;
    private int[] m_forwardMapping;
    private List<ILookupCall<?>> m_normalizedCalls;

    public List<ILookupCall<?>> normalizeCalls(List<ILookupCall<?>> calls) throws ProcessingException {
        this.m_originalLength = 0;
        this.m_forwardMapping = null;
        this.m_normalizedCalls = null;
        if (calls == null || calls.size() == 0) {
            return CollectionUtility.emptyArrayList();
        }
        this.m_originalLength = calls.size();
        this.m_forwardMapping = new int[this.m_originalLength];
        HashMap normMap = new HashMap();
        ArrayList normList = new ArrayList(this.m_originalLength / 2);
        int normIndex = 0;
        int i = 0;
        while (i < this.m_originalLength) {
            ILookupCall<?> call = calls.get(i);
            if (call == null) {
                this.m_forwardMapping[i] = -1;
            } else if (!BatchLookupResultCache.isCacheable(call.getClass())) {
                this.m_forwardMapping[i] = normIndex++;
                normList.add(call);
            } else {
                Integer existingIndex = (Integer)normMap.get(call);
                if (existingIndex != null) {
                    this.m_forwardMapping[i] = existingIndex;
                } else {
                    this.m_forwardMapping[i] = normIndex;
                    normList.add(call);
                    normMap.put(call, normIndex);
                    ++normIndex;
                }
            }
            ++i;
        }
        normMap = null;
        this.m_normalizedCalls = normList;
        return CollectionUtility.arrayList(this.m_normalizedCalls);
    }

    public List<List<ILookupRow<?>>> denormalizeResults(List<List<ILookupRow<?>>> normalizedResults) throws ProcessingException {
        if (this.m_originalLength == 0 || normalizedResults == null) {
            return CollectionUtility.emptyArrayList();
        }
        if (normalizedResults.size() != this.m_normalizedCalls.size()) {
            throw new IllegalArgumentException("normalized result array must have length " + this.m_normalizedCalls.size() + " (" + normalizedResults.size() + ")");
        }
        ArrayList result = new ArrayList(this.m_originalLength);
        int i = 0;
        while (i < this.m_originalLength) {
            int mapIndex = this.m_forwardMapping[i];
            if (mapIndex >= 0) {
                result.add(normalizedResults.get(mapIndex));
            } else {
                result.add(null);
            }
            ++i;
        }
        return result;
    }
}

