/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap;

import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.util.Hashtable;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.MultiClientSessionCookieStore;
import org.eclipse.scout.rt.ui.rap.login.internal.InternalNetAuthenticator;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scout.rt.ui.rap";
    private static final String CLIENT_LOG_LEVEL = "org.eclipse.rwt.clientLogLevel";
    private static final String ALL_CLIENT_LOG_LEVEL = "ALL";
    public static final String MULTI_CLIENT_SESSION_COOKIESTORE = "org.eclipse.scout.rt.multiClientSessionCookieStoreEnabled";
    private static Activator m_plugin;
    private ServiceRegistration m_netAuthRegistration;

    public Activator() {
        System.setProperty(CLIENT_LOG_LEVEL, ALL_CLIENT_LOG_LEVEL);
    }

    public static Activator getDefault() {
        return m_plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        m_plugin = this;
        Hashtable<String, Integer> map = new Hashtable<String, Integer>();
        map.put("service.ranking", -1);
        this.m_netAuthRegistration = context.registerService(Authenticator.class.getName(), (Object)new InternalNetAuthenticator(), map);
        this.installCookieStore(context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.m_netAuthRegistration != null) {
            this.m_netAuthRegistration.unregister();
            this.m_netAuthRegistration = null;
        }
        m_plugin = null;
        super.stop(context);
    }

    private void installCookieStore(BundleContext context) {
        boolean isMultiClientSessionCookieStoreEnabled = StringUtility.parseBoolean((String)context.getProperty(MULTI_CLIENT_SESSION_COOKIESTORE), (boolean)true);
        if (isMultiClientSessionCookieStoreEnabled) {
            CookieHandler.setDefault(new CookieManager((CookieStore)new MultiClientSessionCookieStore(), CookiePolicy.ACCEPT_ALL));
        }
    }
}

