/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.commons.DateUtility;
import org.eclipse.scout.rt.ui.rap.form.fields.datefield.chooser.DateRow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DatefieldTableModel
implements IStructuredContentProvider,
ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private static final long serialVersionUID = 1L;
    private List<DateRow> m_rows = new ArrayList<DateRow>();
    private Date m_navigationDate = null;
    private Date m_highLightDate = null;
    private final SimpleDateFormat m_monthYearFormat;
    private final Locale m_locale;
    private Color m_weekendForeground;
    private Color m_outMonthForeground;
    private Color m_outMonthForegroundWeekend;
    private Color m_highlightBackground;
    private Color m_highlightForeground;
    private Font m_highlightFont;

    public DatefieldTableModel(Locale locale) {
        this.m_locale = locale;
        this.m_monthYearFormat = new SimpleDateFormat("MMMMM yyyy", locale);
    }

    public void dispose() {
    }

    public DateRow getHighLightRow() {
        for (DateRow row : this.m_rows) {
            Date min = row.getDate(0);
            Date max = row.getDate(8);
            if (!min.before(this.m_highLightDate) || !max.after(this.m_highLightDate)) continue;
            return row;
        }
        return null;
    }

    public int indexOf(DateRow row) {
        return this.m_rows.indexOf(row);
    }

    public void setRows(ArrayList<DateRow> rows) {
        this.m_rows.clear();
        this.m_rows.addAll(rows);
    }

    public void setHighLightDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.m_highLightDate = date;
    }

    public void setNavigationDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.m_navigationDate = date;
        this.m_rows.clear();
        Calendar c = Calendar.getInstance(this.m_locale);
        c.setTime(date);
        int firstDayOfWeek = c.getFirstDayOfWeek();
        c.add(5, -(c.get(5) - 1));
        c.add(7, -((c.get(7) - firstDayOfWeek + 7) % 7));
        int iRows = 0;
        while (iRows < 6) {
            DateRow row = new DateRow(c.getTime());
            this.m_rows.add(row);
            c.add(5, 7);
            ++iRows;
        }
    }

    public Date getNavigationDate() {
        return this.m_navigationDate;
    }

    public String getMonthYearLabel() {
        return this.m_monthYearFormat.format(this.m_navigationDate);
    }

    public Object[] getElements(Object inputElement) {
        return this.m_rows.toArray();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Calendar c = Calendar.getInstance();
        c.setTime(((DateRow)element).getDate(columnIndex - 1));
        int dayOfMonth = c.get(5);
        return "" + dayOfMonth;
    }

    public Color getBackground(Object element, int columnIndex) {
        return this.m_highlightBackground;
    }

    public Color getForeground(Object element, int columnIndex) {
        Date date = ((DateRow)element).getDate(columnIndex - 1);
        if (DateUtility.isSameDay((Date)date, (Date)this.m_highLightDate)) {
            return this.m_highlightForeground;
        }
        if (DateUtility.isWeekend((Date)date, (Locale)this.m_locale) && DateUtility.isSameMonth((Date)date, (Date)this.m_navigationDate)) {
            return this.m_weekendForeground;
        }
        if (!DateUtility.isSameMonth((Date)date, (Date)this.m_navigationDate) && !DateUtility.isWeekend((Date)date, (Locale)this.m_locale)) {
            return this.m_outMonthForeground;
        }
        if (!DateUtility.isSameMonth((Date)date, (Date)this.m_navigationDate) && DateUtility.isWeekend((Date)date, (Locale)this.m_locale)) {
            return this.m_outMonthForegroundWeekend;
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        Date date = ((DateRow)element).getDate(columnIndex - 1);
        if (DateUtility.isSameDay((Date)date, (Date)this.m_highLightDate)) {
            return this.m_highlightFont;
        }
        return null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

