/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.rap.window.desktop.toolbar;

import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.ui.rap.basic.RwtScoutComposite;
import org.eclipse.scout.rt.ui.rap.util.RwtLayoutUtility;
import org.eclipse.scout.rt.ui.rap.window.desktop.IRwtScoutToolbar;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.IRwtScoutToolButtonBar;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.IRwtScoutViewButtonBar;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.RwtScoutToolButtonBar;
import org.eclipse.scout.rt.ui.rap.window.desktop.toolbar.RwtScoutViewButtonBar;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RwtScoutToolbar
extends RwtScoutComposite<IDesktop>
implements IRwtScoutToolbar<IDesktop> {
    private static final String VARIANT_TOOL_BUTTON_BAR = "toolButtonBar";
    private static final String VARIANT_TOOL_BUTTON_BAR_ACTIVE = "toolButtonBar-active";
    private static final String VARIANT_TOOLBAR_CONTAINER = "toolbarContainer";
    private static final String VARIANT_TOOL_BUTTON_BUTTON_ACTIVE = "toolButton-active";
    private static final String VARIANT_TOOL_BUTTON = "toolButton";
    private RwtScoutToolButtonBar m_uiToolButtonBar;
    private RwtScoutViewButtonBar m_uiViewButtonBar;

    @Override
    protected void initializeUi(Composite parent) {
        Composite container = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        container.setData("org.eclipse.rap.rwt.customVariant", (Object)VARIANT_TOOLBAR_CONTAINER);
        Control viewButtonbar = this.createViewButtonBar(container);
        Control busyIndicator = this.createBusyIndicator(container);
        Control toolButtonBar = this.createToolButtonBar(container);
        this.initLayout(container, viewButtonbar, busyIndicator, toolButtonBar);
        this.setUiContainer(container);
    }

    protected void initLayout(Composite container, Control viewButtonbar, Control busyIndicator, Control toolButtonBar) {
        container.setLayout((Layout)RwtLayoutUtility.createGridLayoutNoSpacing(3, false));
        if (viewButtonbar != null) {
            viewButtonbar.setLayoutData((Object)new GridData(40));
        }
        if (busyIndicator != null) {
            busyIndicator.setLayoutData((Object)new GridData(580));
        }
        if (toolButtonBar != null) {
            toolButtonBar.setLayoutData((Object)new GridData(136));
        }
    }

    @Override
    public void handleRightViewPositionChanged(int rightViewX) {
        if (this.getUiToolButtonBar() == null) {
            return;
        }
        GridData gridData = (GridData)this.getUiToolButtonBar().getUiContainer().getLayoutData();
        gridData.widthHint = rightViewX > 0 ? this.getUiContainer().getSize().x - rightViewX : -1;
        this.getUiContainer().layout();
    }

    protected Control createViewButtonBar(Composite parent) {
        this.m_uiViewButtonBar = new RwtScoutViewButtonBar();
        this.m_uiViewButtonBar.createUiField(parent, (IDesktop)this.getScoutObject(), this.getUiEnvironment());
        return this.m_uiViewButtonBar.getUiContainer();
    }

    protected Control createBusyIndicator(Composite parent) {
        Composite busyComposite = this.getUiEnvironment().getFormToolkit().createComposite(parent);
        busyComposite.setData("org.eclipse.rap.rwt.customVariant", (Object)"busyIndicator");
        busyComposite.setLayout(new Layout(){
            private static final long serialVersionUID = 1L;

            protected void layout(Composite composite, boolean flushCache) {
            }

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }
        });
        busyComposite.setVisible(false);
        this.getUiEnvironment().getClientSession().setData("RwtBusyHandler.busyControl", (Object)busyComposite);
        return busyComposite;
    }

    protected Control createToolButtonBar(Composite parent) {
        this.m_uiToolButtonBar = new RwtScoutToolButtonBar();
        this.m_uiToolButtonBar.createUiField(parent, (IDesktop)this.getScoutObject(), this.getUiEnvironment());
        return this.m_uiToolButtonBar.getUiContainer();
    }

    public IRwtScoutViewButtonBar getUiViewButtonBar() {
        return this.m_uiViewButtonBar;
    }

    public IRwtScoutToolButtonBar getUiToolButtonBar() {
        return this.m_uiToolButtonBar;
    }
}

