/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.svg.client.svgfield;

import java.io.ByteArrayOutputStream;
import java.net.URL;
import java.util.EventListener;
import java.util.List;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;
import org.eclipse.scout.svg.client.SVGUtility;
import org.eclipse.scout.svg.client.extension.svgfield.ISvgFieldExtension;
import org.eclipse.scout.svg.client.extension.svgfield.SvgFieldChains;
import org.eclipse.scout.svg.client.svgfield.ISvgField;
import org.eclipse.scout.svg.client.svgfield.ISvgFieldListener;
import org.eclipse.scout.svg.client.svgfield.ISvgFieldUIFacade;
import org.eclipse.scout.svg.client.svgfield.SvgFieldEvent;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGPoint;

@ClassId(value="20ed1036-9314-4bd8-bad6-c66e778f281f")
public abstract class AbstractSvgField
extends AbstractFormField
implements ISvgField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSvgField.class);
    private ISvgFieldUIFacade m_uiFacade;
    private final EventListenerList m_listenerList = new EventListenerList();
    private boolean m_actionRunning = false;

    public AbstractSvgField() {
        this(true);
    }

    public AbstractSvgField(boolean callInitializer) {
        super(callInitializer);
    }

    protected int getConfiguredVerticalAlignment() {
        return 0;
    }

    protected int getConfiguredHorizontalAlignment() {
        return 0;
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execClicked(SvgFieldEvent e) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execHyperlink(SvgFieldEvent e) throws ProcessingException {
    }

    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
    }

    @Override
    public void addSvgFieldListener(ISvgFieldListener listener) {
        this.m_listenerList.add(ISvgFieldListener.class, (EventListener)listener);
    }

    @Override
    public void removeSvgFieldListener(ISvgFieldListener listener) {
        this.m_listenerList.remove(ISvgFieldListener.class, (EventListener)listener);
    }

    @Override
    public SVGDocument getSvgDocument() {
        return (SVGDocument)this.propertySupport.getProperty("svgDocument");
    }

    @Override
    public void setSvgDocument(SVGDocument doc) {
        this.setSelection(null);
        if (LOG.isTraceEnabled()) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                SVGUtility.writeSVGDocument(doc, out, "UTF-8");
                LOG.trace(String.valueOf(this.getClass().getName()) + ".setSvgDocument\n" + new String(out.toByteArray(), "UTF-8"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.propertySupport.setProperty("svgDocument", (Object)doc);
    }

    @Override
    public SVGPoint getSelection() {
        return (SVGPoint)this.propertySupport.getProperty("selection");
    }

    @Override
    public void setSelection(SVGPoint point) {
        this.propertySupport.setProperty("selection", (Object)point);
    }

    @Override
    public ISvgFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private void fireHyperlink(URL url) {
        if (!this.m_actionRunning) {
            try {
                this.m_actionRunning = true;
                SvgFieldEvent e = new SvgFieldEvent(this, 10, null, url);
                try {
                    this.interceptHyperlink(e);
                }
                catch (ProcessingException pe) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(pe);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                }
                this.fireSvgFieldEventInternal(e);
            }
            finally {
                this.m_actionRunning = false;
            }
        }
    }

    private void fireClick() {
        if (!this.m_actionRunning) {
            try {
                this.m_actionRunning = true;
                SvgFieldEvent e = new SvgFieldEvent(this, 20, this.getSelection(), null);
                try {
                    this.interceptClicked(e);
                }
                catch (ProcessingException pe) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(pe);
                }
                catch (Throwable t) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                }
                this.fireSvgFieldEventInternal(e);
            }
            finally {
                this.m_actionRunning = false;
            }
        }
    }

    private void fireSvgFieldEventInternal(SvgFieldEvent e) {
        EventListener[] a = this.m_listenerList.getListeners(ISvgFieldListener.class);
        if (a != null) {
            int i = 0;
            while (i < a.length) {
                ((ISvgFieldListener)a[i]).handleSvgFieldEvent(e);
                ++i;
            }
        }
    }

    protected final void interceptClicked(SvgFieldEvent e) throws ProcessingException {
        List extensions = this.getAllExtensions();
        SvgFieldChains.SvgFieldClickedChain chain = new SvgFieldChains.SvgFieldClickedChain(extensions);
        chain.execClicked(e);
    }

    protected final void interceptHyperlink(SvgFieldEvent e) throws ProcessingException {
        List extensions = this.getAllExtensions();
        SvgFieldChains.SvgFieldHyperlinkChain chain = new SvgFieldChains.SvgFieldHyperlinkChain(extensions);
        chain.execHyperlink(e);
    }

    protected ISvgFieldExtension<? extends AbstractSvgField> createLocalExtension() {
        return new LocalSvgFieldExtension<AbstractSvgField>(this);
    }

    protected static class LocalSvgFieldExtension<OWNER extends AbstractSvgField>
    extends AbstractFormField.LocalFormFieldExtension<OWNER>
    implements ISvgFieldExtension<OWNER> {
        public LocalSvgFieldExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execClicked(SvgFieldChains.SvgFieldClickedChain chain, SvgFieldEvent e) throws ProcessingException {
            ((AbstractSvgField)this.getOwner()).execClicked(e);
        }

        @Override
        public void execHyperlink(SvgFieldChains.SvgFieldHyperlinkChain chain, SvgFieldEvent e) throws ProcessingException {
            ((AbstractSvgField)this.getOwner()).execHyperlink(e);
        }
    }

    private class P_UIFacade
    implements ISvgFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public void fireHyperlinkFromUI(URL url) {
            if (url == null) {
                return;
            }
            AbstractSvgField.this.fireHyperlink(url);
        }

        @Override
        public void fireClickFromUI(SVGPoint point) {
            AbstractSvgField.this.setSelection(point);
            if (point == null) {
                return;
            }
            AbstractSvgField.this.fireClick();
        }
    }
}

