/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.svg.client.svgfield;

import java.io.Serializable;
import java.net.URL;
import java.util.EventObject;
import org.apache.batik.dom.svg.SVGOMPoint;
import org.eclipse.scout.svg.client.svgfield.ISvgField;
import org.w3c.dom.svg.SVGPoint;

public class SvgFieldEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final int m_type;
    private final Point m_point;
    private final URL m_url;
    public static final int TYPE_HYPERLINK = 10;
    public static final int TYPE_CLICKED = 20;

    SvgFieldEvent(ISvgField source, int type, SVGPoint point, URL url) {
        super(source);
        this.m_type = type;
        this.m_point = point != null ? new Point(point.getX(), point.getY()) : null;
        this.m_url = url;
    }

    public int getType() {
        return this.m_type;
    }

    public ISvgField getSvgField() {
        return (ISvgField)this.getSource();
    }

    public SVGPoint getPoint() {
        if (this.m_point == null) {
            return null;
        }
        return new SVGOMPoint(this.m_point.getX(), this.m_point.getY());
    }

    public URL getURL() {
        return this.m_url;
    }

    private class Point
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private float m_x;
        private float m_y;

        public Point(float x, float y) {
            this.m_x = x;
            this.m_y = y;
        }

        public float getX() {
            return this.m_x;
        }

        public float getY() {
            return this.m_y;
        }
    }
}

