/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.spellchecker;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.services.common.file.IFileService;
import org.eclipse.scout.rt.client.services.common.spellchecker.IResourceLocator;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;

public class BundleResourceLocator
implements IResourceLocator {
    private Bundle m_bundle;
    private String m_folder;

    public BundleResourceLocator(Bundle bundle, String folder) {
        this.m_bundle = bundle;
        this.m_folder = folder;
    }

    @Override
    public void initialize() throws ProcessingException {
    }

    @Override
    public File getFile(String name) throws ProcessingException {
        File f = ((IFileService)SERVICES.getService(IFileService.class)).getLocalFileLocation(this.m_folder, name);
        f.delete();
        URL url = this.m_bundle.getResource(String.valueOf(this.m_folder) + "/" + name);
        if (url != null) {
            try {
                IOUtility.writeContent((String)f.getAbsolutePath(), (Object)IOUtility.getContent((InputStream)url.openStream()));
            }
            catch (IOException e) {
                throw new ProcessingException("reading bundle resource " + this.m_bundle.getSymbolicName() + ":" + this.m_folder + "/" + name);
            }
        }
        return f;
    }
}

