/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.outline;

import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.basic.tree.ITreeExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.IOutlineExtension;
import org.eclipse.scout.rt.client.extension.ui.desktop.outline.OutlineChains;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.IMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.action.menu.TableMenuType;
import org.eclipse.scout.rt.client.ui.action.menu.TreeMenuType;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.internal.TablePageTreeMenuWrapper;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.desktop.outline.DefaultPageChangeStrategy;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.IPageChangeStrategy;
import org.eclipse.scout.rt.client.ui.desktop.outline.OutlineMediator;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.AbstractPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithNodes;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractOutline
extends AbstractTree
implements IOutline {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractOutline.class);
    private boolean m_visibleGranted;
    private boolean m_visibleProperty;
    private IPage m_contextPage;
    private IPageChangeStrategy m_pageChangeStrategy;
    private OptimisticLock m_contextPageOptimisticLock;
    private OutlineMediator m_outlineMediator;
    private List<IMenu> m_inheritedMenusOfPage;

    public AbstractOutline() {
    }

    public AbstractOutline(boolean callInitialzier) {
        super(callInitialzier);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=90.0)
    protected boolean getConfiguredVisible() {
        return true;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=120.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    @ConfigOperation
    @Order(value=90.0)
    protected void execCreateChildPages(List<IPage> pageList) throws ProcessingException {
    }

    protected void createChildPagesInternal(List<IPage> pageList) throws ProcessingException {
        this.interceptCreateChildPages(pageList);
    }

    @Override
    protected void execDrop(ITreeNode node, TransferObject t) {
        Object table;
        if (node instanceof IPageWithTable && (table = ((IPageWithTable)node).getTable()).getDropType() != 0) {
            table.getUIFacade().fireRowDropActionFromUI(null, t);
        }
    }

    @Override
    protected void initConfig() {
        this.m_visibleGranted = true;
        this.m_contextPageOptimisticLock = new OptimisticLock();
        this.setPageChangeStrategy(this.createPageChangeStrategy());
        this.m_outlineMediator = this.createOutlineMediator();
        this.addTreeListener(new P_OutlineListener());
        this.addNodeFilter(new P_TableFilterBasedTreeNodeFilter());
        super.initConfig();
        this.setRootNodeVisible(false);
        InvisibleRootPage rootPage = new InvisibleRootPage();
        this.setRootNode(rootPage);
        this.setEnabled(this.getConfiguredEnabled());
        this.setVisible(this.getConfiguredVisible());
        this.setOrder(this.calculateViewOrder());
    }

    @Override
    public IPage getActivePage() {
        return (IPage)this.getSelectedNode();
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        if (viewOrder == 9.876543212345678E16) {
            Class<?> cls = this.getClass();
            while (cls != null && IOutline.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    @Override
    public void refreshPages(Class<?> ... pageTypes) {
        if (pageTypes == null || pageTypes.length < 1) {
            return;
        }
        ArrayList<Class<? extends IPage>> list = new ArrayList<Class<? extends IPage>>(pageTypes.length);
        Class<?>[] classArray = pageTypes;
        int n = pageTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (IPage.class.isAssignableFrom(c)) {
                list.add(c);
            }
            ++n2;
        }
        this.refreshPages(list);
    }

    @Override
    public void refreshPages(final List<Class<? extends IPage>> pageTypes) {
        final ArrayList candidates = new ArrayList();
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                IPage page = (IPage)node;
                if (page == null) {
                    return true;
                }
                Class<?> pageClass = page.getClass();
                for (Class c : pageTypes) {
                    if (!c.isAssignableFrom(pageClass)) continue;
                    candidates.add(page);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        for (IPage page : candidates) {
            if (page.getTree() == null) continue;
            page.dataChanged(new Object[0]);
        }
    }

    @Override
    public void releaseUnusedPages() {
        block8: {
            final HashSet<IPage> preservationSet = new HashSet<IPage>();
            IPage oldSelection = (IPage)this.getSelectedNode();
            IPage p = oldSelection;
            if (p != null) {
                while (p != null) {
                    preservationSet.add(p);
                    p = p.getParentPage();
                }
            }
            ITreeVisitor v = new ITreeVisitor(){

                @Override
                public boolean visit(ITreeNode node) {
                    IPage page = (IPage)node;
                    if (!(preservationSet.contains(page) || !page.isChildrenLoaded() || page.isExpanded() && page.getParentPage() != null && page.getParentPage().isChildrenLoaded())) {
                        try {
                            AbstractOutline.this.unloadNode(page);
                        }
                        catch (ProcessingException e) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                        }
                    }
                    return true;
                }
            };
            try {
                IPage selectedPage;
                this.setTreeChanging(true);
                this.visitNode(this.getRootNode(), v);
                if (oldSelection == null || (selectedPage = (IPage)this.getSelectedNode()) != null) break block8;
                try {
                    this.getRootNode().ensureChildrenLoaded();
                    List<ITreeNode> children = this.getRootNode().getFilteredChildNodes();
                    if (CollectionUtility.hasElements(children)) {
                        this.selectNode((ITreeNode)CollectionUtility.firstElement(children));
                    }
                }
                catch (ProcessingException e) {
                    LOG.warn(null, (Throwable)e);
                }
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    @Override
    public <T extends IPage> T findPage(final Class<T> pageType) {
        final Holder result = new Holder(pageType, null);
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                IPage page = (IPage)node;
                Class<?> pageClass = page.getClass();
                if (pageType.isAssignableFrom(pageClass)) {
                    result.setValue((Object)page);
                }
                return result.getValue() == null;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return (T)((IPage)result.getValue());
    }

    @Override
    public void setVisiblePermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setVisibleGranted(b);
    }

    @Override
    public boolean isVisibleGranted() {
        return this.m_visibleGranted;
    }

    @Override
    public void setVisibleGranted(boolean b) {
        this.m_visibleGranted = b;
        this.calculateVisible();
    }

    @Override
    public boolean isVisible() {
        return this.propertySupport.getPropertyBool("visible");
    }

    @Override
    public void setVisible(boolean b) {
        this.m_visibleProperty = b;
        this.calculateVisible();
    }

    private void calculateVisible() {
        this.propertySupport.setPropertyBool("visible", this.m_visibleGranted && this.m_visibleProperty);
    }

    @Override
    public IForm getDetailForm() {
        return (IForm)this.propertySupport.getProperty("detailForm");
    }

    @Override
    public void setDetailForm(IForm form) {
        this.propertySupport.setProperty("detailForm", (Object)form);
    }

    @Override
    public ITable getDetailTable() {
        return (ITable)this.propertySupport.getProperty("detailTable");
    }

    @Override
    public void setDetailTable(ITable table) {
        this.propertySupport.setProperty("detailTable", (Object)table);
    }

    @Override
    public IForm getSearchForm() {
        return (IForm)this.propertySupport.getProperty("searchForm");
    }

    @Override
    public void setSearchForm(IForm form) {
        this.propertySupport.setProperty("searchForm", (Object)form);
    }

    public double getOrder() {
        return this.propertySupport.getPropertyDouble("viewOrder");
    }

    public void setOrder(double order) {
        this.propertySupport.setPropertyDouble("viewOrder", order);
    }

    @Override
    public IPage getRootPage() {
        return (IPage)this.getRootNode();
    }

    @Override
    public void unloadNode(ITreeNode node) throws ProcessingException {
        try {
            this.setTreeChanging(true);
            super.unloadNode(node);
            if (node instanceof IPageWithTable) {
                ((IPageWithTable)node).getTable().deleteAllRows();
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void resetOutline() throws ProcessingException {
        if (this.getRootNode() != null) {
            ISearchForm searchForm;
            try {
                this.setTreeChanging(true);
                this.selectNode(null);
                this.unloadNode(this.getRootNode());
                this.getRootNode().ensureChildrenLoaded();
            }
            finally {
                this.setTreeChanging(false);
            }
            ITreeNode root = this.getRootNode();
            if (root instanceof IPageWithTable && (searchForm = ((IPageWithTable)root).getSearchFormInternal()) != null) {
                searchForm.doReset();
            }
            if (!this.isRootNodeVisible()) {
                root.setExpanded(true);
            }
            this.selectFirstNode();
            if (this.getSelectedNode() instanceof IPageWithTable) {
                this.getSelectedNode().setExpanded(true);
            }
        }
    }

    @Override
    public void makeActivePageToContextPage() {
        IPage activePage = this.getActivePage();
        if (activePage != null && this.m_contextPage != activePage) {
            this.m_contextPage = activePage;
            this.addMenusOfActivePageToContextMenu(activePage);
            activePage.pageActivatedNotify();
        }
    }

    @Override
    public List<IMenu> getMenusForPage(IPage page) {
        ArrayList<IMenu> result = new ArrayList<IMenu>();
        for (IMenu m : this.getContextMenu().getChildActions()) {
            if (this.m_inheritedMenusOfPage.contains(m)) continue;
            result.add(m);
        }
        result.addAll(this.computeInheritedMenusOfPage(page));
        return result;
    }

    protected List<IMenu> computeInheritedMenusOfPage(IPage activePage) {
        IPage parentPage;
        Object table;
        List<IMenu> emptySpaceMenus;
        IPageWithTable pageWithTable;
        ArrayList<IMenu> menus = new ArrayList<IMenu>();
        if (activePage instanceof IPageWithTable && (pageWithTable = (IPageWithTable)activePage).isShowEmptySpaceMenus() && (emptySpaceMenus = ActionUtility.getActions((table = pageWithTable.getTable()).getMenus(), ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)TableMenuType.EmptySpace), false))).size() > 0) {
            menus.add(new MenuSeparator());
            for (IMenu menu : emptySpaceMenus) {
                menus.add(menu);
            }
        }
        if ((parentPage = activePage.getParentPage()) instanceof IPageWithTable) {
            IPageWithTable pageWithTable2 = (IPageWithTable)parentPage;
            ITableRow row = pageWithTable2.getTableRowFor(activePage);
            Object table2 = pageWithTable2.getTable();
            if (row != null) {
                table2.getUIFacade().setSelectedRowsFromUI(CollectionUtility.arrayList((Object)row));
                List<IMenu> parentTableMenus = ActionUtility.getActions(table2.getContextMenu().getChildActions(), ActionUtility.createMenuFilterMenuTypes(CollectionUtility.hashSet((Object)TableMenuType.SingleSelection), false));
                if (parentTableMenus.size() > 0) {
                    menus.add(new MenuSeparator());
                    for (IMenu menu : parentTableMenus) {
                        menus.add(menu);
                    }
                }
            }
        }
        return menus;
    }

    protected void addMenusOfActivePageToContextMenu(IPage activePage) {
        ArrayList<IMenu> wrappedMenus = new ArrayList<IMenu>();
        for (IMenu m : this.computeInheritedMenusOfPage(activePage)) {
            if (m.isSeparator()) {
                wrappedMenus.add(m);
                continue;
            }
            wrappedMenus.add(new TablePageTreeMenuWrapper(m, TreeMenuType.SingleSelection, new IMenuType[0]));
        }
        this.m_inheritedMenusOfPage = wrappedMenus;
        this.getContextMenu().addChildActions(this.m_inheritedMenusOfPage);
    }

    @Override
    public void clearContextPage() {
        IPage page = this.m_contextPage;
        if (page != null) {
            this.removeMenusOfActivePageToContextMenu();
            this.m_contextPage = null;
            page.pageDeactivatedNotify();
        }
    }

    protected void removeMenusOfActivePageToContextMenu() {
        if (this.m_inheritedMenusOfPage != null) {
            this.getContextMenu().removeChildActions(this.m_inheritedMenusOfPage);
            this.m_inheritedMenusOfPage = null;
        }
    }

    private void handleActivePageChanged(IPage deselectedPage, IPage selectedPage) {
        if (this.m_pageChangeStrategy == null) {
            return;
        }
        try {
            if (this.m_contextPageOptimisticLock.acquire()) {
                this.m_pageChangeStrategy.pageChanged(this, deselectedPage, selectedPage);
            }
        }
        finally {
            this.m_contextPageOptimisticLock.release();
        }
    }

    @Override
    public OutlineMediator getOutlineMediator() {
        return this.m_outlineMediator;
    }

    protected OutlineMediator createOutlineMediator() {
        return new OutlineMediator();
    }

    protected IPageChangeStrategy createPageChangeStrategy() {
        return new DefaultPageChangeStrategy();
    }

    @Override
    public void setPageChangeStrategy(IPageChangeStrategy pageChangeStrategy) {
        this.m_pageChangeStrategy = pageChangeStrategy;
    }

    @Override
    public IPageChangeStrategy getPageChangeStrategy() {
        return this.m_pageChangeStrategy;
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass(), (boolean)false);
    }

    protected final void interceptCreateChildPages(List<IPage> pageList) throws ProcessingException {
        List<? extends ITreeExtension<? extends AbstractTree>> extensions = this.getAllExtensions();
        OutlineChains.OutlineCreateChildPagesChain chain = new OutlineChains.OutlineCreateChildPagesChain(extensions);
        chain.execCreateChildPages(pageList);
    }

    protected IOutlineExtension<? extends AbstractOutline> createLocalExtension() {
        return new LocalOutlineExtension<AbstractOutline>(this);
    }

    private class InvisibleRootPage
    extends AbstractPageWithNodes {
        private InvisibleRootPage() {
        }

        @Override
        protected void execCreateChildPages(List<IPage> pageList) throws ProcessingException {
            AbstractOutline.this.createChildPagesInternal(pageList);
        }
    }

    protected static class LocalOutlineExtension<OWNER extends AbstractOutline>
    extends AbstractTree.LocalTreeExtension<OWNER>
    implements IOutlineExtension<OWNER> {
        public LocalOutlineExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execCreateChildPages(OutlineChains.OutlineCreateChildPagesChain chain, List<IPage> pageList) throws ProcessingException {
            ((AbstractOutline)this.getOwner()).execCreateChildPages(pageList);
        }
    }

    private class P_OutlineListener
    extends TreeAdapter {
        private P_OutlineListener() {
        }

        @Override
        public void treeChanged(TreeEvent e) {
            switch (e.getType()) {
                case 40: {
                    AbstractOutline.this.handleActivePageChanged((IPage)e.getDeselectedNode(), (IPage)e.getNewSelectedNode());
                }
            }
            ITreeNode commonParentNode = e.getCommonParentNode();
            if (commonParentNode instanceof IPageWithNodes) {
                this.handlePageWithNodesTreeEvent(e, (IPageWithNodes)commonParentNode);
            } else if (commonParentNode instanceof IPageWithTable) {
                this.handlePageWithTableTreeEvent(e, (IPageWithTable)commonParentNode);
            }
        }

        private void handlePageWithNodesTreeEvent(TreeEvent e, IPageWithNodes pageWithNodes) {
            OutlineMediator outlineMediator = AbstractOutline.this.getOutlineMediator();
            if (outlineMediator == null) {
                return;
            }
            switch (e.getType()) {
                case 10: 
                case 20: 
                case 30: 
                case 50: {
                    outlineMediator.mediateTreeNodesChanged(pageWithNodes);
                }
            }
        }

        private void handlePageWithTableTreeEvent(TreeEvent e, IPageWithTable<? extends ITable> pageWithTable) {
            OutlineMediator outlineMediator = AbstractOutline.this.getOutlineMediator();
            if (outlineMediator == null) {
                return;
            }
            switch (e.getType()) {
                case 705: {
                    outlineMediator.mediateTreeNodeAction(e, pageWithTable);
                    break;
                }
                case 730: {
                    outlineMediator.mediateTreeNodesDragRequest(e, pageWithTable);
                    break;
                }
                case 740: {
                    outlineMediator.mediateTreeNodeDropAction(e, pageWithTable);
                }
            }
        }
    }

    private class P_TableFilterBasedTreeNodeFilter
    implements ITreeNodeFilter {
        private P_TableFilterBasedTreeNodeFilter() {
        }

        @Override
        public boolean accept(ITreeNode node, int level) {
            ITreeNode parentNode = node.getParentNode();
            if (parentNode != null && !parentNode.isFilterAccepted()) {
                return false;
            }
            if (parentNode instanceof IPageWithTable) {
                ITableRow tableRow = ((IPageWithTable)parentNode).getTableRowFor(node);
                return tableRow == null || tableRow.isFilterAccepted();
            }
            if (parentNode instanceof IPageWithNodes) {
                for (ITreeNode child : parentNode.getChildNodes()) {
                    if (!child.equals(node)) continue;
                    return ((IPageWithNodes)parentNode).isFilterAcceptedForChildNode(node);
                }
            }
            return true;
        }
    }
}

