/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.filechooserfield;

import java.io.File;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.extension.ui.form.fields.filechooserfield.IFileChooserFieldExtension;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooser;
import org.eclipse.scout.rt.client.ui.basic.filechooser.IFileChooser;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserField;
import org.eclipse.scout.rt.client.ui.form.fields.filechooserfield.IFileChooserFieldUIFacade;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;

@ClassId(value="8d2818c2-5659-4c03-87ef-09441302fbdd")
public abstract class AbstractFileChooserField
extends AbstractValueField<String>
implements IFileChooserField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractFileChooserField.class);
    private File m_directory;
    private List<String> m_fileExtensions;
    private boolean m_typeLoad;
    private boolean m_folderMode;
    private boolean m_showDirectory;
    private boolean m_showFileName;
    private boolean m_showFileExtension;
    private IFileChooserFieldUIFacade m_uiFacade;

    public AbstractFileChooserField() {
        this(true);
    }

    public AbstractFileChooserField(boolean callInitializer) {
        super(callInitializer);
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    protected boolean getConfiguredFolderMode() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    protected boolean getConfiguredShowDirectory() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    protected boolean getConfiguredShowFileName() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=270.0)
    protected boolean getConfiguredShowFileExtension() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    protected boolean getConfiguredTypeLoad() {
        return false;
    }

    @ConfigProperty(value="FILE_EXTENSIONS")
    @Order(value=230.0)
    protected List<String> getConfiguredFileExtensions() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=290.0)
    protected String getConfiguredDirectory() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=300.0)
    protected String getConfiguredFileIconId() {
        return "filechooserfield_file";
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=310.0)
    @ValidationRule(value="maxLength")
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setFolderMode(this.getConfiguredFolderMode());
        this.setShowDirectory(this.getConfiguredShowDirectory());
        this.setShowFileName(this.getConfiguredShowFileName());
        this.setShowFileExtension(this.getConfiguredShowFileExtension());
        this.setTypeLoad(this.getConfiguredTypeLoad());
        this.setFileExtensions(this.getConfiguredFileExtensions());
        if (this.getConfiguredDirectory() != null) {
            this.setDirectory(new File(this.getConfiguredDirectory()));
        }
        this.setFileIconId(this.getConfiguredFileIconId());
        this.setMaxLength(this.getConfiguredMaxLength());
    }

    @Override
    public IFileChooserFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setFolderMode(boolean b) {
        this.m_folderMode = b;
        if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
            this.setDisplayText(this.interceptFormatValue((String)this.getValue()));
        }
    }

    @Override
    public boolean isFolderMode() {
        return this.m_folderMode;
    }

    @Override
    public void setShowDirectory(boolean b) {
        this.m_showDirectory = b;
        if (UserAgentUtility.isWebClient()) {
            this.m_showDirectory = false;
        }
        if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
            this.setDisplayText(this.interceptFormatValue((String)this.getValue()));
        }
    }

    @Override
    public boolean isShowDirectory() {
        return this.m_showDirectory;
    }

    @Override
    public void setShowFileName(boolean b) {
        this.m_showFileName = b;
        if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
            this.setDisplayText(this.interceptFormatValue((String)this.getValue()));
        }
    }

    @Override
    public boolean isShowFileName() {
        return this.m_showFileName;
    }

    @Override
    public void setShowFileExtension(boolean b) {
        this.m_showFileExtension = b;
        if (this.isInitialized() && this.shouldUpdateDisplayText(false)) {
            this.setDisplayText(this.interceptFormatValue((String)this.getValue()));
        }
    }

    @Override
    public boolean isShowFileExtension() {
        return this.m_showFileExtension;
    }

    @Override
    public void setTypeLoad(boolean b) {
        this.m_typeLoad = b;
    }

    @Override
    public boolean isTypeLoad() {
        return this.m_typeLoad;
    }

    @Override
    public void setFileExtensions(List<String> a) {
        this.m_fileExtensions = CollectionUtility.arrayListWithoutNullElements(a);
    }

    @Override
    public List<String> getFileExtensions() {
        return CollectionUtility.arrayList(this.m_fileExtensions);
    }

    @Override
    public void setDirectory(File d) {
        this.m_directory = d;
    }

    @Override
    public File getDirectory() {
        return this.m_directory;
    }

    @Override
    public void setFileIconId(String s) {
        this.propertySupport.setPropertyString("fileIconId", s);
    }

    @Override
    public String getFileIconId() {
        return this.propertySupport.getPropertyString("fileIconId");
    }

    @Override
    public void setMaxLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxLength", len);
        }
        if (this.isInitialized()) {
            this.setValue((String)this.getValue());
        }
    }

    @Override
    public int getMaxLength() {
        int len = this.propertySupport.getPropertyInt("maxLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    public IFileChooser getFileChooser() {
        FileChooser fc = new FileChooser();
        fc.setTypeLoad(this.isTypeLoad());
        fc.setFolderMode(this.isFolderMode());
        fc.setDirectory(this.getDirectory());
        fc.setFileName(this.getFileName());
        fc.setFileExtensions(this.getFileExtensions());
        fc.setMultiSelect(false);
        return fc;
    }

    @Override
    public File getValueAsFile() {
        String value = (String)this.getValue();
        if (value == null) {
            return null;
        }
        return new File(value);
    }

    @Override
    public String getFileName() {
        File f = this.getValueAsFile();
        if (f != null) {
            return f.getName();
        }
        return null;
    }

    @Override
    public long getFileSize() {
        File f = this.getValueAsFile();
        if (f != null) {
            return f.length();
        }
        return 0L;
    }

    @Override
    public boolean fileExists() {
        if (this.getValue() == null) {
            return false;
        }
        return this.getValueAsFile().exists();
    }

    @Override
    protected String formatValueInternal(String validValue) {
        String s = validValue;
        if (s != null && s.length() > 0) {
            File f = new File(s);
            if (this.isFolderMode()) {
                s = this.isShowDirectory() ? f.getAbsolutePath() : f.getName();
            } else if (this.isShowDirectory() && this.isShowFileName() && this.isShowFileExtension()) {
                s = f.getAbsolutePath();
            } else {
                String p = StringUtility.valueOf((Object)f.getParent());
                String n = f.getName();
                String e = "";
                if (n.indexOf(46) >= 0) {
                    int i = n.lastIndexOf(46);
                    e = n.substring(i);
                    n = n.substring(0, i);
                }
                s = "";
                if (this.isShowDirectory()) {
                    s = p;
                }
                if (this.isShowFileName()) {
                    if (s.length() > 0) {
                        s = String.valueOf(s) + File.separator;
                    }
                    s = String.valueOf(s) + n;
                }
                if (this.isShowFileExtension()) {
                    s = String.valueOf(s) + e;
                }
            }
        }
        return s;
    }

    @Override
    protected String parseValueInternal(String text) throws ProcessingException {
        String retVal = null;
        if (!StringUtility.hasText((CharSequence)text)) {
            return null;
        }
        text = text.trim();
        text = StringUtility.unquoteText((String)text);
        File f = new File(text);
        String p = "";
        if (f.isAbsolute()) {
            p = f.getParent();
        } else {
            File existingFile = this.getValueAsFile();
            if (existingFile != null && existingFile.isAbsolute()) {
                p = existingFile.getParent();
            }
        }
        String n = f.getName();
        String e = "";
        if (n.indexOf(46) >= 0) {
            int i = n.lastIndexOf(46);
            e = n.substring(i);
            n = n.substring(0, i);
        }
        text = n;
        if (p.length() == 0 && this.getDirectory() != null) {
            p = this.getDirectory().getAbsolutePath();
        }
        if (e.length() == 0 && CollectionUtility.hasElements(this.m_fileExtensions)) {
            e = "." + (String)CollectionUtility.firstElement(this.m_fileExtensions);
        }
        text = p;
        if (p.length() > 0) {
            text = String.valueOf(text) + File.separator;
        }
        text = String.valueOf(text) + n;
        retVal = text = String.valueOf(text) + e;
        return retVal;
    }

    @Override
    protected String validateValueInternal(String text) throws ProcessingException {
        if (text != null && text.length() == 0) {
            text = null;
        }
        if (text != null && text.length() > this.getMaxLength()) {
            text = text.substring(0, this.getMaxLength());
        }
        return text;
    }

    @Override
    protected IFileChooserFieldExtension<? extends AbstractFileChooserField> createLocalExtension() {
        return new LocalFileChooserFieldExtension<AbstractFileChooserField>(this);
    }

    protected static class LocalFileChooserFieldExtension<OWNER extends AbstractFileChooserField>
    extends AbstractValueField.LocalValueFieldExtension<String, OWNER>
    implements IFileChooserFieldExtension<OWNER> {
        public LocalFileChooserFieldExtension(OWNER owner) {
            super(owner);
        }
    }

    private class P_UIFacade
    implements IFileChooserFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String newText) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            return AbstractFileChooserField.this.parseValue(newText);
        }
    }
}

