/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.cache;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.server.commons.cache.AbstractHttpSessionCacheService;
import org.eclipse.scout.rt.server.commons.cache.CacheEntry;
import org.eclipse.scout.rt.server.commons.cache.ICacheEntry;

public class StickySessionCacheService
extends AbstractHttpSessionCacheService {
    @Override
    public void put(String key, Object value, HttpServletRequest req, HttpServletResponse res, Long expiration) {
        if (value != null) {
            this.setEntryInternal(key, value, req, res, expiration);
        }
    }

    @Override
    public void remove(String key, HttpServletRequest req, HttpServletResponse res) {
        req.getSession(true).removeAttribute(key);
    }

    @Override
    public Object get(String key, HttpServletRequest req, HttpServletResponse res) {
        ICacheEntry e = this.getActiveEntry(key, req, res);
        return e != null ? e.getValue() : null;
    }

    @Override
    public void touch(String key, HttpServletRequest req, HttpServletResponse res, Long expiration) {
        ICacheEntry e = this.getActiveEntry(key, req, res);
        if (e != null) {
            e.setExpiration(expiration);
            e.touch();
        }
    }

    protected ICacheEntry getActiveEntry(String key, HttpServletRequest req, HttpServletResponse res) {
        ICacheEntry e = this.getEntryInternal(key, req, res);
        if (e != null) {
            if (e.isActive()) {
                return e;
            }
            this.remove(key, req, res);
        }
        return null;
    }

    protected void setEntryInternal(String key, Object value, HttpServletRequest req, HttpServletResponse res, Long expiration) {
        req.getSession(true).setAttribute(key, new CacheEntry<Object>(value, expiration));
    }

    protected ICacheEntry getEntryInternal(String key, HttpServletRequest req, HttpServletResponse res) {
        return (ICacheEntry)req.getSession(true).getAttribute(key);
    }
}

