/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.action.menu;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.action.menu.ISwtContextMenuMarker;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SwtContextMenuMarkerComposite
extends Canvas
implements ISwtContextMenuMarker {
    private Label m_markerLabel;
    private Point m_markerLabelSize;
    private List<SelectionListener> m_selectionListeners;
    private ISwtEnvironment m_environment;
    private int m_markerLabelTopMargin = 1;
    private int m_markerLabelLeftMargin = 1;
    private int m_markerLabelRightMargin = 1;
    private int m_markerLabelBottomMargin = 1;

    public SwtContextMenuMarkerComposite(Composite parent, ISwtEnvironment environment) {
        this(parent, environment, 2048);
    }

    public SwtContextMenuMarkerComposite(Composite parent, ISwtEnvironment environment, int style) {
        super(parent, style);
        this.m_environment = environment;
        this.m_selectionListeners = new ArrayList<SelectionListener>();
        this.setLayout(new MarkerCompositeLayout());
        this.m_markerLabel = environment.getFormToolkit().createLabel((Composite)this, "");
        Image dropDownIcon = Activator.getIcon("dropdownfield_arrowdown_disabled");
        this.m_markerLabelSize = new Point(dropDownIcon.getBounds().width, dropDownIcon.getBounds().height);
        this.m_markerLabel.setImage(dropDownIcon);
        this.m_markerLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                Rectangle markerLabelBounds = SwtContextMenuMarkerComposite.this.m_markerLabel.getBounds();
                if (SwtContextMenuMarkerComposite.this.isMarkerVisible() && e.x >= 0 && e.x <= markerLabelBounds.width && e.y >= 0 && e.y <= markerLabelBounds.height) {
                    SwtContextMenuMarkerComposite.this.handleDropDownSelection(e);
                }
            }
        });
    }

    public ISwtEnvironment getEnvironment() {
        return this.m_environment;
    }

    protected Label getMarkerLabel() {
        return this.m_markerLabel;
    }

    @Override
    public void setMarkerVisible(boolean visible) {
        if (this.m_markerLabel == null || this.m_markerLabel.isDisposed()) {
            return;
        }
        this.m_markerLabel.setVisible(visible);
        this.layout(true);
    }

    @Override
    public boolean isMarkerVisible() {
        return this.m_markerLabel.getVisible();
    }

    public int getMarkerLabelTopMargin() {
        return this.m_markerLabelTopMargin;
    }

    public void setMarkerLabelTopMargin(int markerLabelTopMargin) {
        this.m_markerLabelTopMargin = markerLabelTopMargin;
    }

    public int getMarkerLabelLeftMargin() {
        return this.m_markerLabelLeftMargin;
    }

    public void setMarkerLabelLeftMargin(int markerLabelLeftMargin) {
        this.m_markerLabelLeftMargin = markerLabelLeftMargin;
    }

    public int getMarkerLabelRightMargin() {
        return this.m_markerLabelRightMargin;
    }

    public void setMarkerLabelRightMargin(int markerLabelRightMargin) {
        this.m_markerLabelRightMargin = markerLabelRightMargin;
    }

    public int getMarkerLabelBottomMargin() {
        return this.m_markerLabelBottomMargin;
    }

    public void setMarkerLabelBottomMargin(int markerLabelBottomMargin) {
        this.m_markerLabelBottomMargin = markerLabelBottomMargin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSelectionListener(SelectionListener listener) {
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            this.m_selectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeSelectionListener(SelectionListener listener) {
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            return this.m_selectionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDropDownSelection(MouseEvent e) {
        ArrayList listeners = null;
        List<SelectionListener> list = this.m_selectionListeners;
        synchronized (list) {
            listeners = CollectionUtility.arrayList(this.m_selectionListeners);
        }
        Event event = new Event();
        event.button = e.button;
        event.count = e.count;
        event.data = e.data;
        event.doit = true;
        event.display = e.display;
        event.stateMask = e.stateMask;
        event.time = e.time;
        event.widget = e.widget;
        event.x = e.x;
        event.y = e.y;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener l : listeners) {
            l.widgetSelected(selectionEvent);
            if (!selectionEvent.doit) break;
        }
    }

    private class MarkerCompositeLayout
    extends Layout {
        private MarkerCompositeLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            if (children.length != 2) {
                throw new IllegalArgumentException("Marker composite only allows exacly one child control!");
            }
            int width = 0;
            int height = 0;
            if (SwtContextMenuMarkerComposite.this.isMarkerVisible()) {
                height = SwtContextMenuMarkerComposite.this.getMarkerLabelTopMargin() + SwtContextMenuMarkerComposite.this.getMarkerLabelBottomMargin() + ((SwtContextMenuMarkerComposite)SwtContextMenuMarkerComposite.this).m_markerLabelSize.y;
                width = SwtContextMenuMarkerComposite.this.getMarkerLabelLeftMargin() + SwtContextMenuMarkerComposite.this.getMarkerLabelRightMargin() + ((SwtContextMenuMarkerComposite)SwtContextMenuMarkerComposite.this).m_markerLabelSize.x;
            }
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c != SwtContextMenuMarkerComposite.this.m_markerLabel) {
                    if (wHint == -1) {
                        Point computedSize = c.computeSize(wHint, hHint);
                        width += computedSize.x;
                        height = Math.max(height, computedSize.y);
                        break;
                    }
                    if (hHint != -1) break;
                    Point computedSize = c.computeSize(Math.max(-1, wHint - width), hHint);
                    width += computedSize.x;
                    height = Math.max(height, computedSize.y);
                    break;
                }
                ++n2;
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            if (children.length != 2) {
                throw new IllegalArgumentException("Marker composite only allows exacly one child control!");
            }
            Rectangle clientArea = composite.getClientArea();
            Rectangle controlBounds = new Rectangle(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
            if (SwtContextMenuMarkerComposite.this.isMarkerVisible()) {
                controlBounds.width = controlBounds.width - ((SwtContextMenuMarkerComposite)SwtContextMenuMarkerComposite.this).m_markerLabelSize.x - SwtContextMenuMarkerComposite.this.getMarkerLabelLeftMargin() - SwtContextMenuMarkerComposite.this.getMarkerLabelRightMargin();
                Rectangle markerIconBounds = new Rectangle(clientArea.width - ((SwtContextMenuMarkerComposite)SwtContextMenuMarkerComposite.this).m_markerLabelSize.x - SwtContextMenuMarkerComposite.this.getMarkerLabelRightMargin(), SwtContextMenuMarkerComposite.this.getMarkerLabelTopMargin(), ((SwtContextMenuMarkerComposite)SwtContextMenuMarkerComposite.this).m_markerLabelSize.x, ((SwtContextMenuMarkerComposite)SwtContextMenuMarkerComposite.this).m_markerLabelSize.y);
                SwtContextMenuMarkerComposite.this.m_markerLabel.setBounds(markerIconBounds);
            }
            Control[] controlArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                if (c != SwtContextMenuMarkerComposite.this.m_markerLabel) {
                    c.setBounds(controlBounds);
                    break;
                }
                ++n2;
            }
        }
    }
}

