/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.form.fields;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class OnFieldLabelDecorator
implements PaintListener,
FocusListener {
    private String m_text;
    private ISwtEnvironment m_env;
    private boolean m_mandatory;
    private Font m_boldFont;

    public OnFieldLabelDecorator(ISwtEnvironment env, boolean mandatory) {
        this.m_env = env;
        this.m_mandatory = mandatory;
    }

    public void setText(String s) {
        this.m_text = s;
    }

    public void attach(Control c) {
        if (c != null && !c.isDisposed()) {
            c.addPaintListener((PaintListener)this);
            c.addFocusListener((FocusListener)this);
        }
    }

    public void detach(Control c) {
        if (c != null && !c.isDisposed()) {
            c.removePaintListener((PaintListener)this);
            c.removeFocusListener((FocusListener)this);
        }
        if (this.m_boldFont != null) {
            this.m_boldFont.dispose();
        }
    }

    public void paintControl(PaintEvent e) {
        if (this.m_text == null) {
            return;
        }
        if (e.gc.isDisposed()) {
            return;
        }
        if (e.widget == null || e.widget.isDisposed()) {
            return;
        }
        Control c = (Control)e.widget;
        if (c.isFocusControl()) {
            return;
        }
        if (c instanceof Text && StringUtility.length((CharSequence)((Text)c).getText()) > 0) {
            return;
        }
        if (c instanceof StyledText && StringUtility.length((CharSequence)((StyledText)c).getText()) > 0) {
            return;
        }
        e.gc.setForeground(this.m_env.getColor(new RGB(192, 192, 192)));
        String s = this.m_text != null ? this.m_text : "";
        int x = c.getBorderWidth();
        int y = c.getBorderWidth();
        x += 2;
        if (this.m_mandatory) {
            FontData[] fd;
            Font f = e.gc.getFont();
            FontData[] fontDataArray = fd = f.getFontData();
            int n = fd.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                data.setStyle(1);
                ++n2;
            }
            if (this.m_boldFont == null) {
                this.m_boldFont = new Font(f.getDevice(), fd);
            }
            e.gc.setFont(this.m_boldFont);
        }
        e.gc.drawString(s, x, y);
    }

    public void focusGained(FocusEvent e) {
        if (e.widget instanceof Control) {
            ((Control)e.widget).redraw();
        }
    }

    public void focusLost(FocusEvent e) {
        if (e.widget instanceof Control) {
            ((Control)e.widget).redraw();
        }
    }
}

