/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.internal.debug.layout.spy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayoutInfo;
import org.eclipse.scout.rt.ui.swt.internal.debug.layout.spy.GridCanvas;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class LogicalGridLayoutSpy
extends Shell {
    public static final String GROUP_BOX_MARKER = "groupBoxMarker";
    private Shell m_parentShell;
    private GridCanvas m_canvas;
    private static int[] SYSTEM_COLORS = new int[]{9, 6, 3, 12};

    public LogicalGridLayoutSpy(Shell parent) {
        super(parent, 65544);
        this.m_parentShell = parent;
        this.setAlpha(150);
        this.m_canvas = new GridCanvas((Composite)this);
        this.setLayout((Layout)new FillLayout());
        this.m_canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                LogicalGridLayoutSpy.this.close();
            }
        });
    }

    protected void checkSubclass() {
    }

    public void activate() {
        this.setBounds(this.m_parentShell.getBounds());
        ArrayList<Composite> groupBoxComposites = new ArrayList<Composite>();
        this.collectGroupBoxes((Composite)this.m_parentShell, groupBoxComposites);
        int i = 0;
        for (Composite group : groupBoxComposites) {
            int col = SYSTEM_COLORS[i];
            i = (i + 1) % SYSTEM_COLORS.length;
            this.renderGroupBoxLayout(group, (LogicalGridLayout)group.getLayout(), col);
        }
        this.setVisible(true);
    }

    protected void renderGroupBoxLayout(Composite group, LogicalGridLayout layout, int color) {
        Rectangle bounds = group.getClientArea();
        Point displayRelativePosition = group.toDisplay(0, 0);
        Point shellRelativePosition = this.getShell().toControl(displayRelativePosition);
        this.m_canvas.addBounds(new GridCanvas.Bounds(new Rectangle(shellRelativePosition.x, shellRelativePosition.y, bounds.width, bounds.height), this.m_canvas.getDisplay().getSystemColor(color)));
        LogicalGridLayoutInfo info = layout.getInfo();
        if (info == null) {
            return;
        }
        Rectangle[][] cellBounds = info.getCellBounds();
        if (cellBounds == null) {
            return;
        }
        if (cellBounds.length > 0 && cellBounds[0].length > 0) {
            Rectangle b;
            int[] xOffsets = new int[cellBounds[0].length - 1];
            int[] yOffsets = new int[cellBounds.length - 1];
            Rectangle prev = null;
            int x = 0;
            while (x < cellBounds[0].length) {
                b = cellBounds[0][x];
                if (prev != null) {
                    xOffsets[x - 1] = b.x - (b.x - (prev.x + prev.width)) / 2;
                }
                prev = b;
                ++x;
            }
            prev = null;
            int y = 0;
            while (y < cellBounds.length) {
                b = cellBounds[y][0];
                if (prev != null) {
                    yOffsets[y - 1] = b.y - (b.y - (prev.y + prev.height)) / 2;
                }
                prev = b;
                ++y;
            }
            x = 0;
            while (x < xOffsets.length) {
                this.m_canvas.addLine(new GridCanvas.Line(this.transformToShell((Control)group, xOffsets[x], 0), this.transformToShell((Control)group, xOffsets[x], bounds.y + bounds.height), group.getDisplay().getSystemColor(color)));
                ++x;
            }
            y = 0;
            while (y < yOffsets.length) {
                this.m_canvas.addLine(new GridCanvas.Line(this.transformToShell((Control)group, 0, yOffsets[y]), this.transformToShell((Control)group, bounds.x + bounds.width, yOffsets[y]), group.getDisplay().getSystemColor(color)));
                ++y;
            }
        }
    }

    protected Point transformToShell(Control c, int x, int y) {
        Point displayRelativePosition = c.toDisplay(x, y);
        Point shellRelativePosition = this.getShell().toControl(displayRelativePosition);
        return shellRelativePosition;
    }

    private void collectGroupBoxes(Composite composite, List<Composite> groupBoxComposites) {
        if (composite.getData(GROUP_BOX_MARKER) != null && composite.getLayout() instanceof LogicalGridLayout) {
            groupBoxComposites.add(composite);
        }
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child instanceof Composite) {
                this.collectGroupBoxes((Composite)child, groupBoxComposites);
            }
            ++n2;
        }
    }
}

