/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.LayoutValidateManager;
import org.eclipse.scout.rt.ui.swt.LogicalGridLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;

public final class SwtLayoutUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtLayoutUtility.class);
    private static LayoutValidateManager layoutValidateManager = new LayoutValidateManager();
    private static boolean dumpSizeTreeRunning;

    private SwtLayoutUtility() {
    }

    public static void invalidateLayout(Control c) {
        layoutValidateManager.invalidate(c);
    }

    public static Point computeSizeEx(Control control, int wHint, int hHint, boolean flushCache) {
        Point size = null;
        if (wHint == -1 && hHint == -1) {
            size = control.computeSize(wHint, hHint, flushCache);
        } else {
            int trimH;
            int trimW;
            if (control instanceof Scrollable) {
                Rectangle rect = ((Scrollable)control).computeTrim(0, 0, 0, 0);
                trimW = rect.width;
                trimH = rect.height;
            } else {
                trimW = trimH = control.getBorderWidth() * 2;
            }
            if (control instanceof StyledText) {
                StyledText styledText = (StyledText)control;
                try {
                    Method getLeftMargin = StyledText.class.getMethod("getLeftMargin", new Class[0]);
                    int leftMargin = (Integer)getLeftMargin.invoke((Object)styledText, new Object[0]);
                    Method getRightMargin = StyledText.class.getMethod("getRightMargin", new Class[0]);
                    int rightMargin = (Integer)getRightMargin.invoke((Object)styledText, new Object[0]);
                    trimW = trimW + leftMargin + rightMargin;
                }
                catch (Exception e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.scout.rt.ui.swt", "could not access methods 'getLeftMargin' and 'getRightMargin' on 'StyledText'.", (Throwable)e));
                }
            }
            int wHintFixed = wHint == -1 ? wHint : Math.max(0, wHint - trimW);
            int hHintFixed = hHint == -1 ? hHint : Math.max(0, hHint - trimH);
            size = control.computeSize(wHintFixed, hHintFixed, flushCache);
        }
        return size;
    }

    public static void dumpSizeTree(Control c) {
        if (!dumpSizeTreeRunning) {
            try {
                dumpSizeTreeRunning = true;
                SwtLayoutUtility.dumpSizeTreeRec(c, "");
            }
            finally {
                dumpSizeTreeRunning = false;
            }
        }
    }

    private static void dumpSizeTreeRec(Control c, String prefix) {
        Layout layout;
        Layout lm;
        Point d = c.computeSize(-1, -1, false);
        String lay = "null";
        if (c instanceof Composite && (lm = ((Composite)c).getLayout()) != null) {
            lay = lm.getClass().getSimpleName();
        }
        Rectangle r = c.getBounds();
        StringBuffer buf = new StringBuffer();
        buf.append("[" + r.x + "," + r.y + "," + r.width + "," + r.height + "]");
        buf.append(" pref=(" + d.x + "," + d.y + ")");
        buf.append(" " + c.getClass().getSimpleName());
        buf.append(" layout=" + lay);
        buf.append(c.getVisible() ? " VISIBLE" : " INVISIBLE");
        Object gd = c.getLayoutData();
        if (gd != null) {
            buf.append(" logicalGridData=" + gd);
        }
        if (c instanceof Composite && (layout = ((Composite)c).getLayout()) instanceof LogicalGridLayout) {
            StringWriter w = new StringWriter();
            ((LogicalGridLayout)layout).dumpLayoutInfo((Composite)c, new PrintWriter((Writer)w, true));
            buf.append("\n  " + w.toString().replace("\n", "\n  "));
        }
        String msg = String.valueOf(prefix) + buf.toString().replace("\n", "\n" + prefix);
        System.out.println(msg);
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                SwtLayoutUtility.dumpSizeTreeRec(child, String.valueOf(prefix) + "  ");
                ++n2;
            }
        }
    }

    public static Point computeMinimumSize(Control c, boolean changed) {
        Layout layout;
        if (c instanceof Composite && (layout = ((Composite)c).getLayout()) instanceof LogicalGridLayout) {
            return ((LogicalGridLayout)layout).computeMinimumSize((Composite)c, changed);
        }
        return c.computeSize(-1, -1, changed);
    }
}

