/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.desktop.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.scout.commons.OptimisticLock;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.ui.action.ActionUtility;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.tool.IToolButton;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.action.SwtScoutToolbarAction;
import org.eclipse.scout.rt.ui.swt.busy.AnimatedBusyImage;
import org.eclipse.scout.rt.ui.swt.form.ISwtScoutForm;
import org.eclipse.scout.rt.ui.swt.util.ScoutFormToolkit;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.rt.ui.swt.util.listener.PartListener;
import org.eclipse.scout.rt.ui.swt.window.ISwtScoutPart;
import org.eclipse.scout.rt.ui.swt.window.desktop.editor.ScoutFormEditorInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.part.EditorPart;

public abstract class AbstractScoutEditorPart
extends EditorPart
implements ISwtScoutPart,
ISaveablePart2 {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractScoutEditorPart.class);
    public static final String EDITOR_ID = AbstractScoutEditorPart.class.getName();
    private Form m_rootForm;
    private Composite m_rootArea;
    private P_EditorListener m_editorListener;
    private final OptimisticLock m_closeLock;
    private final OptimisticLock m_closeFromModel;
    private final PropertyChangeListener m_formPropertyListener;
    private final OptimisticLock m_layoutLock = new OptimisticLock();
    private ISwtScoutForm m_uiForm;
    private Image m_titleImageBackup;
    private AnimatedBusyImage m_busyImage;

    public AbstractScoutEditorPart() {
        this.m_closeLock = new OptimisticLock();
        this.m_closeFromModel = new OptimisticLock();
        this.m_formPropertyListener = new P_ScoutPropertyChangeListener();
    }

    protected void setTitleImage(Image titleImage) {
        this.m_titleImageBackup = titleImage;
        if (this.m_busyImage == null || !this.m_busyImage.isBusy()) {
            super.setTitleImage(titleImage);
        }
    }

    @Override
    public void setBusy(boolean b) {
        if (this.m_busyImage == null || this.m_busyImage.isBusy() == b) {
            return;
        }
        this.m_busyImage.setBusy(b);
        if (!b) {
            super.setTitleImage(this.m_titleImageBackup);
        }
    }

    protected void attachScout() {
        this.updateToolbarActionsFromScout();
        IForm form = this.getForm();
        this.setTitleFromScout(form.getTitle());
        this.setImageFromScout(form.getIconId());
        this.setMaximizeEnabledFromScout(form.isMaximizeEnabled());
        this.setMaximizedFromScout(form.isMaximized());
        this.setMinimizeEnabledFromScout(form.isMinimizeEnabled());
        this.setMinimizedFromScout(form.isMinimized());
        boolean closable = false;
        for (IFormField f : form.getAllFields()) {
            if (f.isEnabled() && f.isVisible() && f instanceof IButton) {
                switch (((IButton)f).getSystemType()) {
                    case 1: 
                    case 2: {
                        closable = true;
                    }
                }
            }
            if (closable) break;
        }
        this.setCloseEnabledFromScout(closable);
        form.addPropertyChangeListener(this.m_formPropertyListener);
        if (this.m_editorListener == null) {
            this.m_editorListener = new P_EditorListener();
        }
        this.getSite().getPage().addPartListener((IPartListener2)this.m_editorListener);
    }

    protected void updateToolbarActionsFromScout() {
        List toolbuttons = ActionUtility.visibleNormalizedActions((List)this.getForm().getToolButtons());
        if (!toolbuttons.isEmpty()) {
            IToolBarManager toolBarManager = this.getRootForm().getToolBarManager();
            if (this.getForm().getToolbarLocation() == 31) {
                toolBarManager = this.getEditorSite().getActionBars().getToolBarManager();
            }
            for (IToolButton b : toolbuttons) {
                toolBarManager.add((org.eclipse.jface.action.IAction)new SwtScoutToolbarAction((IAction)b, this.getSwtEnvironment(), toolBarManager));
            }
            toolBarManager.update(true);
        }
    }

    protected void detachScout() {
        if (this.getForm() != null) {
            this.getForm().removePropertyChangeListener(this.m_formPropertyListener);
        }
    }

    @Override
    public final void closePart() throws ProcessingException {
        block5: {
            try {
                this.m_closeFromModel.acquire();
                if (!this.m_closeLock.acquire()) break block5;
                try {
                    this.execCloseEditor();
                }
                catch (Exception e) {
                    throw new ProcessingException("could not close editor '" + this.getEditorSite().getId() + "'.", (Throwable)e);
                }
            }
            finally {
                this.m_closeLock.release();
                this.m_closeFromModel.release();
            }
        }
    }

    protected boolean execCloseEditor() throws Exception {
        return this.getSite().getPage().closeEditor((IEditorPart)this, false);
    }

    public void dispose() {
        this.detachScout();
        this.getSite().getPage().removePartListener((IPartListener2)this.m_editorListener);
        super.dispose();
    }

    protected void setImageFromScout(String iconId) {
        Form swtForm = this.getSwtForm();
        if (swtForm.isDisposed()) {
            return;
        }
        Image img = this.getSwtEnvironment().getIcon(iconId);
        this.setTitleImage(img);
        String sub = this.getForm().getSubTitle();
        if (sub != null) {
            swtForm.setImage(img);
        } else {
            swtForm.setImage(null);
        }
    }

    protected void setTitleFromScout(String title) {
        Form swtForm = this.getSwtForm();
        if (swtForm.isDisposed()) {
            return;
        }
        IForm f = this.getForm();
        String s = f.getBasicTitle();
        this.setPartName(StringUtility.removeNewLines((String)(s != null ? s : "")));
        s = f.getSubTitle();
        if (s != null) {
            swtForm.setText(SwtUtility.escapeMnemonics(StringUtility.removeNewLines((String)s)));
        } else {
            swtForm.setText(null);
        }
    }

    protected void setMaximizeEnabledFromScout(boolean maximizable) {
    }

    protected void setMaximizedFromScout(boolean maximized) {
    }

    protected void setMinimizeEnabledFromScout(boolean minized) {
    }

    protected void setMinimizedFromScout(boolean minimized) {
    }

    protected void setCloseEnabledFromScout(boolean closebale) {
    }

    protected abstract ISwtEnvironment getSwtEnvironment();

    public void createPartControl(Composite parent) {
        this.m_busyImage = new AnimatedBusyImage(parent.getDisplay()){

            @Override
            protected void notifyImage(Image image) {
                AbstractScoutEditorPart.super.setTitleImage(image);
            }
        };
        ScoutFormToolkit toolkit = this.getSwtEnvironment().getFormToolkit();
        this.m_rootForm = toolkit.createForm(parent);
        this.m_rootForm.setData("SCROLLED_FORM", new Object());
        this.m_rootArea = this.m_rootForm.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 2;
        gridLayout.marginWidth = 2;
        gridLayout.verticalSpacing = 0;
        this.m_rootArea.setLayout((Layout)gridLayout);
        try {
            this.m_layoutLock.acquire();
            this.m_rootArea.setRedraw(false);
            this.m_uiForm = this.getSwtEnvironment().createForm(this.m_rootArea, this.getForm());
            GridData d = new GridData(1808);
            this.m_uiForm.getSwtContainer().setLayoutData((Object)d);
            this.attachScout();
        }
        finally {
            this.m_layoutLock.release();
            this.m_rootArea.setRedraw(true);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ScoutFormEditorInput)) {
            throw new PartInitException("Input must be from instance ScoutFormEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    @Override
    public IForm getForm() {
        return ((ScoutFormEditorInput)this.getEditorInput()).getScoutObject();
    }

    @Override
    public ISwtScoutForm getUiForm() {
        return this.m_uiForm;
    }

    @Override
    public Form getSwtForm() {
        return this.m_rootForm;
    }

    public Form getRootForm() {
        return this.m_rootForm;
    }

    public int promptToSaveOnClose() {
        if (this.getForm() == null) {
            return 1;
        }
        if (this.m_closeFromModel.isReleased()) {
            new ClientSyncJob("Prompt to save", this.getSwtEnvironment().getClientSession()){

                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    AbstractScoutEditorPart.this.getForm().getUIFacade().fireFormClosingFromUI();
                }
            }.schedule();
            return 2;
        }
        return 0;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        if (this.getForm() != null && this.getForm().isAskIfNeedSave()) {
            return this.getForm().isSaveNeeded();
        }
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        Control focusControl = this.m_rootArea.getDisplay().getFocusControl();
        if (focusControl != null && !focusControl.isDisposed()) {
            focusControl.traverse(16);
        }
        return this.isDirty();
    }

    public void setFocus() {
        this.m_rootArea.setFocus();
    }

    protected void handlePartActivatedFromUI() {
        if (this.getSwtEnvironment().isInitialized()) {
            Runnable job = new Runnable(){

                @Override
                public void run() {
                    if (AbstractScoutEditorPart.this.getForm() != null) {
                        AbstractScoutEditorPart.this.getForm().getUIFacade().fireFormActivatedFromUI();
                    }
                }
            };
            this.getSwtEnvironment().invokeScoutLater(job, 0L);
        }
    }

    protected void handleClosedFromUI() {
        try {
            if (this.m_closeLock.acquire()) {
                Runnable job = new Runnable(){

                    @Override
                    public void run() {
                        if (AbstractScoutEditorPart.this.getForm() != null) {
                            AbstractScoutEditorPart.this.getForm().getUIFacade().fireFormKilledFromUI();
                        }
                    }
                };
                this.getSwtEnvironment().invokeScoutLater(job, 0L);
            }
        }
        finally {
            this.m_closeLock.release();
        }
    }

    @Override
    public void activate() {
        this.getSite().getPage().activate(this.getSite().getPart());
    }

    @Override
    public boolean isActive() {
        IWorkbenchWindow w = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (w == null) {
            return false;
        }
        IWorkbenchPage activePage = w.getActivePage();
        if (activePage == null) {
            return false;
        }
        return activePage == this.getSite().getPage() && activePage.getActivePart() == this;
    }

    @Override
    public boolean isVisible() {
        return this.getSite().getPage().isPartVisible(this.getSite().getPart());
    }

    @Override
    public void setStatusLineMessage(Image image, String message) {
        this.getEditorSite().getActionBars().getStatusLineManager().setMessage(image, message);
    }

    protected void handleScoutPropertyChange(String name, Object newValue) {
        if (name.equals("title")) {
            this.setTitleFromScout((String)newValue);
        } else if (name.equals("iconId")) {
            this.setImageFromScout((String)newValue);
        } else if (name.equals("minimizeEnabled")) {
            this.setMinimizeEnabledFromScout((Boolean)newValue);
        } else if (name.equals("maximizeEnabled")) {
            this.setMaximizeEnabledFromScout((Boolean)newValue);
        } else if (name.equals("minimized")) {
            this.setMinimizedFromScout((Boolean)newValue);
        } else if (name.equals("maximized")) {
            this.setMaximizedFromScout((Boolean)newValue);
        }
    }

    private class P_EditorListener
    extends PartListener {
        private P_EditorListener() {
        }

        @Override
        public void partClosed(IWorkbenchPartReference partRef) {
            IWorkbenchPart part = partRef.getPart(false);
            if (part != null && part.equals(AbstractScoutEditorPart.this.getEditorSite().getPart())) {
                AbstractScoutEditorPart.this.handleClosedFromUI();
            }
        }

        @Override
        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false).equals(AbstractScoutEditorPart.this.getEditorSite().getPart())) {
                AbstractScoutEditorPart.this.handlePartActivatedFromUI();
            }
        }
    }

    private class P_ScoutPropertyChangeListener
    implements PropertyChangeListener {
        private P_ScoutPropertyChangeListener() {
        }

        @Override
        public void propertyChange(final PropertyChangeEvent e) {
            Runnable t = new Runnable(){

                @Override
                public void run() {
                    AbstractScoutEditorPart.this.handleScoutPropertyChange(e.getPropertyName(), e.getNewValue());
                }
            };
            AbstractScoutEditorPart.this.getSwtEnvironment().invokeSwtLater(t);
        }
    }
}

