/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.desktop.menu;

import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;

public final class DesktopUtility {
    private DesktopUtility() {
    }

    public static IAction findDesktopMenu(String qName, ISwtEnvironment environment) {
        IClientSession clientSession = environment.getClientSession();
        if (clientSession != null && clientSession.getDesktop() != null) {
            for (IMenu menu : clientSession.getDesktop().getMenus()) {
                IAction found = DesktopUtility.findActionImplRec(qName, (IAction)menu);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    private static IAction findActionImplRec(String qName, IAction action) {
        if (action.getClass().getName().equals(qName)) {
            return action;
        }
        if (action instanceof IActionNode) {
            IActionNode actionNode = (IActionNode)action;
            for (IAction subMenu : actionNode.getChildActions()) {
                IAction found = DesktopUtility.findActionImplRec(qName, subMenu);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static IAction findToolAction(String qName, ISwtEnvironment environment) {
        IClientSession clientSession = environment.getClientSession();
        if (clientSession != null && clientSession.getDesktop() != null) {
            for (IAction a : clientSession.getDesktop().getActions()) {
                IAction found = DesktopUtility.findActionImplRec(qName, a);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }
}

