/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swt.window.popup;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.ui.swt.DefaultValidateRoot;
import org.eclipse.scout.rt.ui.swt.ISwtEnvironment;
import org.eclipse.scout.rt.ui.swt.window.popup.SwtScoutPopup;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;

public class SwtScoutDropDownPopup
extends SwtScoutPopup {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtScoutDropDownPopup.class);
    private final Listener m_viewPortChangedListener = new P_ViewPortChangedListener();
    private Set<ScrollBar> scrollBars;

    public SwtScoutDropDownPopup(ISwtEnvironment env, Control ownerComponent, boolean takeFocusOnOpen, int style) {
        super(env, ownerComponent, takeFocusOnOpen, style);
        this.getShell().setData("LayoutValidateManager.validateRoot", (Object)new DefaultValidateRoot((Composite)this.getShell()){

            @Override
            public void validate() {
                SwtScoutDropDownPopup.this.autoAdjustBounds();
            }
        });
    }

    @Override
    protected void onPopupOpened() {
        this.scrollBars = SwtScoutDropDownPopup.findScrollbarsInHierarchy(this.getOwnerComponent());
        SwtScoutDropDownPopup.installScrollListeners(this.scrollBars, this.m_viewPortChangedListener);
        this.getOwnerComponent().getShell().addListener(10, this.m_viewPortChangedListener);
        this.getOwnerComponent().getShell().addListener(11, this.m_viewPortChangedListener);
        super.onPopupOpened();
    }

    @Override
    protected void onPopupClosed() {
        SwtScoutDropDownPopup.uninstallScrollListeners(this.scrollBars, this.m_viewPortChangedListener);
        this.scrollBars = null;
        Shell shell = this.getOwnerShell();
        if (shell != null) {
            this.getOwnerComponent().getShell().removeListener(10, this.m_viewPortChangedListener);
            this.getOwnerComponent().getShell().removeListener(11, this.m_viewPortChangedListener);
        }
        super.onPopupClosed();
    }

    private static void installScrollListeners(Set<ScrollBar> scrollBars, Listener listener) {
        for (ScrollBar scrollBar : scrollBars) {
            scrollBar.addListener(13, listener);
        }
    }

    private static void uninstallScrollListeners(Set<ScrollBar> scrollBars, Listener listener) {
        if (scrollBars == null) {
            return;
        }
        for (ScrollBar scrollBar : scrollBars) {
            if (scrollBar.isDisposed()) continue;
            scrollBar.removeListener(13, listener);
        }
    }

    private static Set<ScrollBar> findScrollbarsInHierarchy(Control control) {
        ScrollBar vBar;
        HashSet<ScrollBar> scrollBars = new HashSet<ScrollBar>();
        if (!(control instanceof Composite)) {
            return Collections.emptySet();
        }
        Composite composite = (Composite)control;
        ScrollBar hBar = composite.getHorizontalBar();
        if (hBar != null) {
            scrollBars.add(hBar);
        }
        if ((vBar = composite.getVerticalBar()) != null) {
            scrollBars.add(vBar);
        }
        scrollBars.addAll(SwtScoutDropDownPopup.findScrollbarsInHierarchy((Control)control.getParent()));
        return scrollBars;
    }

    private Shell getOwnerShell() {
        Control ownerComponent = this.getOwnerComponent();
        if (ownerComponent.isDisposed()) {
            return null;
        }
        Shell shell = ownerComponent.getShell();
        if (shell.isDisposed()) {
            return null;
        }
        return shell;
    }

    private class P_ViewPortChangedListener
    implements Listener {
        private P_ViewPortChangedListener() {
        }

        public void handleEvent(Event event) {
            if (SwtScoutDropDownPopup.this.getShell().isDisposed()) {
                return;
            }
            event.type = 27;
            SwtScoutDropDownPopup.this.getShell().notifyListeners(27, event);
        }
    }
}

