/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.parsers.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.parsers.BindModel;
import org.eclipse.scout.commons.parsers.BindParser;
import org.eclipse.scout.commons.parsers.sql.SqlParserToken;
import org.eclipse.scout.commons.parsers.token.IToken;
import org.eclipse.scout.commons.parsers.token.TextToken;

public class SqlParser {
    private static IScoutLogger logger = ScoutLogManager.getLogger(SqlParser.class);
    private static final String nameChars = "a-zA-Z0-9_$.@:?";
    private static final Pattern COMMENT_PAT = Pattern.compile("(\\{[^\\}]*\\})");
    private static final Pattern APOS_PAT = Pattern.compile("('[^']*')");
    private static final Pattern QUOT_PAT = Pattern.compile("(\"[^\"]*\")");
    private static final Pattern UNION_PAT = Pattern.compile("[^a-zA-Z0-9_$.@:?](UNION ALL|INTERSECT|MINUS|UNION)[^a-zA-Z0-9_$.@:?]");
    private static final Pattern PART_PAT = Pattern.compile("[^a-zA-Z0-9_$.@:?](WITH|AS|SELECT|FROM|LEFT JOIN|OUTER JOIN|INNER JOIN|JOIN|ON|WHERE|GROUP BY|HAVING|ORDER BY|INSERT INTO|INSERT|INTO|CONNECT BY( NOCYCLE)?|START WITH|UPDATE|DELETE FROM|DELETE|SET|VALUES|CASE|ELSE|END|THEN|WHEN)[^a-zA-Z0-9_$.@:?]");
    private static final Pattern OUTER_JOIN_PAT = Pattern.compile("(\\(\\+\\))");
    private static final Pattern OR_OP_PAT = Pattern.compile("[^a-zA-Z0-9_$.@:?](OR)[^a-zA-Z0-9_$.@:?]");
    private static final Pattern AND_OP_PAT = Pattern.compile("[^a-zA-Z0-9_$.@:?](AND)[^a-zA-Z0-9_$.@:?]");
    private static final Pattern MATH_OP_PAT1 = Pattern.compile("[^a-zA-Z0-9_$.@:?](NOT IN|IN|IS NOT|IS|NOT BETWEEN|BETWEEN|NOT LIKE|LIKE)[^a-zA-Z0-9_$.@:?]");
    private static final Pattern MATH_OP_PAT2 = Pattern.compile("(=|<>|!=|<=|>=|<|>|\\%|\\^|\\+|\\-|\\*|/|\\|\\||\\&\\&)");
    private static final Pattern UNARY_PREFIX_PAT = Pattern.compile("[^a-zA-Z0-9_$.@:?](NOT|DISTINCT|NEW)[^a-zA-Z0-9_$.@:?]");
    private static final Pattern NAME_PAT = Pattern.compile("([a-zA-Z0-9_$.@:?]+)");
    private static final Pattern OPEN_BRACKET_PAT = Pattern.compile("([(])");
    private static final Pattern CLOSE_BRACKET_PAT = Pattern.compile("([)])");
    private static final Pattern LIST_SEPARATOR_PAT = Pattern.compile("([,])");

    public SqlParserToken.Statement parse(String s) {
        SqlParserToken.BracketExpr be;
        ParseContext ctx = new ParseContext();
        List<SqlParserToken.IToken> list = this.tokenize(s, ctx);
        SqlParserToken.Statement stm = this.parseStatement(list, ctx);
        if (stm == null && (be = this.parseBracketExpr(list = this.tokenize(s, ctx = new ParseContext()), ctx)) != null) {
            for (SqlParserToken.IToken t : be.getChildren()) {
                if (!(t instanceof SqlParserToken.Statement)) continue;
                stm = (SqlParserToken.Statement)t;
                break;
            }
        }
        if (list.size() > 0) {
            SqlParserToken.Unparsed up = new SqlParserToken.Unparsed();
            up.setText(this.flatten(list));
            if (stm == null) {
                stm = new SqlParserToken.Statement();
            }
            stm.addChild(up);
        }
        return stm;
    }

    private SqlParserToken.Statement parseStatement(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("Statement", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.UnionToken u;
            SqlParserToken.IToken ss = this.parseSingleStatement(list, ctx);
            if (ss == null) {
                return null;
            }
            SqlParserToken.Statement s = new SqlParserToken.Statement();
            s.addChild(ss);
            SqlParserToken.IToken nexts = null;
            while ((u = this.removeToken(list, SqlParserToken.UnionToken.class)) != null && (nexts = this.parseSingleStatement(list, ctx)) != null) {
                s.addChild(u);
                s.addChild(nexts);
            }
            if (u != null && nexts == null) {
                list.add(0, u);
            }
            SqlParserToken.Statement statement = s;
            return statement;
        }
        finally {
            ctx.remove(lock);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SqlParserToken.IToken parseSingleStatement(List<SqlParserToken.IToken> list, ParseContext ctx) {
        block16: {
            lock = ctx.checkAndAdd("SingleStatement", list);
            if (lock == null) {
                return null;
            }
            backup = new ArrayList<SqlParserToken.IToken>(list);
            be = this.parseBracketExpr(list, ctx);
            if (be == null) break block16;
            tmp = be;
            if (true) ** GOTO lbl31
        }
        ss = new SqlParserToken.SingleStatement();
        p = this.parsePart(list, ctx, true);
        if (p == null) {
            ctx.remove(lock);
            return null;
        }
        ss.addChild(p);
        if (true) ** GOTO lbl41
        do {
            if ((ch = tmp.getChildren().get(1)) instanceof SqlParserToken.BracketExpr) {
                tmp = (SqlParserToken.BracketExpr)ch;
                continue;
            }
            if (ch instanceof SqlParserToken.Statement) {
                var9_10 = be;
                ctx.remove(lock);
                return var9_10;
            }
            if (ch instanceof SqlParserToken.SingleStatement) {
                var9_11 = be;
                ctx.remove(lock);
                return var9_11;
            }
            tmp = null;
lbl31:
            // 3 sources

        } while (tmp != null);
        list.clear();
        list.addAll(backup);
        ctx.remove(lock);
        return null;
        do {
            ss.addChild(p);
lbl41:
            // 2 sources

        } while ((p = this.parsePart(list, ctx, false)) != null);
        if (ss.getChildren().size() == 0) {
            ctx.remove(lock);
            return null;
        }
        ** try [egrp 5[TRYBLOCK] [5 : 227->231)] { 
lbl46:
        // 1 sources

        return ss;
lbl47:
        // 1 sources

        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.Part parsePart(List<SqlParserToken.IToken> list, ParseContext ctx, boolean rootPart) {
        ParseStep lock = ctx.checkAndAdd("Part", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.PartToken pt = this.removeToken(list, SqlParserToken.PartToken.class);
            if (pt == null || rootPart && !this.isRootPartToken(pt)) {
                if (pt != null) {
                    list.add(0, pt);
                }
                return null;
            }
            SqlParserToken.ListExpr le = this.parseListExpr(list, ctx);
            SqlParserToken.Part p = new SqlParserToken.Part();
            p.addChild(pt);
            if (le != null) {
                p.addChild(le);
            }
            SqlParserToken.Part part = p;
            return part;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private boolean isRootPartToken(SqlParserToken.PartToken pt) {
        String s = pt.getText();
        if ("SELECT".equals(s)) {
            return true;
        }
        if ("INSERT INTO".equals(s)) {
            return true;
        }
        if ("INSERT".equals(s)) {
            return true;
        }
        if ("UPDATE".equals(s)) {
            return true;
        }
        if ("DELETE FROM".equals(s)) {
            return true;
        }
        if ("DELETE".equals(s)) {
            return true;
        }
        if ("CASE".equals(s)) {
            return true;
        }
        return "WITH".equals(s);
    }

    private SqlParserToken.ListExpr parseListExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("ListExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.OrExpr oe = this.parseOrExpr(list, ctx);
            if (oe == null) {
                return null;
            }
            SqlParserToken.ListExpr le = new SqlParserToken.ListExpr();
            le.addChild(oe);
            SqlParserToken.ListSeparator ls = null;
            while ((ls = this.removeToken(list, SqlParserToken.ListSeparator.class)) != null && (oe = this.parseOrExpr(list, ctx)) != null) {
                le.addChild(ls);
                le.addChild(oe);
            }
            if (ls != null && oe == null) {
                list.add(0, ls);
            }
            SqlParserToken.ListExpr listExpr = le;
            return listExpr;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.OrExpr parseOrExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("OrExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.OrOp oo;
            SqlParserToken.AndExpr ae = this.parseAndExpr(list, ctx);
            if (ae == null) {
                return null;
            }
            SqlParserToken.OrExpr oe = new SqlParserToken.OrExpr();
            oe.addChild(ae);
            while ((oo = this.removeToken(list, SqlParserToken.OrOp.class)) != null && (ae = this.parseAndExpr(list, ctx)) != null) {
                oe.addChild(oo);
                oe.addChild(ae);
            }
            if (oo != null) {
                oo.addComment(new SqlParserToken.Comment("/*syntax warning*/"));
                oe.addChild(oo);
            }
            SqlParserToken.OrExpr orExpr = oe;
            return orExpr;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.AndExpr parseAndExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("AndExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.AndOp ao;
            SqlParserToken.MathExpr me = this.parseMathExpr(list, ctx);
            if (me == null) {
                return null;
            }
            SqlParserToken.AndExpr ae = new SqlParserToken.AndExpr();
            ae.addChild(me);
            while ((ao = this.removeToken(list, SqlParserToken.AndOp.class)) != null && (me = this.parseMathExpr(list, ctx)) != null) {
                ae.addChild(ao);
                ae.addChild(me);
            }
            if (ao != null) {
                ao.addComment(new SqlParserToken.Comment("/*syntax warning*/"));
                ae.addChild(ao);
            }
            SqlParserToken.AndExpr andExpr = ae;
            return andExpr;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.MathExpr parseMathExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("MathExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.MathOp mo;
            SqlParserToken.IToken se = this.parseSimpleExpr(list, ctx);
            if (se == null) {
                return null;
            }
            SqlParserToken.MathExpr me = new SqlParserToken.MathExpr();
            me.addChild(se);
            while ((mo = this.removeToken(list, SqlParserToken.MathOp.class)) != null && (se = this.parseSimpleExpr(list, ctx)) != null) {
                me.addChild(mo);
                me.addChild(se);
            }
            if (mo != null && se == null) {
                list.add(0, mo);
            }
            SqlParserToken.MathExpr mathExpr = me;
            return mathExpr;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.IToken parseSimpleExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("SimpleExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.AbstractToken t = this.parseUnaryPrefixExpr(list, ctx);
            if (t != null) {
                SqlParserToken.UnaryPrefixExpr unaryPrefixExpr = t;
                return unaryPrefixExpr;
            }
            t = this.parseMinusExpr(list, ctx);
            if (t != null) {
                SqlParserToken.AbstractToken abstractToken = t;
                return abstractToken;
            }
            t = this.parseAtom(list, ctx);
            if (t != null) {
                SqlParserToken.AbstractToken abstractToken = t;
                return abstractToken;
            }
            return null;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.UnaryPrefixExpr parseUnaryPrefixExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("UnaryPrefixExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.UnaryPrefix up = null;
            SqlParserToken.Atom a = null;
            up = this.removeToken(list, SqlParserToken.UnaryPrefix.class);
            if (up == null || (a = this.parseAtom(list, ctx)) == null) {
                if (up != null && a == null) {
                    list.add(0, up);
                }
                return null;
            }
            SqlParserToken.UnaryPrefixExpr e = new SqlParserToken.UnaryPrefixExpr();
            e.addChild(up);
            e.addChild(a);
            SqlParserToken.UnaryPrefixExpr unaryPrefixExpr = e;
            return unaryPrefixExpr;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.MinusExpr parseMinusExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("MinusExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.MathOp mo = null;
            SqlParserToken.Atom a = null;
            mo = this.removeToken(list, SqlParserToken.MathOp.class, "-");
            if (mo == null || (a = this.parseAtom(list, ctx)) == null) {
                if (mo != null && a == null) {
                    list.add(0, mo);
                }
                return null;
            }
            SqlParserToken.MinusExpr e = new SqlParserToken.MinusExpr();
            e.addChild(mo);
            e.addChild(a);
            SqlParserToken.MinusExpr minusExpr = e;
            return minusExpr;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.FunExpr parseFunExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("FunExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.Name nm = null;
            SqlParserToken.BracketExpr be = null;
            nm = this.removeToken(list, SqlParserToken.Name.class);
            if (nm == null || (be = this.parseBracketExpr(list, ctx)) == null) {
                if (nm != null && be == null) {
                    list.add(0, nm);
                }
                return null;
            }
            SqlParserToken.FunExpr e = new SqlParserToken.FunExpr();
            e.addChild(nm);
            e.addChild(be);
            SqlParserToken.FunExpr funExpr = e;
            return funExpr;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.BracketExpr parseBracketExpr(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("BracketExpr", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.OpenBracketToken open = null;
            SqlParserToken.AbstractToken t = null;
            SqlParserToken.CloseBracketToken close = null;
            ArrayList<SqlParserToken.IToken> backup = new ArrayList<SqlParserToken.IToken>(list);
            open = this.removeToken(list, SqlParserToken.OpenBracketToken.class);
            if (open == null || (t = this.parseStatement(list, ctx)) == null && (t = this.parseListExpr(list, ctx)) == null && t != null || (close = this.removeToken(list, SqlParserToken.CloseBracketToken.class)) == null) {
                list.clear();
                list.addAll(backup);
                return null;
            }
            SqlParserToken.BracketExpr e = new SqlParserToken.BracketExpr();
            e.addChild(open);
            if (t != null) {
                e.addChild(t);
            }
            e.addChild(close);
            SqlParserToken.BracketExpr bracketExpr = e;
            return bracketExpr;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private SqlParserToken.Atom parseAtom(List<SqlParserToken.IToken> list, ParseContext ctx) {
        ParseStep lock = ctx.checkAndAdd("Atom", list);
        if (lock == null) {
            return null;
        }
        try {
            SqlParserToken.AbstractToken t = null;
            t = this.parseBracketExpr(list, ctx);
            if (t == null && (t = this.parseStatement(list, ctx)) == null && (t = this.parseOrExpr(list, ctx)) == null && (t = this.parseFunExpr(list, ctx)) == null && (t = this.removeToken(list, SqlParserToken.Name.class)) == null && (t = this.removeToken(list, SqlParserToken.Text.class)) == null && (t = this.removeToken(list, SqlParserToken.MathOp.class, "*")) == null) {
                return null;
            }
            SqlParserToken.Atom a = new SqlParserToken.Atom();
            a.addChild(t);
            t = this.removeToken(list, SqlParserToken.OuterJoinToken.class);
            if (t != null) {
                a.addChild(t);
            }
            if ((t = this.removeToken(list, SqlParserToken.Name.class)) != null) {
                a.addChild(t);
            }
            SqlParserToken.Atom atom = a;
            return atom;
        }
        finally {
            ctx.remove(lock);
        }
    }

    private <T extends SqlParserToken.IToken> T removeToken(List<SqlParserToken.IToken> list, Class<T> tokenType) {
        if (list.size() > 0 && tokenType.isAssignableFrom(list.get(0).getClass())) {
            return (T)list.remove(0);
        }
        return null;
    }

    private <T extends SqlParserToken.IToken> T removeToken(List<SqlParserToken.IToken> list, Class<T> tokenType, String text) {
        if (list.size() > 0 && tokenType.isAssignableFrom(list.get(0).getClass()) && text.equals(list.get(0).getText())) {
            return (T)list.remove(0);
        }
        return null;
    }

    private List<SqlParserToken.IToken> tokenize(String s, ParseContext ctx) {
        SqlParserToken.IToken item;
        s = this.encodeBinds(s, ctx);
        s = s.replaceAll("[\\n\\r]+", " ");
        List<SqlParserToken.IToken> list = new ArrayList<SqlParserToken.IToken>();
        list.add(new SqlParserToken.Raw(s));
        list = this.tokenizeRaw(list, COMMENT_PAT, SqlParserToken.Comment.class, true);
        list = this.tokenizeRaw(list, APOS_PAT, SqlParserToken.Text.class, true);
        list = this.tokenizeRaw(list, APOS_PAT, SqlParserToken.Text.class, false);
        list = this.tokenizeRaw(list, QUOT_PAT, SqlParserToken.Name.class, true);
        list = this.tokenizeRaw(list, QUOT_PAT, SqlParserToken.Name.class, false);
        for (SqlParserToken.IToken item2 : list) {
            if (!(item2 instanceof SqlParserToken.Raw)) continue;
            String text = item2.getText();
            text = text.replaceAll("[\\s]+", " ");
            text = text.toUpperCase();
            item2.setText(text);
        }
        list = this.tokenizeRaw(list, UNION_PAT, SqlParserToken.UnionToken.class, false);
        list = this.tokenizeRaw(list, PART_PAT, SqlParserToken.PartToken.class, false);
        list = this.tokenizeRaw(list, OUTER_JOIN_PAT, SqlParserToken.OuterJoinToken.class, false);
        list = this.tokenizeRaw(list, OR_OP_PAT, SqlParserToken.OrOp.class, false);
        list = this.tokenizeRaw(list, AND_OP_PAT, SqlParserToken.AndOp.class, false);
        list = this.tokenizeRaw(list, MATH_OP_PAT1, SqlParserToken.MathOp.class, false);
        list = this.tokenizeRaw(list, MATH_OP_PAT2, SqlParserToken.MathOp.class, false);
        list = this.tokenizeRaw(list, UNARY_PREFIX_PAT, SqlParserToken.UnaryPrefix.class, false);
        list = this.tokenizeRaw(list, NAME_PAT, SqlParserToken.Name.class, false);
        list = this.tokenizeRaw(list, OPEN_BRACKET_PAT, SqlParserToken.OpenBracketToken.class, false);
        list = this.tokenizeRaw(list, CLOSE_BRACKET_PAT, SqlParserToken.CloseBracketToken.class, false);
        list = this.tokenizeRaw(list, LIST_SEPARATOR_PAT, SqlParserToken.ListSeparator.class, false);
        Iterator<SqlParserToken.IToken> it = list.iterator();
        while (it.hasNext()) {
            item = it.next();
            if (!(item instanceof SqlParserToken.Raw) || StringUtility.hasText(item.getText())) continue;
            it.remove();
        }
        int i = 0;
        while (i < list.size()) {
            SqlParserToken.IToken tok = list.get(i);
            if (tok instanceof SqlParserToken.Raw) {
                list.remove(i);
                SqlParserToken.Comment c = new SqlParserToken.Comment();
                c.setText("/*XXX unexpected token: " + tok.getText() + "*/");
                list.add(i, c);
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof SqlParserToken.Comment) {
                SqlParserToken.IToken succ = null;
                int k = i + 1;
                while (k < list.size()) {
                    if (!(list.get(k) instanceof SqlParserToken.Comment)) {
                        succ = list.get(k);
                        break;
                    }
                    ++k;
                }
                if (succ == null) {
                    k = 0;
                    while (k < list.size()) {
                        if (!(list.get(k) instanceof SqlParserToken.Comment)) {
                            succ = list.get(k);
                            break;
                        }
                        ++k;
                    }
                }
                if (succ != null) {
                    succ.addComment((SqlParserToken.Comment)list.get(i));
                }
            }
            ++i;
        }
        it = list.iterator();
        while (it.hasNext()) {
            item = it.next();
            if (!(item instanceof SqlParserToken.Comment)) continue;
            it.remove();
        }
        this.decodeBinds(list, ctx);
        return list;
    }

    private List<SqlParserToken.IToken> tokenizeRaw(List<SqlParserToken.IToken> list, Pattern p, Class<? extends SqlParserToken.IToken> tokenType, boolean transcodeDelimiters) {
        ArrayList<SqlParserToken.IToken> newList = new ArrayList<SqlParserToken.IToken>(list.size());
        for (SqlParserToken.IToken item : list) {
            if (item instanceof SqlParserToken.Raw) {
                String r;
                String s = ((SqlParserToken.Raw)item).getText();
                if (transcodeDelimiters) {
                    s = this.encodeDelimiters(s);
                }
                s = " " + s + " ";
                Matcher m = p.matcher(s);
                int lastEnd = 0;
                while (lastEnd < s.length() && m.find(lastEnd)) {
                    SqlParserToken.IToken t;
                    r = s.substring(lastEnd, m.start(1));
                    if (transcodeDelimiters) {
                        r = this.decodeDelimiters(r);
                    }
                    newList.add(new SqlParserToken.Raw(r.trim()));
                    r = m.group(1);
                    if (transcodeDelimiters) {
                        r = this.decodeDelimiters(r);
                    }
                    try {
                        t = tokenType.newInstance();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    t.setText(r);
                    newList.add(t);
                    lastEnd = m.end(1);
                }
                if (lastEnd >= s.length()) continue;
                r = s.substring(lastEnd);
                if (transcodeDelimiters) {
                    r = this.decodeDelimiters(r);
                }
                newList.add(new SqlParserToken.Raw(r.trim()));
                continue;
            }
            newList.add(item);
        }
        return newList;
    }

    private String encodeBinds(String s, ParseContext ctx) {
        BindModel m = new BindParser(s).parse();
        IToken[] iTokenArray = m.getAllTokens();
        int n = iTokenArray.length;
        int n2 = 0;
        while (n2 < n) {
            IToken bindToken = iTokenArray[n2];
            if (!(bindToken instanceof TextToken)) {
                String code = "___BIND" + ctx.getBinds().size();
                String name = bindToken.getParsedToken();
                bindToken.setReplaceToken(code);
                ctx.getBinds().put(code, name);
            }
            ++n2;
        }
        return m.getFilteredStatement();
    }

    private void decodeBinds(List<SqlParserToken.IToken> list, ParseContext ctx) {
        for (SqlParserToken.IToken t : list) {
            String s;
            if (!(t instanceof SqlParserToken.Name) || (s = ctx.getBinds().get(t.getText())) == null) continue;
            t.setText(s);
        }
    }

    private String encodeDelimiters(String s) {
        s = s.replace("$", "$0");
        s = s.replace("{", "$1");
        s = s.replace("}", "$2");
        s = s.replace("''", "$3");
        s = s.replace("\"\"", "$4");
        s = s.replace("/*", "{");
        s = s.replace("*/", "}");
        return s;
    }

    private String decodeDelimiters(String s) {
        s = s.replace("}", "*/");
        s = s.replace("{", "/*");
        s = s.replace("$4", "\"\"");
        s = s.replace("$3", "''");
        s = s.replace("$2", "}");
        s = s.replace("$1", "{");
        s = s.replace("$0", "$");
        return s;
    }

    private String flatten(List<SqlParserToken.IToken> list) {
        StringBuffer buf = new StringBuffer();
        for (SqlParserToken.IToken item : list) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(item);
        }
        return buf.toString();
    }

    private static class ParseContext {
        private HashSet<ParseStep> m_steps = new HashSet();
        private HashMap<String, String> m_bindMap = new HashMap();

        public Map<String, String> getBinds() {
            return this.m_bindMap;
        }

        public ParseStep checkAndAdd(String method, List<SqlParserToken.IToken> list) {
            ParseStep step = new ParseStep(method, list.size() > 0 ? list.get(0) : null);
            if (this.m_steps.contains(step)) {
                return null;
            }
            this.m_steps.add(step);
            return step;
        }

        public void remove(ParseStep step) {
            this.m_steps.remove(step);
        }
    }

    private static class ParseStep {
        private final String m_method;
        private final SqlParserToken.IToken m_token;

        public ParseStep(String method, SqlParserToken.IToken token) {
            this.m_method = method;
            this.m_token = token;
        }

        public int hashCode() {
            return this.m_method.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ParseStep)) {
                return false;
            }
            ParseStep o = (ParseStep)obj;
            return this.m_method.equals(o.m_method) && this.m_token == o.m_token;
        }

        public String toString() {
            return String.valueOf(this.m_method) + ": " + this.m_token;
        }
    }
}

