/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.security;

import java.security.AccessController;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.xml.ws.WebServiceException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.security.SimplePrincipal;
import org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy;

public class Authenticator {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(Authenticator.class);

    public static boolean isSubjectAuthenticated() {
        Subject subject = Subject.getSubject(AccessController.getContext());
        return subject != null && subject.getPrincipals().size() > 0;
    }

    public static boolean authenticateRequest(ICredentialValidationStrategy strategy, String username, String passwordPlainText) {
        Subject subject = Subject.getSubject(AccessController.getContext());
        if (subject == null) {
            throw new WebServiceException("Webservice request was blocked due to security reasons: request must run on behalf of a subject context.");
        }
        if (subject.getPrincipals().size() > 0) {
            return true;
        }
        if (subject.isReadOnly()) {
            throw new WebServiceException("Unexpected. Authenticated principal cannot be added to subject as it is readonly.");
        }
        if (strategy == null) {
            LOG.warn("No credential validation strategy configured.");
            return false;
        }
        if (!StringUtility.hasText((CharSequence)username) || !StringUtility.hasText((CharSequence)passwordPlainText)) {
            return false;
        }
        try {
            if (strategy.isValidUser(username, passwordPlainText)) {
                subject.getPrincipals().add((Principal)new SimplePrincipal(username));
                subject.setReadOnly();
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("user credential validation failed", (Throwable)e);
        }
        return false;
    }
}

