/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.util.pde.PluginModelHelper;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;

public class MissingClasspathEntryForJarFileCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private IFile m_stubJarFile;

    public MissingClasspathEntryForJarFileCommand(IScoutBundle bundle, String alias, IFile stubJarFile) {
        super("Stub JAR file '" + stubJarFile.getName() + "' is not on project classpath");
        this.m_bundle = bundle;
        this.m_stubJarFile = stubJarFile;
        this.setSolutionDescription("By using this task, the JAR file of the WS '" + alias + "' is registered on the project classpath.");
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        String jarFilePath = PathNormalizer.toJarPath(this.m_stubJarFile.getProjectRelativePath().toString());
        PluginModelHelper h = new PluginModelHelper(this.m_bundle.getProject());
        h.Manifest.addClasspathEntry(jarFilePath);
        h.save();
    }
}

