/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.resource;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.resource.IResourceListener;

public class ManagedResource {
    public static final int API_MODIFICATION_STAMP = Integer.MAX_VALUE;
    protected long m_modificationStamp;
    private IProject m_project;
    protected IFile m_file;
    protected Object m_fileLock;
    private Object m_registrationLock;
    private IResourceChangeListener m_jdtResourceChangedListener;
    private List<P_ResourceListenerEntry> m_resourceListeners;

    public ManagedResource(IProject project) {
        this.m_project = project;
        this.m_fileLock = new Object();
        this.m_registrationLock = new Object();
        this.m_resourceListeners = new ArrayList<P_ResourceListenerEntry>();
        this.m_jdtResourceChangedListener = new P_JdtResourceChangedListener();
    }

    private void attachJdtResourceChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.m_jdtResourceChangedListener);
    }

    private void detachJdtResourceChangeListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.m_jdtResourceChangedListener);
    }

    public void addResourceListener(IResourceListener listener) {
        this.addResourceListener(null, null, listener);
    }

    public void addResourceListener(String element, IResourceListener listener) {
        this.addResourceListener(element, null, listener);
    }

    public void addResourceListener(Integer event, IResourceListener listener) {
        this.addResourceListener(null, event, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceListener(String element, Integer event, IResourceListener listener) {
        P_ResourceListenerEntry entry = new P_ResourceListenerEntry();
        entry.setElement(element);
        entry.setEvent(event);
        entry.setListener(listener);
        Object object = this.m_registrationLock;
        synchronized (object) {
            if (this.m_resourceListeners.size() == 0) {
                this.attachJdtResourceChangeListener();
            }
            this.m_resourceListeners.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceListener(IResourceListener listener) {
        Object object = this.m_registrationLock;
        synchronized (object) {
            P_ResourceListenerEntry[] p_ResourceListenerEntryArray = this.m_resourceListeners.toArray(new P_ResourceListenerEntry[this.m_resourceListeners.size()]);
            int n = p_ResourceListenerEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                P_ResourceListenerEntry entry = p_ResourceListenerEntryArray[n2];
                if (entry.getListener() == listener) {
                    this.m_resourceListeners.remove(entry);
                }
                ++n2;
            }
            if (this.m_resourceListeners.size() == 0) {
                this.detachJdtResourceChangeListener();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFile getFile() {
        Object object = this.m_fileLock;
        synchronized (object) {
            return this.m_file;
        }
    }

    public boolean isSameFile(IFile file) {
        if (file == null || this.m_file == null) {
            return false;
        }
        return file.getProjectRelativePath().equals((Object)this.m_file.getProjectRelativePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFile(IFile file) {
        Object object = this.m_fileLock;
        synchronized (object) {
            this.m_modificationStamp = -1L;
            this.m_file = file;
        }
    }

    public boolean existsFile() {
        return this.m_file != null && this.m_file.exists();
    }

    protected long getModificationStamp() {
        return this.m_modificationStamp;
    }

    protected void setModificationStamp(long modificationStamp) {
        this.m_modificationStamp = modificationStamp;
    }

    public void touch() {
        this.m_modificationStamp = -1L;
    }

    protected void notifyResourceListeners(String element, Integer event) {
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        if (event == null) {
            throw new IllegalArgumentException("event must not be null");
        }
        HashSet<IResourceListener> listenersProcessed = new HashSet<IResourceListener>();
        P_ResourceListenerEntry[] p_ResourceListenerEntryArray = this.m_resourceListeners.toArray(new P_ResourceListenerEntry[this.m_resourceListeners.size()]);
        int n = p_ResourceListenerEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                P_ResourceListenerEntry entry = p_ResourceListenerEntryArray[n2];
                if (!(listenersProcessed.contains(entry.getListener()) || entry.getElement() != null && !entry.getElement().equals(element) || entry.getEvent() != null && (entry.getEvent() & event) <= 0)) {
                    try {
                        try {
                            entry.getListener().changed(element, event);
                        }
                        catch (Exception e) {
                            JaxWsSdk.logError("Error occured while notifying listener about change", e);
                            listenersProcessed.add(entry.getListener());
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        listenersProcessed.add(entry.getListener());
                        throw throwable;
                    }
                    listenersProcessed.add(entry.getListener());
                }
            }
            ++n2;
        }
    }

    private class P_JdtResourceChangedListener
    implements IResourceChangeListener {
        private P_JdtResourceChangedListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (ManagedResource.this.m_file == null) {
                return;
            }
            if (event.getType() != 1) {
                return;
            }
            try {
                IResourceDelta rootDelta = event.getDelta();
                rootDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (delta.getKind() == 2 || delta.getKind() == 262144 || delta.getKind() == 1 || delta.getKind() == 4 && (delta.getFlags() & 0x100) != 0) {
                            IResource candidate = delta.getResource();
                            if (candidate.getType() != 1) {
                                return true;
                            }
                            if (candidate.getProject() != ManagedResource.this.m_project) {
                                return false;
                            }
                            if (CompareUtility.equals((Object)candidate, (Object)((P_JdtResourceChangedListener)P_JdtResourceChangedListener.this).ManagedResource.this.m_file)) {
                                if (((P_JdtResourceChangedListener)P_JdtResourceChangedListener.this).ManagedResource.this.m_modificationStamp != Integer.MAX_VALUE && (((P_JdtResourceChangedListener)P_JdtResourceChangedListener.this).ManagedResource.this.m_modificationStamp == -1L || ((P_JdtResourceChangedListener)P_JdtResourceChangedListener.this).ManagedResource.this.m_modificationStamp != ((P_JdtResourceChangedListener)P_JdtResourceChangedListener.this).ManagedResource.this.m_file.getModificationStamp())) {
                                    ManagedResource.this.notifyResourceListeners("", 1);
                                }
                                return false;
                            }
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                JaxWsSdk.logError("Unexpected error occured while intercepting 'Resource Change' event.", e);
            }
        }
    }

    private class P_ResourceListenerEntry {
        private IResourceListener m_listener;
        private String m_element;
        private Integer m_event;

        private P_ResourceListenerEntry() {
        }

        public IResourceListener getListener() {
            return this.m_listener;
        }

        public void setListener(IResourceListener listener) {
            this.m_listener = listener;
        }

        public String getElement() {
            return this.m_element;
        }

        public void setElement(String element) {
            this.m_element = element;
        }

        public Integer getEvent() {
            return this.m_event;
        }

        public void setEvent(Integer event) {
            this.m_event = event;
        }
    }
}

